#!/usr/bin/perl -w

$filename="lat2-ziav16.psf";
$outfile="../src/font.inc";

$psf=`cat $filename`;
$len=length($psf);
$len>=4100 or die "File $filename too short";
$psf=substr($psf, 4, 4096);

open FD, ">$outfile" or die "Can't open file $outfile";

print FD "/* Automatically generated by psf2inc.pl */\n\n";
print FD "unsigned char font_vga[4096] = {\n    ";

for ($i=0; $i<4096; $i++){
    if ($i % 16==0){
        printf FD "\n     /* 0x%02x %d */\n    ", $i/16, $i/16;
    }
    printf FD "0x%02x", unpack ("C", substr($psf, $i, 1));
    if ($i!=4095) { 
        print FD ", "; 
        if ($i % 8==7) {
            print FD "\n    ";
        }
    }

}

print FD "\n};\n";
close FD;
