<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:risx="http://refdb.sourceforge.net/ns/risx/"
  version="1.0">

  <xsl:output method="html" indent="yes"/>

  <xsl:template match="risx:ris">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="risx:entry">
    <table rules="all">
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tbody>
        <tr>
          <td class="key">Type</td>
          <td class="value"><xsl:value-of select="@type"/></td>
        </tr>
        <tr>
          <td class="key">ID</td>
          <td class="value"><xsl:value-of select="@id"/></td>
        </tr>
        <tr>
          <td class="key">Citation Key</td>
          <td class="value"><xsl:value-of select="@citekey"/></td>
        </tr>
      </tbody>
    </table>

    <xsl:apply-templates select="risx:part"/>
    <xsl:apply-templates select="risx:publication"/>
    <xsl:apply-templates select="risx:set"/>
    <xsl:apply-templates select="risx:libinfo"/>
    <xsl:apply-templates select="risx:contents"/>
  </xsl:template>

  <xsl:template match="risx:part">
    <h3>Part Information</h3>
    <table rules="all">
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tbody>
        <xsl:apply-templates select="risx:title"/>
        <tr>
          <td class="key">Author</td>
          <td class="value">
            <xsl:apply-templates select="risx:author"/>
          </td>
        </tr>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="risx:publication">
    <h3>Publication Information</h3>
    <table rules="all">
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tbody>
        <xsl:apply-templates select="risx:title"/>
        <tr>
          <td class="key">Author</td>
          <td class="value">
            <xsl:apply-templates select="risx:author"/>
          </td>
        </tr>
        <xsl:apply-templates select="risx:pubinfo"/>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="risx:set">
    <h3>Set Information</h3>
    <table rules="all">
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tbody>
        <xsl:apply-templates select="risx:title"/>
        <tr>
          <td class="key">Author</td>
          <td class="value">
            <xsl:apply-templates select="risx:author"/>
          </td>
        </tr>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="risx:libinfo">
    <h3>Housekeeping Information (<xsl:value-of select="@user"/>)</h3>
    <table rules="all">
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tbody>
        <xsl:apply-templates/>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="risx:contents">
    <h3>Contents</h3>
    <table rules="all">
      <colgroup>
        <col width="1*"/>
        <col width="3*"/>
      </colgroup>
      <tbody>
        <xsl:apply-templates select="risx:abstract"/>
        <tr>
          <td class="key">Keyword</td>
          <td class="value"><xsl:apply-templates select="risx:keyword"/></td>
        </tr>
      </tbody>
    </table>
  </xsl:template>

  <xsl:template match="risx:title">
    <tr>
      <td class="key">Title (<xsl:value-of select="@type"/>)</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:author">
    <xsl:choose>
      <xsl:when test="risx:name">
        <xsl:value-of select="risx:name"/>
      </xsl:when>
      
      <xsl:otherwise>
        <xsl:value-of select="risx:lastname"/>
        <xsl:apply-templates select="risx:firstname"/>
        <xsl:if test="risx:middlename">
          <xsl:text> </xsl:text>
        </xsl:if>
        <xsl:apply-templates select="risx:middlename"/>
        <xsl:apply-templates select="risx:suffix"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@role">
      (<xsl:value-of select="@role"/>)
    </xsl:if>
    <xsl:if test="not(position() = last())">
      <xsl:text>; </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="risx:firstname">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="risx:middlename">
    <xsl:apply-templates/>
    <xsl:if test="not(position() = last())">
      <xsl:text> </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="risx:suffix">
    <xsl:text>, </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="risx:pubinfo">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="risx:pubdate">
    <tr>
      <td class="key">Date (<xsl:value-of select="@type"/>)</td>
      <td class="value"><xsl:value-of select="risx:date/risx:year"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:volume">
    <tr>
      <td class="key">Volume</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:issue">
    <tr>
      <td class="key">Issue</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:startpage">
    <tr>
      <td class="key">Pages</td>
      <td class="value">
        <xsl:value-of select="text()"/>
        <xsl:apply-templates select="../risx:endpage" mode="inline"/>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:endpage" mode="inline">
    <xsl:text>-</xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="risx:endpage">
    <!-- suppress output -->
  </xsl:template>

  <xsl:template match="risx:address">
    <tr>
      <td class="key">Address</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:city">
    <tr>
      <td class="key">City</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:publisher">
    <tr>
      <td class="key">Publisher</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:serial">
    <tr>
      <td class="key">Serial Number</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:link">
    <tr>
      <td class="key">Link (<xsl:value-of select="@type"/>)</td>
      <td class="value"><a href="{text()}"><xsl:value-of select="text()"/></a></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:notes">
    <tr>
      <td class="key">Notes</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:reprint">
    <tr>
      <td class="key">Reprint</td>
      <td class="value"><xsl:value-of select="@status"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:availability">
    <tr>
      <td class="key">Availability (<xsl:value-of select="@type"/>)</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:abstract">
    <tr>
      <td class="key">Abstract</td>
      <td class="value"><xsl:value-of select="text()"/></td>
    </tr>
  </xsl:template>

  <xsl:template match="risx:keyword">
    <xsl:apply-templates/>
    <xsl:if test="not(position() = last())">
      <xsl:text>; </xsl:text>
    </xsl:if>
  </xsl:template>

</xsl:stylesheet>
