% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-legend.r
\name{guide_legend}
\alias{guide_legend}
\title{Legend guide.}
\usage{
guide_legend(title = waiver(), title.position = NULL, title.theme = NULL,
  title.hjust = NULL, title.vjust = NULL, label = TRUE,
  label.position = NULL, label.theme = NULL, label.hjust = NULL,
  label.vjust = NULL, keywidth = NULL, keyheight = NULL,
  direction = NULL, default.unit = "line", override.aes = list(),
  nrow = NULL, ncol = NULL, byrow = FALSE, reverse = FALSE, order = 0,
  ...)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link{waiver}}), the name of the scale object or the name
specified in \code{\link{labs}} is used for the title.}

\item{title.position}{A character string indicating the position of a
 title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}

\item{title.theme}{A theme object for rendering the title text. Usually the
object of \code{\link{element_text}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link{theme}} or theme.}

\item{title.hjust}{A number specifying horizontal justification of the
title text.}

\item{title.vjust}{A number specifying vertical justification of the title
text.}

\item{label}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}

\item{label.position}{A character string indicating the position of a
label. One of "top", "bottom" (default for horizontal guide), "left", or
"right" (default for vertical guide).}

\item{label.theme}{A theme object for rendering the label text. Usually the
object of \code{\link{element_text}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link{theme}} or theme.}

\item{label.hjust}{A numeric specifying horizontal justification of the
label text.}

\item{label.vjust}{A numeric specifying vertical justification of the label
text.}

\item{keywidth}{A numeric or a \code{\link[grid]{unit}} object specifying
the width of the legend key. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link{theme}} or theme.}

\item{keyheight}{A numeric or a \code{\link[grid]{unit}} object specifying
the height of the legend key. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link{theme}} or theme.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{default.unit}{A character string indicating \code{\link[grid]{unit}}
for \code{keywidth} and \code{keyheight}.}

\item{override.aes}{A list specifying aesthetic parameters of legend key.
See details and examples.}

\item{nrow}{The desired number of rows of legends.}

\item{ncol}{The desired number of column of legends.}

\item{byrow}{logical. If \code{FALSE} (the default) the legend-matrix is
filled by columns, otherwise the legend-matrix is filled by rows.}

\item{reverse}{logical. If \code{TRUE} the order of legends is reversed.}

\item{order}{positive integer less that 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{...}{ignored.}
}
\value{
A guide object
}
\description{
Legend type guide shows key (i.e., geoms) mapped onto values.
Legend guides for various scales are integrated if possible.
}
\details{
Guides can be specified in each \code{scale_*} or in \code{\link{guides}}.
\code{guide="legend"} in \code{scale_*} is syntactic sugar for
\code{guide=guide_legend()} (e.g. \code{scale_color_manual(guide = "legend")}).
As for how to specify the guide for each scale in more detail,
see \code{\link{guides}}.
}
\examples{
\donttest{
df <- reshape2::melt(outer(1:4, 1:4), varnames = c("X1", "X2"))

p1 <- ggplot(df, aes(X1, X2)) + geom_tile(aes(fill = value))
p2 <- p1 + geom_point(aes(size = value))

# Basic form
p1 + scale_fill_continuous(guide = "legend")
p1 + scale_fill_continuous(guide = guide_legend())

# Guide title

p1 + scale_fill_continuous(guide = guide_legend(title = "V")) # title text
p1 + scale_fill_continuous(guide = guide_legend(title = NULL)) # no title

# Control styles

# key size
p1 + guides(fill = guide_legend(keywidth = 3, keyheight = 1))

# title position
p1 + guides(fill = guide_legend(title = "LEFT", title.position = "left"))

# title text styles via element_text
p1 + guides(fill = guide_legend(
  title.theme = element_text(size=15, face="italic", colour = "red", angle = 45)))

# label position
p1 + guides(fill = guide_legend(label.position = "bottom"))

# label styles
p1 + scale_fill_continuous(breaks = c(5, 10, 15),
  labels = paste("long", c(5, 10, 15)),
  guide = guide_legend(direction = "horizontal", title.position = "top",
    label.position="bottom", label.hjust = 0.5, label.vjust = 0.5,
    label.theme = element_text(angle = 90)))

# Set aesthetic of legend key

# very low alpha value make it difficult to see legend key
p3 <- ggplot(diamonds, aes(carat, price)) +
  geom_point(aes(colour=color), alpha=1/100)
p3

# override.aes overwrites the alpha
p3 + guides(colour = guide_legend(override.aes = list(alpha = 1)))

# multiple row/col legends
df <- data.frame(x = 1:20, y = 1:20, color = letters[1:20])
p <- ggplot(df, aes(x, y)) +
  geom_point(aes(colour = color))
p + guides(col = guide_legend(nrow = 8))
p + guides(col = guide_legend(ncol = 8))
p + guides(col = guide_legend(nrow = 8, byrow = TRUE))
p + guides(col = guide_legend(ncol = 8, byrow = TRUE))

# reversed order legend
p + guides(col = guide_legend(reverse = TRUE))
}
}
\seealso{
Other guides: \code{\link{guide_colourbar}},
  \code{\link{guides}}
}

