# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class DayTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.preview.bulk_exports.exports(resource_type="resource_type") \
                                            .days.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://preview.twilio.com/BulkExports/Exports/resource_type/Days',
        ))

    def test_read_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "days": [
                    {
                        "day": "2017-05-01",
                        "size": 1234,
                        "resource_type": "Calls"
                    }
                ],
                "meta": {
                    "key": "days",
                    "page_size": 50,
                    "url": "https://preview.twilio.com/BulkExports/Exports/Calls/Days?PageSize=50&Page=0",
                    "page": 0,
                    "first_page_url": "https://preview.twilio.com/BulkExports/Exports/Calls/Days?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "next_page_url": null
                }
            }
            '''
        ))

        actual = self.client.preview.bulk_exports.exports(resource_type="resource_type") \
                                                 .days.list()

        self.assertIsNotNone(actual)
