# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._configuration import SecurityCenterConfiguration
from .._utils.serialization import Deserializer, Serializer

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(scope: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/{scope}/providers/Microsoft.Security/customRecommendations")
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_request(scope: str, custom_recommendation_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/{scope}/providers/Microsoft.Security/customRecommendations/{customRecommendationName}"
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str"),
        "customRecommendationName": _SERIALIZER.url(
            "custom_recommendation_name",
            custom_recommendation_name,
            "str",
            pattern=r"[{]?[0-9a-fA-F]{8}-(?:[0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?$",
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_create_or_update_request(scope: str, custom_recommendation_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/{scope}/providers/Microsoft.Security/customRecommendations/{customRecommendationName}"
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str"),
        "customRecommendationName": _SERIALIZER.url(
            "custom_recommendation_name",
            custom_recommendation_name,
            "str",
            pattern=r"[{]?[0-9a-fA-F]{8}-(?:[0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?$",
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_delete_request(scope: str, custom_recommendation_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/{scope}/providers/Microsoft.Security/customRecommendations/{customRecommendationName}"
    )
    path_format_arguments = {
        "scope": _SERIALIZER.url("scope", scope, "str"),
        "customRecommendationName": _SERIALIZER.url(
            "custom_recommendation_name",
            custom_recommendation_name,
            "str",
            pattern=r"[{]?[0-9a-fA-F]{8}-(?:[0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?$",
        ),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


class CustomRecommendationsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.SecurityCenter`'s
        :attr:`custom_recommendations` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: PipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: SecurityCenterConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, scope: str, **kwargs: Any) -> ItemPaged["_models.CustomRecommendation"]:
        """Get a list of all relevant custom recommendations over a scope.

        :param scope: The scope of the custom recommendation. Valid scopes are: management group
         (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
         (format: 'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :return: An iterator like instance of either CustomRecommendation or the result of
         cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.security.models.CustomRecommendation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
        cls: ClsType[_models.CustomRecommendationsList] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    scope=scope,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("CustomRecommendationsList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get(self, scope: str, custom_recommendation_name: str, **kwargs: Any) -> _models.CustomRecommendation:
        """Get a specific custom recommendation for the requested scope by customRecommendationName.

        :param scope: The scope of the custom recommendation. Valid scopes are: management group
         (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
         (format: 'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param custom_recommendation_name: Name of the Custom Recommendation. Required.
        :type custom_recommendation_name: str
        :return: CustomRecommendation or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.CustomRecommendation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
        cls: ClsType[_models.CustomRecommendation] = kwargs.pop("cls", None)

        _request = build_get_request(
            scope=scope,
            custom_recommendation_name=custom_recommendation_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CustomRecommendation", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def create_or_update(
        self,
        scope: str,
        custom_recommendation_name: str,
        custom_recommendation_body: _models.CustomRecommendation,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CustomRecommendation:
        """Creates or updates a custom recommendation over a given scope.

        :param scope: The scope of the custom recommendation. Valid scopes are: management group
         (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
         (format: 'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param custom_recommendation_name: Name of the Custom Recommendation. Required.
        :type custom_recommendation_name: str
        :param custom_recommendation_body: Custom Recommendation body. Required.
        :type custom_recommendation_body: ~azure.mgmt.security.models.CustomRecommendation
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CustomRecommendation or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.CustomRecommendation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def create_or_update(
        self,
        scope: str,
        custom_recommendation_name: str,
        custom_recommendation_body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CustomRecommendation:
        """Creates or updates a custom recommendation over a given scope.

        :param scope: The scope of the custom recommendation. Valid scopes are: management group
         (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
         (format: 'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param custom_recommendation_name: Name of the Custom Recommendation. Required.
        :type custom_recommendation_name: str
        :param custom_recommendation_body: Custom Recommendation body. Required.
        :type custom_recommendation_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CustomRecommendation or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.CustomRecommendation
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def create_or_update(
        self,
        scope: str,
        custom_recommendation_name: str,
        custom_recommendation_body: Union[_models.CustomRecommendation, IO[bytes]],
        **kwargs: Any
    ) -> _models.CustomRecommendation:
        """Creates or updates a custom recommendation over a given scope.

        :param scope: The scope of the custom recommendation. Valid scopes are: management group
         (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
         (format: 'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param custom_recommendation_name: Name of the Custom Recommendation. Required.
        :type custom_recommendation_name: str
        :param custom_recommendation_body: Custom Recommendation body. Is either a CustomRecommendation
         type or a IO[bytes] type. Required.
        :type custom_recommendation_body: ~azure.mgmt.security.models.CustomRecommendation or IO[bytes]
        :return: CustomRecommendation or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.CustomRecommendation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CustomRecommendation] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(custom_recommendation_body, (IOBase, bytes)):
            _content = custom_recommendation_body
        else:
            _json = self._serialize.body(custom_recommendation_body, "CustomRecommendation")

        _request = build_create_or_update_request(
            scope=scope,
            custom_recommendation_name=custom_recommendation_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("CustomRecommendation", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, scope: str, custom_recommendation_name: str, **kwargs: Any
    ) -> None:
        """Delete a custom recommendation over a given scope.

        :param scope: The scope of the custom recommendation. Valid scopes are: management group
         (format: 'providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription
         (format: 'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param custom_recommendation_name: Name of the Custom Recommendation. Required.
        :type custom_recommendation_name: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2024-08-01"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            scope=scope,
            custom_recommendation_name=custom_recommendation_name,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
