# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AadConnectivityState1(Model):
    """Describes an Azure resource with kind.

    :param connectivity_state: The connectivity state of the external AAD
     solution . Possible values include: 'Discovered', 'NotLicensed',
     'Connected'
    :type connectivity_state: str or
     ~azure.mgmt.security.models.AadConnectivityState
    """

    _attribute_map = {
        'connectivity_state': {'key': 'connectivityState', 'type': 'str'},
    }

    def __init__(self, *, connectivity_state=None, **kwargs) -> None:
        super(AadConnectivityState1, self).__init__(**kwargs)
        self.connectivity_state = connectivity_state


class ExternalSecuritySolution(Model):
    """Represents a security solution external to Azure Security Center which
    sends information to an OMS workspace and whose data is displayed by Azure
    Security Center.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CefExternalSecuritySolution, AtaExternalSecuritySolution,
    AadExternalSecuritySolution

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'CEF': 'CefExternalSecuritySolution', 'ATA': 'AtaExternalSecuritySolution', 'AAD': 'AadExternalSecuritySolution'}
    }

    def __init__(self, **kwargs) -> None:
        super(ExternalSecuritySolution, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.kind = None


class AadExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an AAD identity protection solution which sends logs to an OMS
    workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties:
    :type properties: ~azure.mgmt.security.models.AadSolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AadSolutionProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(AadExternalSecuritySolution, self).__init__(**kwargs)
        self.properties = properties
        self.kind = 'AAD'


class AadSolutionProperties(Model):
    """The external security solution properties for AAD solutions.

    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param connectivity_state: The connectivity state of the external AAD
     solution . Possible values include: 'Discovered', 'NotLicensed',
     'Connected'
    :type connectivity_state: str or
     ~azure.mgmt.security.models.AadConnectivityState
    """

    _attribute_map = {
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'connectivity_state': {'key': 'connectivityState', 'type': 'str'},
    }

    def __init__(self, *, device_vendor: str=None, device_type: str=None, workspace=None, connectivity_state=None, **kwargs) -> None:
        super(AadSolutionProperties, self).__init__(**kwargs)
        self.device_vendor = device_vendor
        self.device_type = device_type
        self.workspace = workspace
        self.connectivity_state = connectivity_state


class Resource(Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AdvancedThreatProtectionSetting(Resource):
    """The Advanced Threat Protection resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param is_enabled: Indicates whether Advanced Threat Protection is
     enabled.
    :type is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(self, *, is_enabled: bool=None, **kwargs) -> None:
        super(AdvancedThreatProtectionSetting, self).__init__(**kwargs)
        self.is_enabled = is_enabled


class Alert(Resource):
    """Security alert.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar state: State of the alert (Active, Dismissed etc.)
    :vartype state: str
    :ivar reported_time_utc: The time the incident was reported to
     Microsoft.Security in UTC
    :vartype reported_time_utc: datetime
    :ivar vendor_name: Name of the vendor that discovered the incident
    :vartype vendor_name: str
    :ivar alert_name: Name of the alert type
    :vartype alert_name: str
    :ivar alert_display_name: Display name of the alert type
    :vartype alert_display_name: str
    :ivar detected_time_utc: The time the incident was detected by the vendor
    :vartype detected_time_utc: datetime
    :ivar description: Description of the incident and what it means
    :vartype description: str
    :ivar remediation_steps: Recommended steps to reradiate the incident
    :vartype remediation_steps: str
    :ivar action_taken: The action that was taken as a response to the alert
     (Active, Blocked etc.)
    :vartype action_taken: str
    :ivar reported_severity: Estimated severity of this alert. Possible values
     include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar compromised_entity: The entity that the incident happened on
    :vartype compromised_entity: str
    :ivar associated_resource: Azure resource ID of the associated resource
    :vartype associated_resource: str
    :param extended_properties:
    :type extended_properties: dict[str, object]
    :ivar system_source: The type of the alerted resource (Azure, Non-Azure)
    :vartype system_source: str
    :ivar can_be_investigated: Whether this alert can be investigated with
     Azure Security Center
    :vartype can_be_investigated: bool
    :ivar is_incident: Whether this alert is for incident type or not
     (otherwise - single alert)
    :vartype is_incident: bool
    :param entities: objects that are related to this alerts
    :type entities: list[~azure.mgmt.security.models.AlertEntity]
    :ivar confidence_score: level of confidence we have on the alert
    :vartype confidence_score: float
    :param confidence_reasons: reasons the alert got the confidenceScore value
    :type confidence_reasons:
     list[~azure.mgmt.security.models.AlertConfidenceReason]
    :ivar subscription_id: Azure subscription ID of the resource that had the
     security alert or the subscription ID of the workspace that this resource
     reports to
    :vartype subscription_id: str
    :ivar instance_id: Instance ID of the alert.
    :vartype instance_id: str
    :ivar workspace_arm_id: Azure resource ID of the workspace that the alert
     was reported to.
    :vartype workspace_arm_id: str
    :ivar correlation_key: Alerts with the same CorrelationKey will be grouped
     together in Ibiza.
    :vartype correlation_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'reported_time_utc': {'readonly': True},
        'vendor_name': {'readonly': True},
        'alert_name': {'readonly': True},
        'alert_display_name': {'readonly': True},
        'detected_time_utc': {'readonly': True},
        'description': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'action_taken': {'readonly': True},
        'reported_severity': {'readonly': True},
        'compromised_entity': {'readonly': True},
        'associated_resource': {'readonly': True},
        'system_source': {'readonly': True},
        'can_be_investigated': {'readonly': True},
        'is_incident': {'readonly': True},
        'confidence_score': {'readonly': True, 'maximum': 1, 'minimum': 0},
        'subscription_id': {'readonly': True},
        'instance_id': {'readonly': True},
        'workspace_arm_id': {'readonly': True},
        'correlation_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'reported_time_utc': {'key': 'properties.reportedTimeUtc', 'type': 'iso-8601'},
        'vendor_name': {'key': 'properties.vendorName', 'type': 'str'},
        'alert_name': {'key': 'properties.alertName', 'type': 'str'},
        'alert_display_name': {'key': 'properties.alertDisplayName', 'type': 'str'},
        'detected_time_utc': {'key': 'properties.detectedTimeUtc', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': 'str'},
        'action_taken': {'key': 'properties.actionTaken', 'type': 'str'},
        'reported_severity': {'key': 'properties.reportedSeverity', 'type': 'str'},
        'compromised_entity': {'key': 'properties.compromisedEntity', 'type': 'str'},
        'associated_resource': {'key': 'properties.associatedResource', 'type': 'str'},
        'extended_properties': {'key': 'properties.extendedProperties', 'type': '{object}'},
        'system_source': {'key': 'properties.systemSource', 'type': 'str'},
        'can_be_investigated': {'key': 'properties.canBeInvestigated', 'type': 'bool'},
        'is_incident': {'key': 'properties.isIncident', 'type': 'bool'},
        'entities': {'key': 'properties.entities', 'type': '[AlertEntity]'},
        'confidence_score': {'key': 'properties.confidenceScore', 'type': 'float'},
        'confidence_reasons': {'key': 'properties.confidenceReasons', 'type': '[AlertConfidenceReason]'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'instance_id': {'key': 'properties.instanceId', 'type': 'str'},
        'workspace_arm_id': {'key': 'properties.workspaceArmId', 'type': 'str'},
        'correlation_key': {'key': 'properties.correlationKey', 'type': 'str'},
    }

    def __init__(self, *, extended_properties=None, entities=None, confidence_reasons=None, **kwargs) -> None:
        super(Alert, self).__init__(**kwargs)
        self.state = None
        self.reported_time_utc = None
        self.vendor_name = None
        self.alert_name = None
        self.alert_display_name = None
        self.detected_time_utc = None
        self.description = None
        self.remediation_steps = None
        self.action_taken = None
        self.reported_severity = None
        self.compromised_entity = None
        self.associated_resource = None
        self.extended_properties = extended_properties
        self.system_source = None
        self.can_be_investigated = None
        self.is_incident = None
        self.entities = entities
        self.confidence_score = None
        self.confidence_reasons = confidence_reasons
        self.subscription_id = None
        self.instance_id = None
        self.workspace_arm_id = None
        self.correlation_key = None


class AlertConfidenceReason(Model):
    """Factors that increase our confidence that the alert is a true positive.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: Type of confidence factor
    :vartype type: str
    :ivar reason: description of the confidence reason
    :vartype reason: str
    """

    _validation = {
        'type': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AlertConfidenceReason, self).__init__(**kwargs)
        self.type = None
        self.reason = None


class AlertEntity(Model):
    """Changing set of properties depending on the entity type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar type: Type of entity
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, **kwargs) -> None:
        super(AlertEntity, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.type = None


class AllowedConnectionsResource(Model):
    """The resource whose properties describes the allowed traffic between Azure
    resources.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :ivar calculated_date_time: The UTC time on which the allowed connections
     resource was calculated
    :vartype calculated_date_time: datetime
    :ivar connectable_resources: List of connectable resources
    :vartype connectable_resources:
     list[~azure.mgmt.security.models.ConnectableResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'calculated_date_time': {'readonly': True},
        'connectable_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'calculated_date_time': {'key': 'properties.calculatedDateTime', 'type': 'iso-8601'},
        'connectable_resources': {'key': 'properties.connectableResources', 'type': '[ConnectableResource]'},
    }

    def __init__(self, **kwargs) -> None:
        super(AllowedConnectionsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.calculated_date_time = None
        self.connectable_resources = None


class AppWhitelistingGroup(Model):
    """AppWhitelistingGroup.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param enforcement_mode: Possible values include: 'Audit', 'Enforce'
    :type enforcement_mode: str or ~azure.mgmt.security.models.enum
    :param configuration_status: Possible values include: 'Configured',
     'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
    :type configuration_status: str or ~azure.mgmt.security.models.enum
    :param recommendation_status: Possible values include: 'Recommended',
     'NotRecommended', 'NotAvailable', 'NoStatus'
    :type recommendation_status: str or ~azure.mgmt.security.models.enum
    :param issues:
    :type issues:
     list[~azure.mgmt.security.models.AppWhitelistingIssueSummary]
    :param source_system: Possible values include: 'Azure_AppLocker',
     'Azure_AuditD', 'NonAzure_AppLocker', 'NonAzure_AuditD', 'None'
    :type source_system: str or ~azure.mgmt.security.models.enum
    :param vm_recommendations:
    :type vm_recommendations:
     list[~azure.mgmt.security.models.VmRecommendation]
    :param path_recommendations:
    :type path_recommendations:
     list[~azure.mgmt.security.models.PathRecommendation]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'enforcement_mode': {'key': 'properties.enforcementMode', 'type': 'str'},
        'configuration_status': {'key': 'properties.configurationStatus', 'type': 'str'},
        'recommendation_status': {'key': 'properties.recommendationStatus', 'type': 'str'},
        'issues': {'key': 'properties.issues', 'type': '[AppWhitelistingIssueSummary]'},
        'source_system': {'key': 'properties.sourceSystem', 'type': 'str'},
        'vm_recommendations': {'key': 'properties.vmRecommendations', 'type': '[VmRecommendation]'},
        'path_recommendations': {'key': 'properties.pathRecommendations', 'type': '[PathRecommendation]'},
    }

    def __init__(self, *, enforcement_mode=None, configuration_status=None, recommendation_status=None, issues=None, source_system=None, vm_recommendations=None, path_recommendations=None, **kwargs) -> None:
        super(AppWhitelistingGroup, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.enforcement_mode = enforcement_mode
        self.configuration_status = configuration_status
        self.recommendation_status = recommendation_status
        self.issues = issues
        self.source_system = source_system
        self.vm_recommendations = vm_recommendations
        self.path_recommendations = path_recommendations


class AppWhitelistingGroups(Model):
    """Represents a list of VM/server groups and set of rules that are Recommended
    by Azure Security Center to be allowed.

    :param value:
    :type value: list[~azure.mgmt.security.models.AppWhitelistingGroup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppWhitelistingGroup]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(AppWhitelistingGroups, self).__init__(**kwargs)
        self.value = value


class AppWhitelistingIssueSummary(Model):
    """Represents a summary of the alerts of the VM/server group.

    :param issue: Possible values include: 'ViolationsAudited',
     'ViolationsBlocked', 'MsiAndScriptViolationsAudited',
     'MsiAndScriptViolationsBlocked', 'ExecutableViolationsAudited',
     'RulesViolatedManually'
    :type issue: str or ~azure.mgmt.security.models.enum
    :param number_of_vms: The number of machines in the VM/server group that
     have this alert
    :type number_of_vms: float
    """

    _attribute_map = {
        'issue': {'key': 'issue', 'type': 'str'},
        'number_of_vms': {'key': 'numberOfVms', 'type': 'float'},
    }

    def __init__(self, *, issue=None, number_of_vms: float=None, **kwargs) -> None:
        super(AppWhitelistingIssueSummary, self).__init__(**kwargs)
        self.issue = issue
        self.number_of_vms = number_of_vms


class AppWhitelistingPutGroupData(Model):
    """The altered data of the recommended VM/server group policy.

    :param enforcement_mode: Possible values include: 'Audit', 'Enforce'
    :type enforcement_mode: str or ~azure.mgmt.security.models.enum
    :param vm_recommendations:
    :type vm_recommendations:
     list[~azure.mgmt.security.models.VmRecommendation]
    :param path_recommendations:
    :type path_recommendations:
     list[~azure.mgmt.security.models.PathRecommendation]
    """

    _attribute_map = {
        'enforcement_mode': {'key': 'enforcementMode', 'type': 'str'},
        'vm_recommendations': {'key': 'vmRecommendations', 'type': '[VmRecommendation]'},
        'path_recommendations': {'key': 'pathRecommendations', 'type': '[PathRecommendation]'},
    }

    def __init__(self, *, enforcement_mode=None, vm_recommendations=None, path_recommendations=None, **kwargs) -> None:
        super(AppWhitelistingPutGroupData, self).__init__(**kwargs)
        self.enforcement_mode = enforcement_mode
        self.vm_recommendations = vm_recommendations
        self.path_recommendations = path_recommendations


class AscLocation(Resource):
    """The ASC location of the subscription is in the "name" field.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param properties:
    :type properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(AscLocation, self).__init__(**kwargs)
        self.properties = properties


class AtaExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an ATA security solution which sends logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties:
    :type properties: ~azure.mgmt.security.models.AtaSolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'AtaSolutionProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(AtaExternalSecuritySolution, self).__init__(**kwargs)
        self.properties = properties
        self.kind = 'ATA'


class ExternalSecuritySolutionProperties(Model):
    """The solution properties (correspond to the solution kind).

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
    }

    def __init__(self, *, additional_properties=None, device_vendor: str=None, device_type: str=None, workspace=None, **kwargs) -> None:
        super(ExternalSecuritySolutionProperties, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.device_vendor = device_vendor
        self.device_type = device_type
        self.workspace = workspace


class AtaSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for ATA solutions.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param last_event_received:
    :type last_event_received: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'last_event_received': {'key': 'lastEventReceived', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, device_vendor: str=None, device_type: str=None, workspace=None, last_event_received: str=None, **kwargs) -> None:
        super(AtaSolutionProperties, self).__init__(additional_properties=additional_properties, device_vendor=device_vendor, device_type=device_type, workspace=workspace, **kwargs)
        self.last_event_received = last_event_received


class AutoProvisioningSetting(Resource):
    """Auto provisioning setting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param auto_provision: Required. Describes what kind of security agent
     provisioning action to take. Possible values include: 'On', 'Off'
    :type auto_provision: str or ~azure.mgmt.security.models.AutoProvision
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'auto_provision': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'auto_provision': {'key': 'properties.autoProvision', 'type': 'str'},
    }

    def __init__(self, *, auto_provision, **kwargs) -> None:
        super(AutoProvisioningSetting, self).__init__(**kwargs)
        self.auto_provision = auto_provision


class CefExternalSecuritySolution(ExternalSecuritySolution):
    """Represents a security solution which sends CEF logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param kind: Required. Constant filled by server.
    :type kind: str
    :param properties:
    :type properties: ~azure.mgmt.security.models.CefSolutionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CefSolutionProperties'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(CefExternalSecuritySolution, self).__init__(**kwargs)
        self.properties = properties
        self.kind = 'CEF'


class CefSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for CEF solutions.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param device_vendor:
    :type device_vendor: str
    :param device_type:
    :type device_type: str
    :param workspace:
    :type workspace: ~azure.mgmt.security.models.ConnectedWorkspace
    :param hostname:
    :type hostname: str
    :param agent:
    :type agent: str
    :param last_event_received:
    :type last_event_received: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'device_vendor': {'key': 'deviceVendor', 'type': 'str'},
        'device_type': {'key': 'deviceType', 'type': 'str'},
        'workspace': {'key': 'workspace', 'type': 'ConnectedWorkspace'},
        'hostname': {'key': 'hostname', 'type': 'str'},
        'agent': {'key': 'agent', 'type': 'str'},
        'last_event_received': {'key': 'lastEventReceived', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, device_vendor: str=None, device_type: str=None, workspace=None, hostname: str=None, agent: str=None, last_event_received: str=None, **kwargs) -> None:
        super(CefSolutionProperties, self).__init__(additional_properties=additional_properties, device_vendor=device_vendor, device_type=device_type, workspace=workspace, **kwargs)
        self.hostname = hostname
        self.agent = agent
        self.last_event_received = last_event_received


class CloudError(Model):
    """Error response structure.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for
     display in a user interface.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'error.code', 'type': 'str'},
        'message': {'key': 'error.message', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.code = None
        self.message = None


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class Compliance(Resource):
    """Compliance of a scope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar assessment_timestamp_utc_date: The timestamp when the Compliance
     calculation was conducted.
    :vartype assessment_timestamp_utc_date: datetime
    :ivar resource_count: The resource count of the given subscription for
     which the Compliance calculation was conducted (needed for Management
     Group Compliance calculation).
    :vartype resource_count: int
    :ivar assessment_result: An array of segment, which is the actually the
     compliance assessment.
    :vartype assessment_result:
     list[~azure.mgmt.security.models.ComplianceSegment]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'assessment_timestamp_utc_date': {'readonly': True},
        'resource_count': {'readonly': True},
        'assessment_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'assessment_timestamp_utc_date': {'key': 'properties.assessmentTimestampUtcDate', 'type': 'iso-8601'},
        'resource_count': {'key': 'properties.resourceCount', 'type': 'int'},
        'assessment_result': {'key': 'properties.assessmentResult', 'type': '[ComplianceSegment]'},
    }

    def __init__(self, **kwargs) -> None:
        super(Compliance, self).__init__(**kwargs)
        self.assessment_timestamp_utc_date = None
        self.resource_count = None
        self.assessment_result = None


class ComplianceResult(Resource):
    """a compliance result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar resource_status: The status of the resource regarding a single
     assessment. Possible values include: 'Healthy', 'NotApplicable',
     'OffByPolicy', 'NotHealthy'
    :vartype resource_status: str or
     ~azure.mgmt.security.models.ResourceStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_status': {'key': 'properties.resourceStatus', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ComplianceResult, self).__init__(**kwargs)
        self.resource_status = None


class ComplianceSegment(Model):
    """A segment of a compliance assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar segment_type: The segment type, e.g. compliant, non-compliance,
     insufficient coverage, N/A, etc.
    :vartype segment_type: str
    :ivar percentage: The size (%) of the segment.
    :vartype percentage: float
    """

    _validation = {
        'segment_type': {'readonly': True},
        'percentage': {'readonly': True},
    }

    _attribute_map = {
        'segment_type': {'key': 'segmentType', 'type': 'str'},
        'percentage': {'key': 'percentage', 'type': 'float'},
    }

    def __init__(self, **kwargs) -> None:
        super(ComplianceSegment, self).__init__(**kwargs)
        self.segment_type = None
        self.percentage = None


class ConnectableResource(Model):
    """Describes the allowed inbound and outbound traffic of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The Azure resource id
    :vartype id: str
    :ivar inbound_connected_resources: The list of Azure resources that the
     resource has inbound allowed connection from
    :vartype inbound_connected_resources:
     list[~azure.mgmt.security.models.ConnectedResource]
    :ivar outbound_connected_resources: The list of Azure resources that the
     resource has outbound allowed connection to
    :vartype outbound_connected_resources:
     list[~azure.mgmt.security.models.ConnectedResource]
    """

    _validation = {
        'id': {'readonly': True},
        'inbound_connected_resources': {'readonly': True},
        'outbound_connected_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'inbound_connected_resources': {'key': 'inboundConnectedResources', 'type': '[ConnectedResource]'},
        'outbound_connected_resources': {'key': 'outboundConnectedResources', 'type': '[ConnectedResource]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectableResource, self).__init__(**kwargs)
        self.id = None
        self.inbound_connected_resources = None
        self.outbound_connected_resources = None


class ConnectedResource(Model):
    """Describes properties of a connected resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar connected_resource_id: The Azure resource id of the connected
     resource
    :vartype connected_resource_id: str
    :ivar tcp_ports: The allowed tcp ports
    :vartype tcp_ports: str
    :ivar udp_ports: The allowed udp ports
    :vartype udp_ports: str
    """

    _validation = {
        'connected_resource_id': {'readonly': True},
        'tcp_ports': {'readonly': True},
        'udp_ports': {'readonly': True},
    }

    _attribute_map = {
        'connected_resource_id': {'key': 'connectedResourceId', 'type': 'str'},
        'tcp_ports': {'key': 'tcpPorts', 'type': 'str'},
        'udp_ports': {'key': 'udpPorts', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ConnectedResource, self).__init__(**kwargs)
        self.connected_resource_id = None
        self.tcp_ports = None
        self.udp_ports = None


class ConnectedWorkspace(Model):
    """Represents an OMS workspace to which the solution is connected.

    :param id: Azure resource ID of the connected OMS workspace
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(ConnectedWorkspace, self).__init__(**kwargs)
        self.id = id


class SettingResource(Resource):
    """The kind of the security setting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Required. the kind of the settings string
     (DataExportSetting). Possible values include: 'DataExportSetting',
     'AlertSuppressionSetting'
    :type kind: str or ~azure.mgmt.security.models.SettingKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, kind, **kwargs) -> None:
        super(SettingResource, self).__init__(**kwargs)
        self.kind = kind


class Setting(SettingResource):
    """Represents a security setting in Azure Security Center.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Required. the kind of the settings string
     (DataExportSetting). Possible values include: 'DataExportSetting',
     'AlertSuppressionSetting'
    :type kind: str or ~azure.mgmt.security.models.SettingKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, kind, **kwargs) -> None:
        super(Setting, self).__init__(kind=kind, **kwargs)


class DataExportSetting(Setting):
    """Represents a data export setting.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Required. the kind of the settings string
     (DataExportSetting). Possible values include: 'DataExportSetting',
     'AlertSuppressionSetting'
    :type kind: str or ~azure.mgmt.security.models.SettingKind
    :param enabled: Required. Is the data export setting is enabled
    :type enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(self, *, kind, enabled: bool, **kwargs) -> None:
        super(DataExportSetting, self).__init__(kind=kind, **kwargs)
        self.enabled = enabled


class DiscoveredSecuritySolution(Model):
    """DiscoveredSecuritySolution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param security_family: Required. The security family of the discovered
     solution. Possible values include: 'Waf', 'Ngfw', 'SaasWaf', 'Va'
    :type security_family: str or ~azure.mgmt.security.models.SecurityFamily
    :param offer: Required. The security solutions' image offer
    :type offer: str
    :param publisher: Required. The security solutions' image publisher
    :type publisher: str
    :param sku: Required. The security solutions' image sku
    :type sku: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'security_family': {'required': True},
        'offer': {'required': True},
        'publisher': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'security_family': {'key': 'properties.securityFamily', 'type': 'str'},
        'offer': {'key': 'properties.offer', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
    }

    def __init__(self, *, security_family, offer: str, publisher: str, sku: str, **kwargs) -> None:
        super(DiscoveredSecuritySolution, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.security_family = security_family
        self.offer = offer
        self.publisher = publisher
        self.sku = sku


class ExternalSecuritySolutionKind1(Model):
    """Describes an Azure resource with kind.

    :param kind: The kind of the external solution. Possible values include:
     'CEF', 'ATA', 'AAD'
    :type kind: str or
     ~azure.mgmt.security.models.ExternalSecuritySolutionKind
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, kind=None, **kwargs) -> None:
        super(ExternalSecuritySolutionKind1, self).__init__(**kwargs)
        self.kind = kind


class InformationProtectionKeyword(Model):
    """The information type keyword.

    :param pattern: The keyword pattern.
    :type pattern: str
    :param custom: Indicates whether the keyword is custom or not.
    :type custom: bool
    :param can_be_numeric: Indicates whether the keyword can be applied on
     numeric types or not.
    :type can_be_numeric: bool
    :param excluded: Indicates whether the keyword is excluded or not.
    :type excluded: bool
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'custom': {'key': 'custom', 'type': 'bool'},
        'can_be_numeric': {'key': 'canBeNumeric', 'type': 'bool'},
        'excluded': {'key': 'excluded', 'type': 'bool'},
    }

    def __init__(self, *, pattern: str=None, custom: bool=None, can_be_numeric: bool=None, excluded: bool=None, **kwargs) -> None:
        super(InformationProtectionKeyword, self).__init__(**kwargs)
        self.pattern = pattern
        self.custom = custom
        self.can_be_numeric = can_be_numeric
        self.excluded = excluded


class InformationProtectionPolicy(Resource):
    """Information protection policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar last_modified_utc: Describes the last UTC time the policy was
     modified.
    :vartype last_modified_utc: datetime
    :param labels: Dictionary of sensitivity labels.
    :type labels: dict[str, ~azure.mgmt.security.models.SensitivityLabel]
    :param information_types: The sensitivity information types.
    :type information_types: dict[str,
     ~azure.mgmt.security.models.InformationType]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_modified_utc': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_modified_utc': {'key': 'properties.lastModifiedUtc', 'type': 'iso-8601'},
        'labels': {'key': 'properties.labels', 'type': '{SensitivityLabel}'},
        'information_types': {'key': 'properties.informationTypes', 'type': '{InformationType}'},
    }

    def __init__(self, *, labels=None, information_types=None, **kwargs) -> None:
        super(InformationProtectionPolicy, self).__init__(**kwargs)
        self.last_modified_utc = None
        self.labels = labels
        self.information_types = information_types


class InformationType(Model):
    """The information type.

    :param display_name: The name of the information type.
    :type display_name: str
    :param order: The order of the information type.
    :type order: float
    :param recommended_label_id: The recommended label id to be associated
     with this information type.
    :type recommended_label_id: str
    :param enabled: Indicates whether the information type is enabled or not.
    :type enabled: bool
    :param custom: Indicates whether the information type is custom or not.
    :type custom: bool
    :param keywords: The information type keywords.
    :type keywords:
     list[~azure.mgmt.security.models.InformationProtectionKeyword]
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'float'},
        'recommended_label_id': {'key': 'recommendedLabelId', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'custom': {'key': 'custom', 'type': 'bool'},
        'keywords': {'key': 'keywords', 'type': '[InformationProtectionKeyword]'},
    }

    def __init__(self, *, display_name: str=None, order: float=None, recommended_label_id: str=None, enabled: bool=None, custom: bool=None, keywords=None, **kwargs) -> None:
        super(InformationType, self).__init__(**kwargs)
        self.display_name = display_name
        self.order = order
        self.recommended_label_id = recommended_label_id
        self.enabled = enabled
        self.custom = custom
        self.keywords = keywords


class IoTSecurityAggregatedAlert(Model):
    """Security Solution Aggregated Alert information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :ivar alert_type: Name of the alert type
    :vartype alert_type: str
    :ivar alert_display_name: Display name of the alert type
    :vartype alert_display_name: str
    :ivar aggregated_date_utc: The date the incidents were detected by the
     vendor
    :vartype aggregated_date_utc: date
    :ivar vendor_name: Name of the vendor that discovered the incident
    :vartype vendor_name: str
    :ivar reported_severity: Estimated severity of this alert. Possible values
     include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar remediation_steps: Recommended steps for remediation
    :vartype remediation_steps: str
    :ivar description: Description of the incident and what it means
    :vartype description: str
    :ivar count: Occurrence number of the alert within the aggregated date
    :vartype count: int
    :ivar effected_resource_type: Azure resource ID of the resource that got
     the alerts
    :vartype effected_resource_type: str
    :ivar system_source: The type of the alerted resource (Azure, Non-Azure)
    :vartype system_source: str
    :ivar action_taken: The action that was taken as a response to the alert
     (Active, Blocked etc.)
    :vartype action_taken: str
    :ivar log_analytics_query: query in log analytics to get the list of
     affected devices/alerts
    :vartype log_analytics_query: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'alert_type': {'readonly': True},
        'alert_display_name': {'readonly': True},
        'aggregated_date_utc': {'readonly': True},
        'vendor_name': {'readonly': True},
        'reported_severity': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'description': {'readonly': True},
        'count': {'readonly': True},
        'effected_resource_type': {'readonly': True},
        'system_source': {'readonly': True},
        'action_taken': {'readonly': True},
        'log_analytics_query': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'alert_display_name': {'key': 'properties.alertDisplayName', 'type': 'str'},
        'aggregated_date_utc': {'key': 'properties.aggregatedDateUtc', 'type': 'date'},
        'vendor_name': {'key': 'properties.vendorName', 'type': 'str'},
        'reported_severity': {'key': 'properties.reportedSeverity', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'count': {'key': 'properties.count', 'type': 'int'},
        'effected_resource_type': {'key': 'properties.effectedResourceType', 'type': 'str'},
        'system_source': {'key': 'properties.systemSource', 'type': 'str'},
        'action_taken': {'key': 'properties.actionTaken', 'type': 'str'},
        'log_analytics_query': {'key': 'properties.logAnalyticsQuery', 'type': 'str'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(IoTSecurityAggregatedAlert, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.alert_type = None
        self.alert_display_name = None
        self.aggregated_date_utc = None
        self.vendor_name = None
        self.reported_severity = None
        self.remediation_steps = None
        self.description = None
        self.count = None
        self.effected_resource_type = None
        self.system_source = None
        self.action_taken = None
        self.log_analytics_query = None


class IoTSecurityAggregatedRecommendation(Model):
    """Security Solution Recommendation Information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param recommendation_name: Name of the recommendation
    :type recommendation_name: str
    :ivar recommendation_display_name: Display name of the recommendation
     type.
    :vartype recommendation_display_name: str
    :ivar description: Description of the incident and what it means
    :vartype description: str
    :ivar recommendation_type_id: The recommendation-type GUID.
    :vartype recommendation_type_id: str
    :ivar detected_by: Name of the vendor that discovered the issue
    :vartype detected_by: str
    :ivar remediation_steps: Recommended steps for remediation
    :vartype remediation_steps: str
    :ivar reported_severity: Estimated severity of this recommendation.
     Possible values include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar healthy_devices: the number of the healthy devices within the
     solution
    :vartype healthy_devices: int
    :ivar unhealthy_device_count: the number of the unhealthy devices within
     the solution
    :vartype unhealthy_device_count: int
    :ivar log_analytics_query: query in log analytics to get the list of
     affected devices/alerts
    :vartype log_analytics_query: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'recommendation_display_name': {'readonly': True},
        'description': {'readonly': True},
        'recommendation_type_id': {'readonly': True},
        'detected_by': {'readonly': True},
        'remediation_steps': {'readonly': True},
        'reported_severity': {'readonly': True},
        'healthy_devices': {'readonly': True},
        'unhealthy_device_count': {'readonly': True},
        'log_analytics_query': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'recommendation_name': {'key': 'properties.recommendationName', 'type': 'str'},
        'recommendation_display_name': {'key': 'properties.recommendationDisplayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'recommendation_type_id': {'key': 'properties.recommendationTypeId', 'type': 'str'},
        'detected_by': {'key': 'properties.detectedBy', 'type': 'str'},
        'remediation_steps': {'key': 'properties.remediationSteps', 'type': 'str'},
        'reported_severity': {'key': 'properties.reportedSeverity', 'type': 'str'},
        'healthy_devices': {'key': 'properties.healthyDevices', 'type': 'int'},
        'unhealthy_device_count': {'key': 'properties.unhealthyDeviceCount', 'type': 'int'},
        'log_analytics_query': {'key': 'properties.logAnalyticsQuery', 'type': 'str'},
    }

    def __init__(self, *, tags=None, recommendation_name: str=None, **kwargs) -> None:
        super(IoTSecurityAggregatedRecommendation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.recommendation_name = recommendation_name
        self.recommendation_display_name = None
        self.description = None
        self.recommendation_type_id = None
        self.detected_by = None
        self.remediation_steps = None
        self.reported_severity = None
        self.healthy_devices = None
        self.unhealthy_device_count = None
        self.log_analytics_query = None


class IoTSecurityAlertedDevice(Model):
    """Statistic information about the number of alerts per device during the last
    period.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar device_id: Name of the alert type
    :vartype device_id: str
    :ivar alerts_count: the number of alerts raised for this device
    :vartype alerts_count: int
    """

    _validation = {
        'device_id': {'readonly': True},
        'alerts_count': {'readonly': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(IoTSecurityAlertedDevice, self).__init__(**kwargs)
        self.device_id = None
        self.alerts_count = None


class IoTSecurityAlertedDevicesList(Model):
    """List of devices with the count of raised alerts.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of aggregated alerts data
    :type value: list[~azure.mgmt.security.models.IoTSecurityAlertedDevice]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IoTSecurityAlertedDevice]'},
    }

    def __init__(self, *, value, **kwargs) -> None:
        super(IoTSecurityAlertedDevicesList, self).__init__(**kwargs)
        self.value = value


class IoTSecurityDeviceAlert(Model):
    """Statistic information about the number of alerts per alert type during the
    last period.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar alert_display_name: Display name of the alert
    :vartype alert_display_name: str
    :ivar reported_severity: Estimated severity of this alert. Possible values
     include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar alerts_count: the number of alerts raised for this alert type
    :vartype alerts_count: int
    """

    _validation = {
        'alert_display_name': {'readonly': True},
        'reported_severity': {'readonly': True},
        'alerts_count': {'readonly': True},
    }

    _attribute_map = {
        'alert_display_name': {'key': 'alertDisplayName', 'type': 'str'},
        'reported_severity': {'key': 'reportedSeverity', 'type': 'str'},
        'alerts_count': {'key': 'alertsCount', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(IoTSecurityDeviceAlert, self).__init__(**kwargs)
        self.alert_display_name = None
        self.reported_severity = None
        self.alerts_count = None


class IoTSecurityDeviceAlertsList(Model):
    """List of alerts with the count of raised alerts.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of top alerts data
    :type value: list[~azure.mgmt.security.models.IoTSecurityDeviceAlert]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IoTSecurityDeviceAlert]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value, **kwargs) -> None:
        super(IoTSecurityDeviceAlertsList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IoTSecurityDeviceRecommendation(Model):
    """Statistic information about the number of recommendations per
    recommendation type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar recommendation_display_name: Display name of the recommendation
    :vartype recommendation_display_name: str
    :ivar reported_severity: Estimated severity of this recommendation.
     Possible values include: 'Informational', 'Low', 'Medium', 'High'
    :vartype reported_severity: str or
     ~azure.mgmt.security.models.ReportedSeverity
    :ivar devices_count: the number of device with this recommendation
    :vartype devices_count: int
    """

    _validation = {
        'recommendation_display_name': {'readonly': True},
        'reported_severity': {'readonly': True},
        'devices_count': {'readonly': True},
    }

    _attribute_map = {
        'recommendation_display_name': {'key': 'recommendationDisplayName', 'type': 'str'},
        'reported_severity': {'key': 'reportedSeverity', 'type': 'str'},
        'devices_count': {'key': 'devicesCount', 'type': 'int'},
    }

    def __init__(self, **kwargs) -> None:
        super(IoTSecurityDeviceRecommendation, self).__init__(**kwargs)
        self.recommendation_display_name = None
        self.reported_severity = None
        self.devices_count = None


class IoTSecurityDeviceRecommendationsList(Model):
    """List of recommendations with the count of devices.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of aggregated recommendation data
    :type value:
     list[~azure.mgmt.security.models.IoTSecurityDeviceRecommendation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IoTSecurityDeviceRecommendation]'},
    }

    def __init__(self, *, value, **kwargs) -> None:
        super(IoTSecurityDeviceRecommendationsList, self).__init__(**kwargs)
        self.value = value


class IoTSecuritySolutionAnalyticsModel(Resource):
    """Security Analytics of a security solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar metrics: Security Analytics of a security solution
    :vartype metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
    :ivar unhealthy_device_count: number of unhealthy devices
    :vartype unhealthy_device_count: int
    :ivar devices_metrics: The list of devices metrics by the aggregated date.
    :vartype devices_metrics:
     list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]
    :param top_alerted_devices: The list of top 3 devices with the most
     attacked.
    :type top_alerted_devices:
     ~azure.mgmt.security.models.IoTSecurityAlertedDevicesList
    :param most_prevalent_device_alerts: The list of most prevalent 3 alerts.
    :type most_prevalent_device_alerts:
     ~azure.mgmt.security.models.IoTSecurityDeviceAlertsList
    :param most_prevalent_device_recommendations: The list of most prevalent 3
     recommendations.
    :type most_prevalent_device_recommendations:
     ~azure.mgmt.security.models.IoTSecurityDeviceRecommendationsList
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metrics': {'readonly': True},
        'unhealthy_device_count': {'readonly': True},
        'devices_metrics': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': 'IoTSeverityMetrics'},
        'unhealthy_device_count': {'key': 'properties.unhealthyDeviceCount', 'type': 'int'},
        'devices_metrics': {'key': 'properties.devicesMetrics', 'type': '[IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]'},
        'top_alerted_devices': {'key': 'properties.topAlertedDevices', 'type': 'IoTSecurityAlertedDevicesList'},
        'most_prevalent_device_alerts': {'key': 'properties.mostPrevalentDeviceAlerts', 'type': 'IoTSecurityDeviceAlertsList'},
        'most_prevalent_device_recommendations': {'key': 'properties.mostPrevalentDeviceRecommendations', 'type': 'IoTSecurityDeviceRecommendationsList'},
    }

    def __init__(self, *, top_alerted_devices=None, most_prevalent_device_alerts=None, most_prevalent_device_recommendations=None, **kwargs) -> None:
        super(IoTSecuritySolutionAnalyticsModel, self).__init__(**kwargs)
        self.metrics = None
        self.unhealthy_device_count = None
        self.devices_metrics = None
        self.top_alerted_devices = top_alerted_devices
        self.most_prevalent_device_alerts = most_prevalent_device_alerts
        self.most_prevalent_device_recommendations = most_prevalent_device_recommendations


class IoTSecuritySolutionAnalyticsModelList(Model):
    """List of Security Analytics of a security solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of Security Analytics of a security solution
    :type value:
     list[~azure.mgmt.security.models.IoTSecuritySolutionAnalyticsModel]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IoTSecuritySolutionAnalyticsModel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, *, value, **kwargs) -> None:
        super(IoTSecuritySolutionAnalyticsModelList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem(Model):
    """IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem.

    :param date_property: the date of the metrics
    :type date_property: datetime
    :param devices_metrics: devices alerts count by severity.
    :type devices_metrics: ~azure.mgmt.security.models.IoTSeverityMetrics
    """

    _attribute_map = {
        'date_property': {'key': 'date', 'type': 'iso-8601'},
        'devices_metrics': {'key': 'devicesMetrics', 'type': 'IoTSeverityMetrics'},
    }

    def __init__(self, *, date_property=None, devices_metrics=None, **kwargs) -> None:
        super(IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem, self).__init__(**kwargs)
        self.date_property = date_property
        self.devices_metrics = devices_metrics


class IoTSecuritySolutionModel(Model):
    """Security Solution.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param location: The resource location.
    :type location: str
    :param workspace: Required. Workspace resource ID
    :type workspace: str
    :param display_name: Required. Resource display name.
    :type display_name: str
    :param status: Security solution status. Possible values include:
     'Enabled', 'Disabled'. Default value: "Enabled" .
    :type status: str or ~azure.mgmt.security.models.SecuritySolutionStatus
    :param export: List of additional export to workspace data options
    :type export: list[str or ~azure.mgmt.security.models.ExportData]
    :param disabled_data_sources: Disabled data sources. Disabling these data
     sources compromises the system.
    :type disabled_data_sources: list[str or
     ~azure.mgmt.security.models.DataSource]
    :param iot_hubs: Required. IoT Hub resource IDs
    :type iot_hubs: list[str]
    :param user_defined_resources:
    :type user_defined_resources:
     ~azure.mgmt.security.models.UserDefinedResourcesProperties
    :ivar auto_discovered_resources: List of resources that were automatically
     discovered as relevant to the security solution.
    :vartype auto_discovered_resources: list[str]
    :param recommendations_configuration:
    :type recommendations_configuration:
     list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'workspace': {'required': True},
        'display_name': {'required': True},
        'iot_hubs': {'required': True},
        'auto_discovered_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'workspace': {'key': 'properties.workspace', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'export': {'key': 'properties.export', 'type': '[str]'},
        'disabled_data_sources': {'key': 'properties.disabledDataSources', 'type': '[str]'},
        'iot_hubs': {'key': 'properties.iotHubs', 'type': '[str]'},
        'user_defined_resources': {'key': 'properties.userDefinedResources', 'type': 'UserDefinedResourcesProperties'},
        'auto_discovered_resources': {'key': 'properties.autoDiscoveredResources', 'type': '[str]'},
        'recommendations_configuration': {'key': 'properties.recommendationsConfiguration', 'type': '[RecommendationConfigurationProperties]'},
    }

    def __init__(self, *, workspace: str, display_name: str, iot_hubs, tags=None, location: str=None, status="Enabled", export=None, disabled_data_sources=None, user_defined_resources=None, recommendations_configuration=None, **kwargs) -> None:
        super(IoTSecuritySolutionModel, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = tags
        self.location = location
        self.workspace = workspace
        self.display_name = display_name
        self.status = status
        self.export = export
        self.disabled_data_sources = disabled_data_sources
        self.iot_hubs = iot_hubs
        self.user_defined_resources = user_defined_resources
        self.auto_discovered_resources = None
        self.recommendations_configuration = recommendations_configuration


class IoTSeverityMetrics(Model):
    """Severity metrics.

    :param high: count of high severity items
    :type high: int
    :param medium: count of medium severity items
    :type medium: int
    :param low: count of low severity items
    :type low: int
    """

    _attribute_map = {
        'high': {'key': 'high', 'type': 'int'},
        'medium': {'key': 'medium', 'type': 'int'},
        'low': {'key': 'low', 'type': 'int'},
    }

    def __init__(self, *, high: int=None, medium: int=None, low: int=None, **kwargs) -> None:
        super(IoTSeverityMetrics, self).__init__(**kwargs)
        self.high = high
        self.medium = medium
        self.low = low


class JitNetworkAccessPolicy(Model):
    """JitNetworkAccessPolicy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param kind: Kind of the resource
    :type kind: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :param virtual_machines: Required. Configurations for
     Microsoft.Compute/virtualMachines resource type.
    :type virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyVirtualMachine]
    :param requests:
    :type requests: list[~azure.mgmt.security.models.JitNetworkAccessRequest]
    :ivar provisioning_state: Gets the provisioning state of the Just-in-Time
     policy.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'virtual_machines': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[JitNetworkAccessPolicyVirtualMachine]'},
        'requests': {'key': 'properties.requests', 'type': '[JitNetworkAccessRequest]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, virtual_machines, kind: str=None, requests=None, **kwargs) -> None:
        super(JitNetworkAccessPolicy, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kind = kind
        self.location = None
        self.virtual_machines = virtual_machines
        self.requests = requests
        self.provisioning_state = None


class JitNetworkAccessPolicyInitiatePort(Model):
    """JitNetworkAccessPolicyInitiatePort.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param allowed_source_address_prefix: Source of the allowed traffic. If
     omitted, the request will be for the source IP address of the initiate
     request.
    :type allowed_source_address_prefix: str
    :param end_time_utc: Required. The time to close the request in UTC
    :type end_time_utc: datetime
    """

    _validation = {
        'number': {'required': True},
        'end_time_utc': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
    }

    def __init__(self, *, number: int, end_time_utc, allowed_source_address_prefix: str=None, **kwargs) -> None:
        super(JitNetworkAccessPolicyInitiatePort, self).__init__(**kwargs)
        self.number = number
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.end_time_utc = end_time_utc


class JitNetworkAccessPolicyInitiateRequest(Model):
    """JitNetworkAccessPolicyInitiateRequest.

    All required parameters must be populated in order to send to Azure.

    :param virtual_machines: Required. A list of virtual machines & ports to
     open access for
    :type virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiateVirtualMachine]
    """

    _validation = {
        'virtual_machines': {'required': True},
    }

    _attribute_map = {
        'virtual_machines': {'key': 'virtualMachines', 'type': '[JitNetworkAccessPolicyInitiateVirtualMachine]'},
    }

    def __init__(self, *, virtual_machines, **kwargs) -> None:
        super(JitNetworkAccessPolicyInitiateRequest, self).__init__(**kwargs)
        self.virtual_machines = virtual_machines


class JitNetworkAccessPolicyInitiateVirtualMachine(Model):
    """JitNetworkAccessPolicyInitiateVirtualMachine.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of the virtual machine that is linked to
     this policy
    :type id: str
    :param ports: Required. The ports to open for the resource with the `id`
    :type ports:
     list[~azure.mgmt.security.models.JitNetworkAccessPolicyInitiatePort]
    """

    _validation = {
        'id': {'required': True},
        'ports': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[JitNetworkAccessPolicyInitiatePort]'},
    }

    def __init__(self, *, id: str, ports, **kwargs) -> None:
        super(JitNetworkAccessPolicyInitiateVirtualMachine, self).__init__(**kwargs)
        self.id = id
        self.ports = ports


class JitNetworkAccessPolicyVirtualMachine(Model):
    """JitNetworkAccessPolicyVirtualMachine.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of the virtual machine that is linked to
     this policy
    :type id: str
    :param ports: Required. Port configurations for the virtual machine
    :type ports: list[~azure.mgmt.security.models.JitNetworkAccessPortRule]
    :param public_ip_address: Public IP address of the Azure Firewall that is
     linked to this policy, if applicable
    :type public_ip_address: str
    """

    _validation = {
        'id': {'required': True},
        'ports': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[JitNetworkAccessPortRule]'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
    }

    def __init__(self, *, id: str, ports, public_ip_address: str=None, **kwargs) -> None:
        super(JitNetworkAccessPolicyVirtualMachine, self).__init__(**kwargs)
        self.id = id
        self.ports = ports
        self.public_ip_address = public_ip_address


class JitNetworkAccessPortRule(Model):
    """JitNetworkAccessPortRule.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param protocol: Required. Possible values include: 'TCP', 'UDP', 'All'
    :type protocol: str or ~azure.mgmt.security.models.Protocol
    :param allowed_source_address_prefix: Mutually exclusive with the
     "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR,
     for example "192.168.0.3" or "192.168.0.0/16".
    :type allowed_source_address_prefix: str
    :param allowed_source_address_prefixes: Mutually exclusive with the
     "allowedSourceAddressPrefix" parameter.
    :type allowed_source_address_prefixes: list[str]
    :param max_request_access_duration: Required. Maximum duration requests
     can be made for. In ISO 8601 duration format. Minimum 5 minutes, maximum 1
     day
    :type max_request_access_duration: str
    """

    _validation = {
        'number': {'required': True},
        'protocol': {'required': True},
        'max_request_access_duration': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'protocol': {'key': 'protocol', 'type': 'str'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'allowed_source_address_prefixes': {'key': 'allowedSourceAddressPrefixes', 'type': '[str]'},
        'max_request_access_duration': {'key': 'maxRequestAccessDuration', 'type': 'str'},
    }

    def __init__(self, *, number: int, protocol, max_request_access_duration: str, allowed_source_address_prefix: str=None, allowed_source_address_prefixes=None, **kwargs) -> None:
        super(JitNetworkAccessPortRule, self).__init__(**kwargs)
        self.number = number
        self.protocol = protocol
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.allowed_source_address_prefixes = allowed_source_address_prefixes
        self.max_request_access_duration = max_request_access_duration


class JitNetworkAccessRequest(Model):
    """JitNetworkAccessRequest.

    All required parameters must be populated in order to send to Azure.

    :param virtual_machines: Required.
    :type virtual_machines:
     list[~azure.mgmt.security.models.JitNetworkAccessRequestVirtualMachine]
    :param start_time_utc: Required. The start time of the request in UTC
    :type start_time_utc: datetime
    :param requestor: Required. The identity of the person who made the
     request
    :type requestor: str
    """

    _validation = {
        'virtual_machines': {'required': True},
        'start_time_utc': {'required': True},
        'requestor': {'required': True},
    }

    _attribute_map = {
        'virtual_machines': {'key': 'virtualMachines', 'type': '[JitNetworkAccessRequestVirtualMachine]'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'requestor': {'key': 'requestor', 'type': 'str'},
    }

    def __init__(self, *, virtual_machines, start_time_utc, requestor: str, **kwargs) -> None:
        super(JitNetworkAccessRequest, self).__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.start_time_utc = start_time_utc
        self.requestor = requestor


class JitNetworkAccessRequestPort(Model):
    """JitNetworkAccessRequestPort.

    All required parameters must be populated in order to send to Azure.

    :param number: Required.
    :type number: int
    :param allowed_source_address_prefix: Mutually exclusive with the
     "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR,
     for example "192.168.0.3" or "192.168.0.0/16".
    :type allowed_source_address_prefix: str
    :param allowed_source_address_prefixes: Mutually exclusive with the
     "allowedSourceAddressPrefix" parameter.
    :type allowed_source_address_prefixes: list[str]
    :param end_time_utc: Required. The date & time at which the request ends
     in UTC
    :type end_time_utc: datetime
    :param status: Required. The status of the port. Possible values include:
     'Revoked', 'Initiated'
    :type status: str or ~azure.mgmt.security.models.Status
    :param status_reason: Required. A description of why the `status` has its
     value. Possible values include: 'Expired', 'UserRequested',
     'NewerRequestInitiated'
    :type status_reason: str or ~azure.mgmt.security.models.StatusReason
    :param mapped_port: The port which is mapped to this port's `number` in
     the Azure Firewall, if applicable
    :type mapped_port: int
    """

    _validation = {
        'number': {'required': True},
        'end_time_utc': {'required': True},
        'status': {'required': True},
        'status_reason': {'required': True},
    }

    _attribute_map = {
        'number': {'key': 'number', 'type': 'int'},
        'allowed_source_address_prefix': {'key': 'allowedSourceAddressPrefix', 'type': 'str'},
        'allowed_source_address_prefixes': {'key': 'allowedSourceAddressPrefixes', 'type': '[str]'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'status_reason': {'key': 'statusReason', 'type': 'str'},
        'mapped_port': {'key': 'mappedPort', 'type': 'int'},
    }

    def __init__(self, *, number: int, end_time_utc, status, status_reason, allowed_source_address_prefix: str=None, allowed_source_address_prefixes=None, mapped_port: int=None, **kwargs) -> None:
        super(JitNetworkAccessRequestPort, self).__init__(**kwargs)
        self.number = number
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.allowed_source_address_prefixes = allowed_source_address_prefixes
        self.end_time_utc = end_time_utc
        self.status = status
        self.status_reason = status_reason
        self.mapped_port = mapped_port


class JitNetworkAccessRequestVirtualMachine(Model):
    """JitNetworkAccessRequestVirtualMachine.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource ID of the virtual machine that is linked to
     this policy
    :type id: str
    :param ports: Required. The ports that were opened for the virtual machine
    :type ports: list[~azure.mgmt.security.models.JitNetworkAccessRequestPort]
    """

    _validation = {
        'id': {'required': True},
        'ports': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[JitNetworkAccessRequestPort]'},
    }

    def __init__(self, *, id: str, ports, **kwargs) -> None:
        super(JitNetworkAccessRequestVirtualMachine, self).__init__(**kwargs)
        self.id = id
        self.ports = ports


class Kind(Model):
    """Describes an Azure resource with kind.

    :param kind: Kind of the resource
    :type kind: str
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, kind: str=None, **kwargs) -> None:
        super(Kind, self).__init__(**kwargs)
        self.kind = kind


class Location(Model):
    """Describes an Azure resource with location.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location: Location where the resource is stored
    :vartype location: str
    """

    _validation = {
        'location': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Location, self).__init__(**kwargs)
        self.location = None


class Operation(Model):
    """Possible operation in the REST API of Microsoft.Security.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the operation
    :vartype name: str
    :ivar origin: Where the operation is originated
    :vartype origin: str
    :param display:
    :type display: ~azure.mgmt.security.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
        'origin': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, *, display=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.origin = None
        self.display = display


class OperationDisplay(Model):
    """Security operation display.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar operation: The display name of the security operation.
    :vartype operation: str
    :ivar description: The description of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class PathRecommendation(Model):
    """Represents a path that is recommended to be allowed and its properties.

    :param path: The full path to whitelist
    :type path: str
    :param action: Possible values include: 'Recommended', 'Add', 'Remove'
    :type action: str or ~azure.mgmt.security.models.enum
    :param type: Possible values include: 'File', 'FileHash',
     'PublisherSignature', 'ProductSignature', 'BinarySignature',
     'VersionAndAboveSignature'
    :type type: str or ~azure.mgmt.security.models.enum
    :param publisher_info:
    :type publisher_info: ~azure.mgmt.security.models.PublisherInfo
    :param common: Whether the path is commonly run on the machine
    :type common: bool
    :param user_sids:
    :type user_sids: list[str]
    :param usernames:
    :type usernames: list[~azure.mgmt.security.models.UserRecommendation]
    :param file_type: Possible values include: 'Exe', 'Dll', 'Msi', 'Script',
     'Executable', 'Unknown'
    :type file_type: str or ~azure.mgmt.security.models.enum
    :param configuration_status: Possible values include: 'Configured',
     'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
    :type configuration_status: str or ~azure.mgmt.security.models.enum
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'publisher_info': {'key': 'publisherInfo', 'type': 'PublisherInfo'},
        'common': {'key': 'common', 'type': 'bool'},
        'user_sids': {'key': 'userSids', 'type': '[str]'},
        'usernames': {'key': 'usernames', 'type': '[UserRecommendation]'},
        'file_type': {'key': 'fileType', 'type': 'str'},
        'configuration_status': {'key': 'configurationStatus', 'type': 'str'},
    }

    def __init__(self, *, path: str=None, action=None, type=None, publisher_info=None, common: bool=None, user_sids=None, usernames=None, file_type=None, configuration_status=None, **kwargs) -> None:
        super(PathRecommendation, self).__init__(**kwargs)
        self.path = path
        self.action = action
        self.type = type
        self.publisher_info = publisher_info
        self.common = common
        self.user_sids = user_sids
        self.usernames = usernames
        self.file_type = file_type
        self.configuration_status = configuration_status


class Pricing(Resource):
    """Pricing tier will be applied for the scope based on the resource ID.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param pricing_tier: Required. The pricing tier value. Azure Security
     Center is provided in two pricing tiers: free and standard, with the
     standard tier available with a trial period. The standard tier offers
     advanced security capabilities, while the free tier offers basic security
     features. Possible values include: 'Free', 'Standard'
    :type pricing_tier: str or ~azure.mgmt.security.models.PricingTier
    :ivar free_trial_remaining_time: The duration left for the subscriptions
     free trial period - in ISO 8601 format (e.g. P3Y6M4DT12H30M5S).
    :vartype free_trial_remaining_time: timedelta
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'pricing_tier': {'required': True},
        'free_trial_remaining_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'pricing_tier': {'key': 'properties.pricingTier', 'type': 'str'},
        'free_trial_remaining_time': {'key': 'properties.freeTrialRemainingTime', 'type': 'duration'},
    }

    def __init__(self, *, pricing_tier, **kwargs) -> None:
        super(Pricing, self).__init__(**kwargs)
        self.pricing_tier = pricing_tier
        self.free_trial_remaining_time = None


class PricingList(Model):
    """List of pricing configurations response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. List of pricing configurations
    :type value: list[~azure.mgmt.security.models.Pricing]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Pricing]'},
    }

    def __init__(self, *, value, **kwargs) -> None:
        super(PricingList, self).__init__(**kwargs)
        self.value = value


class PublisherInfo(Model):
    """Represents the publisher information of a process/rule.

    :param publisher_name: The Subject field of the x.509 certificate used to
     sign the code, using the following fields -  O = Organization, L =
     Locality, S = State or Province, and C = Country
    :type publisher_name: str
    :param product_name: The product name taken from the file's version
     resource
    :type product_name: str
    :param binary_name: The "OriginalName" field taken from the file's version
     resource
    :type binary_name: str
    :param version: The binary file version taken from the file's version
     resource
    :type version: str
    """

    _attribute_map = {
        'publisher_name': {'key': 'publisherName', 'type': 'str'},
        'product_name': {'key': 'productName', 'type': 'str'},
        'binary_name': {'key': 'binaryName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, *, publisher_name: str=None, product_name: str=None, binary_name: str=None, version: str=None, **kwargs) -> None:
        super(PublisherInfo, self).__init__(**kwargs)
        self.publisher_name = publisher_name
        self.product_name = product_name
        self.binary_name = binary_name
        self.version = version


class RecommendationConfigurationProperties(Model):
    """Recommendation configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param recommendation_type: Required. The recommendation type. Possible
     values include: 'IoT_ACRAuthentication',
     'IoT_AgentSendsUnutilizedMessages', 'IoT_Baseline',
     'IoT_EdgeHubMemOptimize', 'IoT_EdgeLoggingOptions',
     'IoT_InconsistentModuleSettings', 'IoT_InstallAgent',
     'IoT_IPFilter_DenyAll', 'IoT_IPFilter_PermissiveRule', 'IoT_OpenPorts',
     'IoT_PermissiveFirewallPolicy', 'IoT_PermissiveInputFirewallRules',
     'IoT_PermissiveOutputFirewallRules', 'IoT_PrivilegedDockerOptions',
     'IoT_SharedCredentials', 'IoT_VulnerableTLSCipherSuite'
    :type recommendation_type: str or
     ~azure.mgmt.security.models.RecommendationType
    :ivar name:
    :vartype name: str
    :param status: Required. Recommendation status. The recommendation is not
     generated when the status is disabled. Possible values include:
     'Disabled', 'Enabled'. Default value: "Enabled" .
    :type status: str or
     ~azure.mgmt.security.models.RecommendationConfigStatus
    """

    _validation = {
        'recommendation_type': {'required': True},
        'name': {'readonly': True},
        'status': {'required': True},
    }

    _attribute_map = {
        'recommendation_type': {'key': 'recommendationType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, recommendation_type, status="Enabled", **kwargs) -> None:
        super(RecommendationConfigurationProperties, self).__init__(**kwargs)
        self.recommendation_type = recommendation_type
        self.name = None
        self.status = status


class RegulatoryComplianceAssessment(Resource):
    """Regulatory compliance assessment details and state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar description: The description of the regulatory compliance assessment
    :vartype description: str
    :ivar assessment_type: The expected type of assessment contained in the
     AssessmentDetailsLink
    :vartype assessment_type: str
    :ivar assessment_details_link: Link to more detailed assessment results
     data. The response type will be according to the assessmentType field
    :vartype assessment_details_link: str
    :param state: Aggregative state based on the assessment's scanned
     resources states. Possible values include: 'Passed', 'Failed', 'Skipped',
     'Unsupported'
    :type state: str or ~azure.mgmt.security.models.State
    :ivar passed_resources: The given assessment's related resources count
     with passed state.
    :vartype passed_resources: int
    :ivar failed_resources: The given assessment's related resources count
     with failed state.
    :vartype failed_resources: int
    :ivar skipped_resources: The given assessment's related resources count
     with skipped state.
    :vartype skipped_resources: int
    :ivar unsupported_resources: The given assessment's related resources
     count with unsupported state.
    :vartype unsupported_resources: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'assessment_type': {'readonly': True},
        'assessment_details_link': {'readonly': True},
        'passed_resources': {'readonly': True},
        'failed_resources': {'readonly': True},
        'skipped_resources': {'readonly': True},
        'unsupported_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'assessment_type': {'key': 'properties.assessmentType', 'type': 'str'},
        'assessment_details_link': {'key': 'properties.assessmentDetailsLink', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'passed_resources': {'key': 'properties.passedResources', 'type': 'int'},
        'failed_resources': {'key': 'properties.failedResources', 'type': 'int'},
        'skipped_resources': {'key': 'properties.skippedResources', 'type': 'int'},
        'unsupported_resources': {'key': 'properties.unsupportedResources', 'type': 'int'},
    }

    def __init__(self, *, state=None, **kwargs) -> None:
        super(RegulatoryComplianceAssessment, self).__init__(**kwargs)
        self.description = None
        self.assessment_type = None
        self.assessment_details_link = None
        self.state = state
        self.passed_resources = None
        self.failed_resources = None
        self.skipped_resources = None
        self.unsupported_resources = None


class RegulatoryComplianceControl(Resource):
    """Regulatory compliance control details and state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar description: The description of the regulatory compliance control
    :vartype description: str
    :param state: Aggregative state based on the control's supported
     assessments states. Possible values include: 'Passed', 'Failed',
     'Skipped', 'Unsupported'
    :type state: str or ~azure.mgmt.security.models.State
    :ivar passed_assessments: The number of supported regulatory compliance
     assessments of the given control with a passed state
    :vartype passed_assessments: int
    :ivar failed_assessments: The number of supported regulatory compliance
     assessments of the given control with a failed state
    :vartype failed_assessments: int
    :ivar skipped_assessments: The number of supported regulatory compliance
     assessments of the given control with a skipped state
    :vartype skipped_assessments: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'passed_assessments': {'readonly': True},
        'failed_assessments': {'readonly': True},
        'skipped_assessments': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'passed_assessments': {'key': 'properties.passedAssessments', 'type': 'int'},
        'failed_assessments': {'key': 'properties.failedAssessments', 'type': 'int'},
        'skipped_assessments': {'key': 'properties.skippedAssessments', 'type': 'int'},
    }

    def __init__(self, *, state=None, **kwargs) -> None:
        super(RegulatoryComplianceControl, self).__init__(**kwargs)
        self.description = None
        self.state = state
        self.passed_assessments = None
        self.failed_assessments = None
        self.skipped_assessments = None


class RegulatoryComplianceStandard(Resource):
    """Regulatory compliance standard details and state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param state: Aggregative state based on the standard's supported controls
     states. Possible values include: 'Passed', 'Failed', 'Skipped',
     'Unsupported'
    :type state: str or ~azure.mgmt.security.models.State
    :ivar passed_controls: The number of supported regulatory compliance
     controls of the given standard with a passed state
    :vartype passed_controls: int
    :ivar failed_controls: The number of supported regulatory compliance
     controls of the given standard with a failed state
    :vartype failed_controls: int
    :ivar skipped_controls: The number of supported regulatory compliance
     controls of the given standard with a skipped state
    :vartype skipped_controls: int
    :ivar unsupported_controls: The number of regulatory compliance controls
     of the given standard which are unsupported by automated assessments
    :vartype unsupported_controls: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'passed_controls': {'readonly': True},
        'failed_controls': {'readonly': True},
        'skipped_controls': {'readonly': True},
        'unsupported_controls': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'passed_controls': {'key': 'properties.passedControls', 'type': 'int'},
        'failed_controls': {'key': 'properties.failedControls', 'type': 'int'},
        'skipped_controls': {'key': 'properties.skippedControls', 'type': 'int'},
        'unsupported_controls': {'key': 'properties.unsupportedControls', 'type': 'int'},
    }

    def __init__(self, *, state=None, **kwargs) -> None:
        super(RegulatoryComplianceStandard, self).__init__(**kwargs)
        self.state = state
        self.passed_controls = None
        self.failed_controls = None
        self.skipped_controls = None
        self.unsupported_controls = None


class SecurityContact(Resource):
    """Contact details for security issues.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param email: Required. The email of this security contact
    :type email: str
    :param phone: The phone number of this security contact
    :type phone: str
    :param alert_notifications: Required. Whether to send security alerts
     notifications to the security contact. Possible values include: 'On',
     'Off'
    :type alert_notifications: str or
     ~azure.mgmt.security.models.AlertNotifications
    :param alerts_to_admins: Required. Whether to send security alerts
     notifications to subscription admins. Possible values include: 'On', 'Off'
    :type alerts_to_admins: str or ~azure.mgmt.security.models.AlertsToAdmins
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'email': {'required': True},
        'alert_notifications': {'required': True},
        'alerts_to_admins': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'phone': {'key': 'properties.phone', 'type': 'str'},
        'alert_notifications': {'key': 'properties.alertNotifications', 'type': 'str'},
        'alerts_to_admins': {'key': 'properties.alertsToAdmins', 'type': 'str'},
    }

    def __init__(self, *, email: str, alert_notifications, alerts_to_admins, phone: str=None, **kwargs) -> None:
        super(SecurityContact, self).__init__(**kwargs)
        self.email = email
        self.phone = phone
        self.alert_notifications = alert_notifications
        self.alerts_to_admins = alerts_to_admins


class SecurityTask(Resource):
    """Security task that we recommend to do in order to strengthen security.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar state: State of the task (Active, Resolved etc.)
    :vartype state: str
    :ivar creation_time_utc: The time this task was discovered in UTC
    :vartype creation_time_utc: datetime
    :param security_task_parameters:
    :type security_task_parameters:
     ~azure.mgmt.security.models.SecurityTaskParameters
    :ivar last_state_change_time_utc: The time this task's details were last
     changed in UTC
    :vartype last_state_change_time_utc: datetime
    :ivar sub_state: Additional data on the state of the task
    :vartype sub_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'creation_time_utc': {'readonly': True},
        'last_state_change_time_utc': {'readonly': True},
        'sub_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'creation_time_utc': {'key': 'properties.creationTimeUtc', 'type': 'iso-8601'},
        'security_task_parameters': {'key': 'properties.securityTaskParameters', 'type': 'SecurityTaskParameters'},
        'last_state_change_time_utc': {'key': 'properties.lastStateChangeTimeUtc', 'type': 'iso-8601'},
        'sub_state': {'key': 'properties.subState', 'type': 'str'},
    }

    def __init__(self, *, security_task_parameters=None, **kwargs) -> None:
        super(SecurityTask, self).__init__(**kwargs)
        self.state = None
        self.creation_time_utc = None
        self.security_task_parameters = security_task_parameters
        self.last_state_change_time_utc = None
        self.sub_state = None


class SecurityTaskParameters(Model):
    """Changing set of properties, depending on the task type that is derived from
    the name field.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :ivar name: Name of the task type
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, additional_properties=None, **kwargs) -> None:
        super(SecurityTaskParameters, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.name = None


class SensitivityLabel(Model):
    """The sensitivity label.

    :param display_name: The name of the sensitivity label.
    :type display_name: str
    :param order: The order of the sensitivity label.
    :type order: float
    :param enabled: Indicates whether the label is enabled or not.
    :type enabled: bool
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'float'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(self, *, display_name: str=None, order: float=None, enabled: bool=None, **kwargs) -> None:
        super(SensitivityLabel, self).__init__(**kwargs)
        self.display_name = display_name
        self.order = order
        self.enabled = enabled


class ServerVulnerabilityAssessment(Resource):
    """Describes the server vulnerability assessment details on a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar provisioning_state: The provisioningState of the vulnerability
     assessment capability on the VM. Possible values include: 'Succeeded',
     'Failed', 'Canceled', 'Provisioning', 'Deprovisioning'
    :vartype provisioning_state: str or ~azure.mgmt.security.models.enum
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerVulnerabilityAssessment, self).__init__(**kwargs)
        self.provisioning_state = None


class ServerVulnerabilityAssessmentsList(Model):
    """List of server vulnerability assessments.

    :param value:
    :type value:
     list[~azure.mgmt.security.models.ServerVulnerabilityAssessment]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerVulnerabilityAssessment]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(ServerVulnerabilityAssessmentsList, self).__init__(**kwargs)
        self.value = value


class TagsResource(Model):
    """A container holding only the Tags for a resource, allowing the user to
    update the tags.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags


class TopologyResource(Model):
    """TopologyResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar location: Location where the resource is stored
    :vartype location: str
    :ivar calculated_date_time: The UTC time on which the topology was
     calculated
    :vartype calculated_date_time: datetime
    :ivar topology_resources: Azure resources which are part of this topology
     resource
    :vartype topology_resources:
     list[~azure.mgmt.security.models.TopologySingleResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'calculated_date_time': {'readonly': True},
        'topology_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'calculated_date_time': {'key': 'properties.calculatedDateTime', 'type': 'iso-8601'},
        'topology_resources': {'key': 'properties.topologyResources', 'type': '[TopologySingleResource]'},
    }

    def __init__(self, **kwargs) -> None:
        super(TopologyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.calculated_date_time = None
        self.topology_resources = None


class TopologySingleResource(Model):
    """TopologySingleResource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id
    :vartype resource_id: str
    :ivar severity: The security severity of the resource
    :vartype severity: str
    :ivar recommendations_exist: Indicates if the resource has security
     recommendations
    :vartype recommendations_exist: bool
    :ivar network_zones: Indicates the resource connectivity level to the
     Internet (InternetFacing, Internal ,etc.)
    :vartype network_zones: str
    :ivar topology_score: Score of the resource based on its security severity
    :vartype topology_score: int
    :ivar location: The location of this resource
    :vartype location: str
    :ivar parents: Azure resources connected to this resource which are in
     higher level in the topology view
    :vartype parents:
     list[~azure.mgmt.security.models.TopologySingleResourceParent]
    :ivar children: Azure resources connected to this resource which are in
     lower level in the topology view
    :vartype children:
     list[~azure.mgmt.security.models.TopologySingleResourceChild]
    """

    _validation = {
        'resource_id': {'readonly': True},
        'severity': {'readonly': True},
        'recommendations_exist': {'readonly': True},
        'network_zones': {'readonly': True},
        'topology_score': {'readonly': True},
        'location': {'readonly': True},
        'parents': {'readonly': True},
        'children': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'recommendations_exist': {'key': 'recommendationsExist', 'type': 'bool'},
        'network_zones': {'key': 'networkZones', 'type': 'str'},
        'topology_score': {'key': 'topologyScore', 'type': 'int'},
        'location': {'key': 'location', 'type': 'str'},
        'parents': {'key': 'parents', 'type': '[TopologySingleResourceParent]'},
        'children': {'key': 'children', 'type': '[TopologySingleResourceChild]'},
    }

    def __init__(self, **kwargs) -> None:
        super(TopologySingleResource, self).__init__(**kwargs)
        self.resource_id = None
        self.severity = None
        self.recommendations_exist = None
        self.network_zones = None
        self.topology_score = None
        self.location = None
        self.parents = None
        self.children = None


class TopologySingleResourceChild(Model):
    """TopologySingleResourceChild.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id which serves as child resource in
     topology view
    :vartype resource_id: str
    """

    _validation = {
        'resource_id': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(TopologySingleResourceChild, self).__init__(**kwargs)
        self.resource_id = None


class TopologySingleResourceParent(Model):
    """TopologySingleResourceParent.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_id: Azure resource id which serves as parent resource in
     topology view
    :vartype resource_id: str
    """

    _validation = {
        'resource_id': {'readonly': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(TopologySingleResourceParent, self).__init__(**kwargs)
        self.resource_id = None


class UpdateIotSecuritySolutionData(TagsResource):
    """UpdateIotSecuritySolutionData.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param user_defined_resources:
    :type user_defined_resources:
     ~azure.mgmt.security.models.UserDefinedResourcesProperties
    :param recommendations_configuration:
    :type recommendations_configuration:
     list[~azure.mgmt.security.models.RecommendationConfigurationProperties]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'user_defined_resources': {'key': 'userDefinedResources', 'type': 'UserDefinedResourcesProperties'},
        'recommendations_configuration': {'key': 'recommendationsConfiguration', 'type': '[RecommendationConfigurationProperties]'},
    }

    def __init__(self, *, tags=None, user_defined_resources=None, recommendations_configuration=None, **kwargs) -> None:
        super(UpdateIotSecuritySolutionData, self).__init__(tags=tags, **kwargs)
        self.user_defined_resources = user_defined_resources
        self.recommendations_configuration = recommendations_configuration


class UserDefinedResourcesProperties(Model):
    """Properties of the solution's user defined resources.

    All required parameters must be populated in order to send to Azure.

    :param query: Required. Azure Resource Graph query which represents the
     security solution's user defined resources. Required to start with "where
     type != "Microsoft.Devices/IotHubs""
    :type query: str
    :param query_subscriptions: Required. List of Azure subscription ids on
     which the user defined resources query should be executed.
    :type query_subscriptions: list[str]
    """

    _validation = {
        'query': {'required': True},
        'query_subscriptions': {'required': True},
    }

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'query_subscriptions': {'key': 'querySubscriptions', 'type': '[str]'},
    }

    def __init__(self, *, query: str, query_subscriptions, **kwargs) -> None:
        super(UserDefinedResourcesProperties, self).__init__(**kwargs)
        self.query = query
        self.query_subscriptions = query_subscriptions


class UserRecommendation(Model):
    """Represents a user that is recommended to be allowed for a certain rule.

    :param username: Represents a user that is recommended to be allowed for a
     certain rule
    :type username: str
    :param recommendation_action: Possible values include: 'Recommended',
     'Add', 'Remove'
    :type recommendation_action: str or ~azure.mgmt.security.models.enum
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'recommendation_action': {'key': 'recommendationAction', 'type': 'str'},
    }

    def __init__(self, *, username: str=None, recommendation_action=None, **kwargs) -> None:
        super(UserRecommendation, self).__init__(**kwargs)
        self.username = username
        self.recommendation_action = recommendation_action


class VmRecommendation(Model):
    """Represents a machine that is part of a VM/server group.

    :param configuration_status: Possible values include: 'Configured',
     'NotConfigured', 'InProgress', 'Failed', 'NoStatus'
    :type configuration_status: str or ~azure.mgmt.security.models.enum
    :param recommendation_action: Possible values include: 'Recommended',
     'Add', 'Remove'
    :type recommendation_action: str or ~azure.mgmt.security.models.enum
    :param resource_id:
    :type resource_id: str
    """

    _attribute_map = {
        'configuration_status': {'key': 'configurationStatus', 'type': 'str'},
        'recommendation_action': {'key': 'recommendationAction', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
    }

    def __init__(self, *, configuration_status=None, recommendation_action=None, resource_id: str=None, **kwargs) -> None:
        super(VmRecommendation, self).__init__(**kwargs)
        self.configuration_status = configuration_status
        self.recommendation_action = recommendation_action
        self.resource_id = resource_id


class WorkspaceSetting(Resource):
    """Configures where to store the OMS agent data for workspaces under a scope.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param workspace_id: Required. The full Azure ID of the workspace to save
     the data in
    :type workspace_id: str
    :param scope: Required. All the VMs in this scope will send their security
     data to the mentioned workspace unless overridden by a setting with more
     specific scope
    :type scope: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'workspace_id': {'required': True},
        'scope': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
    }

    def __init__(self, *, workspace_id: str, scope: str, **kwargs) -> None:
        super(WorkspaceSetting, self).__init__(**kwargs)
        self.workspace_id = workspace_id
        self.scope = scope
