# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource_py3 import TrackedResource


class PrivateZone(TrackedResource):
    """Describes a Private DNS zone.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Example -
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Example -
     'Microsoft.Network/privateDnsZones'.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: The Azure Region where the resource lives
    :type location: str
    :param etag: The ETag of the zone.
    :type etag: str
    :ivar max_number_of_record_sets: The maximum number of record sets that
     can be created in this Private DNS zone. This is a read-only property and
     any attempt to set this value will be ignored.
    :vartype max_number_of_record_sets: long
    :ivar number_of_record_sets: The current number of record sets in this
     Private DNS zone. This is a read-only property and any attempt to set this
     value will be ignored.
    :vartype number_of_record_sets: long
    :ivar max_number_of_virtual_network_links: The maximum number of virtual
     networks that can be linked to this Private DNS zone. This is a read-only
     property and any attempt to set this value will be ignored.
    :vartype max_number_of_virtual_network_links: long
    :ivar number_of_virtual_network_links: The current number of virtual
     networks that are linked to this Private DNS zone. This is a read-only
     property and any attempt to set this value will be ignored.
    :vartype number_of_virtual_network_links: long
    :ivar max_number_of_virtual_network_links_with_registration: The maximum
     number of virtual networks that can be linked to this Private DNS zone
     with registration enabled. This is a read-only property and any attempt to
     set this value will be ignored.
    :vartype max_number_of_virtual_network_links_with_registration: long
    :ivar number_of_virtual_network_links_with_registration: The current
     number of virtual networks that are linked to this Private DNS zone with
     registration enabled. This is a read-only property and any attempt to set
     this value will be ignored.
    :vartype number_of_virtual_network_links_with_registration: long
    :ivar provisioning_state: The provisioning state of the resource. This is
     a read-only property and any attempt to set this value will be ignored.
     Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded',
     'Failed', 'Canceled'
    :vartype provisioning_state: str or
     ~azure.mgmt.privatedns.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'max_number_of_record_sets': {'readonly': True},
        'number_of_record_sets': {'readonly': True},
        'max_number_of_virtual_network_links': {'readonly': True},
        'number_of_virtual_network_links': {'readonly': True},
        'max_number_of_virtual_network_links_with_registration': {'readonly': True},
        'number_of_virtual_network_links_with_registration': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'max_number_of_record_sets': {'key': 'properties.maxNumberOfRecordSets', 'type': 'long'},
        'number_of_record_sets': {'key': 'properties.numberOfRecordSets', 'type': 'long'},
        'max_number_of_virtual_network_links': {'key': 'properties.maxNumberOfVirtualNetworkLinks', 'type': 'long'},
        'number_of_virtual_network_links': {'key': 'properties.numberOfVirtualNetworkLinks', 'type': 'long'},
        'max_number_of_virtual_network_links_with_registration': {'key': 'properties.maxNumberOfVirtualNetworkLinksWithRegistration', 'type': 'long'},
        'number_of_virtual_network_links_with_registration': {'key': 'properties.numberOfVirtualNetworkLinksWithRegistration', 'type': 'long'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, tags=None, location: str=None, etag: str=None, **kwargs) -> None:
        super(PrivateZone, self).__init__(tags=tags, location=location, **kwargs)
        self.etag = etag
        self.max_number_of_record_sets = None
        self.number_of_record_sets = None
        self.max_number_of_virtual_network_links = None
        self.number_of_virtual_network_links = None
        self.max_number_of_virtual_network_links_with_registration = None
        self.number_of_virtual_network_links_with_registration = None
        self.provisioning_state = None
