# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationGatewayWebApplicationFirewallConfiguration(Model):
    """Application gateway web application firewall configuration.

    :param enabled: Whether the web application firewall is enabled.
    :type enabled: bool
    :param firewall_mode: Web application firewall mode. Possible values are:
     'Detection' and 'Prevention'. Possible values include: 'Detection',
     'Prevention'
    :type firewall_mode: str or :class:`ApplicationGatewayFirewallMode
     <azure.mgmt.network.v2016_09_01.models.ApplicationGatewayFirewallMode>`
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'firewall_mode': {'key': 'firewallMode', 'type': 'str'},
    }

    def __init__(self, enabled, firewall_mode=None):
        self.enabled = enabled
        self.firewall_mode = firewall_mode
