import builtins

from .enum import EnumItem

classes: dict[int, Exception]

def code_to_tag(code: int) -> bytes: ...
def tag_to_code(tag: bytes) -> int: ...
def make_error(
    res: int,
    filename: str | None = None,
    log: tuple[int, tuple[int, str, str] | None] | None = None,
) -> None: ...

class ErrorType(EnumItem):
    BSF_NOT_FOUND: int
    BUG: int
    BUFFER_TOO_SMALL: int
    DECODER_NOT_FOUND: int
    DEMUXER_NOT_FOUND: int
    ENCODER_NOT_FOUND: int
    EOF: int
    EXIT: int
    EXTERNAL: int
    FILTER_NOT_FOUND: int
    INVALIDDATA: int
    MUXER_NOT_FOUND: int
    OPTION_NOT_FOUND: int
    PATCHWELCOME: int
    PROTOCOL_NOT_FOUND: int
    UNKNOWN: int
    EXPERIMENTAL: int
    INPUT_CHANGED: int
    OUTPUT_CHANGED: int
    HTTP_BAD_REQUEST: int
    HTTP_UNAUTHORIZED: int
    HTTP_FORBIDDEN: int
    HTTP_NOT_FOUND: int
    HTTP_OTHER_4XX: int
    HTTP_SERVER_ERROR: int
    PYAV_CALLBACK: int

    tag: bytes

class FFmpegError(Exception):
    errno: int
    strerror: str
    filename: str
    log: tuple[int, tuple[int, str, str] | None]

    def __init__(
        self,
        code: int,
        message: str,
        filename: str | None = None,
        log: tuple[int, tuple[int, str, str] | None] | None = None,
    ) -> None: ...

class LookupError(FFmpegError): ...
class HTTPError(FFmpegError): ...
class HTTPClientError(FFmpegError): ...
class UndefinedError(FFmpegError): ...
class InvalidDataError(FFmpegError, builtins.ValueError): ...
class BugError(FFmpegError, builtins.RuntimeError): ...
class BufferTooSmallError(FFmpegError, builtins.ValueError): ...
class BSFNotFoundError(LookupError): ...
class DecoderNotFoundError(LookupError): ...
class DemuxerNotFoundError(LookupError): ...
class EncoderNotFoundError(LookupError): ...
class ExitError(FFmpegError): ...
class ExternalError(FFmpegError): ...
class FilterNotFoundError(LookupError): ...
class MuxerNotFoundError(LookupError): ...
class OptionNotFoundError(LookupError): ...
class PatchWelcomeError(FFmpegError): ...
class ProtocolNotFoundError(LookupError): ...
class UnknownError(FFmpegError): ...
class ExperimentalError(FFmpegError): ...
class InputChangedError(FFmpegError): ...
class OutputChangedError(FFmpegError): ...
class HTTPBadRequestError(HTTPClientError): ...
class HTTPUnauthorizedError(HTTPClientError): ...
class HTTPForbiddenError(HTTPClientError): ...
class HTTPNotFoundError(HTTPClientError): ...
class HTTPOtherClientError(HTTPClientError): ...
class HTTPServerError(HTTPError): ...
class PyAVCallbackError(FFmpegError, builtins.RuntimeError): ...
class BrokenPipeError(FFmpegError, builtins.BrokenPipeError): ...
class ChildProcessError(FFmpegError, builtins.ChildProcessError): ...
class ConnectionAbortedError(FFmpegError, builtins.ConnectionAbortedError): ...
class ConnectionRefusedError(FFmpegError, builtins.ConnectionRefusedError): ...
class ConnectionResetError(FFmpegError, builtins.ConnectionResetError): ...
class BlockingIOError(FFmpegError, builtins.BlockingIOError): ...
class EOFError(FFmpegError, builtins.EOFError): ...
class FileExistsError(FFmpegError, builtins.FileExistsError): ...
class FileNotFoundError(FFmpegError, builtins.FileNotFoundError): ...
class InterruptedError(FFmpegError, builtins.InterruptedError): ...
class IsADirectoryError(FFmpegError, builtins.IsADirectoryError): ...
class MemoryError(FFmpegError, builtins.MemoryError): ...
class NotADirectoryError(FFmpegError, builtins.NotADirectoryError): ...
class NotImplementedError(FFmpegError, builtins.NotImplementedError): ...
class OverflowError(FFmpegError, builtins.OverflowError): ...
class OSError(FFmpegError, builtins.OSError): ...
class PermissionError(FFmpegError, builtins.PermissionError): ...
class ProcessLookupError(FFmpegError, builtins.ProcessLookupError): ...
class TimeoutError(FFmpegError, builtins.TimeoutError): ...
class ValueError(FFmpegError, builtins.ValueError): ...
