## errors.py
## 
## Copyright (C) 2006-2008 Betz Stefan <stefan_betz@gmx.net>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 3 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

"""
Exceptions Module

Contents:
MountpointError -> Mountpoint Related Exception
ShareError      -> Share Related Exception
"""

class MyException(Exception):
    """
    Base class for the pyNeighborhood exceptions
    """
    
    def __init__(self, reason = None):
        """
        Construtor
        """
        Exception.__init__(self)
        if reason != None:
            self.reason = reason

class MountpointError(MyException):
    """
    Exception for mountpoint errors
    """
    pass

class ShareError(MyException):
    """
    Exception for share errors
    """
    pass
