/*	Equirectangular_Projection

PIRL CVS ID: Equirectangular_Projection.java,v 1.4 2012/04/16 06:10:20 castalia Exp

Copyright (C) 2007-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package PIRL.Image_Tools;

import	PIRL.PVL.Parameter;
import	PIRL.PVL.Value;
import	PIRL.PVL.PVL_Exception;

import	java.awt.Point;
import	java.awt.geom.Point2D;


public class Equirectangular_Projection
	extends Projection
{
/**	Class name and version identification.
*/
public static final String
	ID = "PIRL.Image_Tools.Equirectangular_Projection (1.4 2012/04/16 06:10:20)";

private static final String
	PROJECTION_NAME					= "Equirectangular";

//	Pre-computed values.
private double
	Center_Latitude_Radius,
	Coefficient_CLR;


//  DEBUG control.
private static final int
	DEBUG_OFF				= 0,
	DEBUG_CONSTRUCTORS		= 1 << 0,
	DEBUG_ACCESSORS			= 1 << 1,
	DEBUG_CONVERTERS		= 1 << 2,
	DEBUG_ALL				= -1,

	DEBUG					= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
public Equirectangular_Projection
	(
	Parameter	parameters
	)
	throws PVL_Exception, UnsupportedOperationException
{
//	Initialize the base projection parameters.
super (parameters);

if (Not_Identity)
	{
	Center_Latitude_Radius = Local_Radius (Center_Latitude);
	if (Center_Latitude == PI_OVER_2)
		throw new UnsupportedOperationException (ID + '\n'
			+ PROJECTION_NAME + " projection can't be done\n"
			+ "when the " + CENTER_LATITUDE_PARAMETER_NAME
				+ " parameter value is "
				+ Math.toDegrees (Center_Latitude) + " degrees.");
	Coefficient_CLR =
		Center_Latitude_Radius * StrictMath.cos (Center_Latitude);
	}
}

/*==============================================================================
	Accessors
*/
public String Name ()
{return PROJECTION_NAME;}

/*==============================================================================
	Converters
*/
/**	Get the world longitude,latitude coordinate for an image sample,line
	coordinate.
<p>
	The conversion algorithm is:
<p><blockquote>
	longitude = Center_Longitude + x / (R * cos (Center_Latitude))<br>
	latitude = y / R<br>
</blockquote>
	where R is the {@link Projection#Local_Radius(double) radius} of the
	body at the Center_Latitude.
<p>
	@param	image_coordinate	The image sample,line coordinate.
	@return	The world longitude,latitude coordinate. The {@link
		Point2D#getX() x} value of the coordinate Point2D is the
		longitude; the {@link Point2D#getY() y} value is the latitude.
		Values are in degrees within the range 0-360.
*/
public Point2D.Double to_World
	(
	Point2D		image_coordinate
	)
	throws IllegalArgumentException
{
if (image_coordinate == null)
	throw new IllegalArgumentException (ID + '\n'
		+ "Unable to project image coordinates to world coordinates\n"
		+ "because the image coordinates point is null.");
if ((DEBUG & DEBUG_CONVERTERS) != 0)
	System.out.println
		(">>> Equirectangular_Projection.to_World: " + image_coordinate);
Point2D.Double
	world_coordinate = null;
if (Not_Identity)
	{
	if ((DEBUG & DEBUG_CONVERTERS) != 0)
		{
		double
			value;
		value = 
			Center_Longitude
			+ Sample_to_Projection_X (image_coordinate.getX ())
			/ Coefficient_CLR;
		System.out.println
			("    StrictMath.toDegrees (\n"
			+"    Center_Longitude " + Center_Longitude + " +\n"
			+"    Sample_to_Projection_X (" + image_coordinate.getX () + ") "
				+ Sample_to_Projection_X (image_coordinate.getX ()) + " /\n"
			+"    Coefficient_CLR " + Coefficient_CLR + " = " + value + "\n"
			+"    ) = " + StrictMath.toDegrees (value));
		value =
			Line_to_Projection_Y (image_coordinate.getY ())
			/ Center_Latitude_Radius;
		System.out.println
			("    StrictMath.toDegrees (\n"
			+"    Line_to_Projection_Y (" + image_coordinate.getY () + ") "
				+ Line_to_Projection_Y (image_coordinate.getY ()) + " /\n"
			+"    Center_Latitude_Radius " + Center_Latitude_Radius
				+ " = " + value + "\n"
			+"    ) = " + StrictMath.toDegrees (value));
		}
	world_coordinate = new Point2D.Double
		(
		StrictMath.toDegrees (
			Center_Longitude
			+ Sample_to_Projection_X (image_coordinate.getX ())
			/ Coefficient_CLR),
		StrictMath.toDegrees (
			Line_to_Projection_Y (image_coordinate.getY ())
			/ Center_Latitude_Radius)
		);
	}
else
	world_coordinate = new Point2D.Double
		(image_coordinate.getX (), image_coordinate.getY ());
if ((DEBUG & DEBUG_CONVERTERS) != 0)
	System.out.println
		("<< Equirectangular_Projection.to_World: " + world_coordinate);
return world_coordinate;
}

/**	Get the image sample,line coordinate for a world longitude,latitude
	coordinate.
<p>
	The conversion algorithm is:
<p><blockquote>

</blockquote>
<p>
	@param	world_coordinate	The world longitude,latitude coordinate.
		The {@link Point2D#getX() x} value of the coordinate Point2D is
		the longitude; the {@link Point2D#getY() y} value is the
		latitude. Values are in degrees.
	@return	The image sample,line coordinate.
*/
public Point to_Image
	(
	Point2D		world_coordinate
	)
	throws IllegalArgumentException
{
if (world_coordinate == null)
	throw new IllegalArgumentException (ID + '\n'
		+ "Unable to project world coordinates to image coordinates\n"
		+ "because the world coordinates point is null.");
Point
	image_coordinate = null;
if (Not_Identity)
	image_coordinate = new Point
		(
		(int)(Projection_X_to_Sample (Coefficient_CLR
			* (StrictMath.toRadians (world_coordinate.getX ())
				- Center_Longitude))
			+ 0.5),		//	Round to nearest pixel.
		(int)(Projection_Y_to_Line (Center_Latitude_Radius
			* StrictMath.toRadians (world_coordinate.getY ()))
			+ 0.5)		//	Round to nearest pixel.
		);
else
	image_coordinate = new Point
		((int)world_coordinate.getX (), (int)world_coordinate.getY ());
return image_coordinate;
}


}
