/*	Table_Mouse_Listener

PIRL CVS ID: Table_Mouse_Listener.java,v 1.5 2012/04/16 06:04:11 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package	PIRL.Conductor;

import	javax.swing.JTable;
import	java.awt.event.MouseAdapter;
import	java.awt.event.MouseEvent;
import	java.awt.Point;


/**	A <i>Table_Mouse_Listener</i> provides deselect capability for
	table selections.
<p>
	If a single mouse click of button one with a control key pressed
	occurs in a selected table column that column is deselected.
<p>
	@author		Bradford Castalia, UA/PIRL
	@version	1.5
*/
public class Table_Mouse_Listener
	extends MouseAdapter
{
public void mouseClicked
	(
	MouseEvent event
	)
{
if (event.isControlDown () &&
	event.getButton () == MouseEvent.BUTTON1 &&
	event.getClickCount () == 1 &&
	event.getComponent () instanceof JTable)
	{
	JTable
		table = (JTable)event.getComponent ();
	int
		column = table.getSelectedColumn ();
	if (column >= 0)
		{
		Point
			point = event.getPoint ();
		if (column == table.columnAtPoint (point) &&
			table.rowAtPoint (point) >= 0)
			table.removeColumnSelectionInterval (column, column);
		}
	}
}

}
