#!/usr/bin/perl
#
# Perl script to generate PCV file for Sotm 30
#

print "header {\n";
print "        title = \"Syslog picviz analysis\";\n";
print "}\n";
print "engine {\n";
print "        relative = \"1\";\n";
print "}\n";
print "axes {\n";
print "        timeline t [label=\"Timeline\"];\n";
print "        string   src [label=\"Source\"];\n";
print "        string   dst [label=\"Dest\"];\n";
print "        gold     len [label=\"Len\"];\n";
print "        char     ttl [label=\"TTL\"];\n";
print "        integer  id  [label=\"ID\"];\n";
print "        integer  spt [label=\"Sport\"];\n";
print "        integer  dpt [label=\"Dport\"];\n";
print "}\n";

print "data {\n";

while ($line = <>) {

	$line =~ s/\\/\\\\/g;
	$line =~ s/\"|&|<|>/\\"/g;

	# Oct 26 10:17:31 marcadet kernel: [10667.959403] IN= OUT=eth1 SRC=192.168.0.10 DST=65.111.165.42 LEN=100 TOS=0x10 PREC=0x00 TTL=64 ID=11359 DF PROTO=TCP SPT=38044 DPT=22 WINDOW=1002 RES=0x00 ACK PSH URGP=0
        $line =~ m/(\w+) (\d+) (\d+:\d+:\d+) (\w+) (\S+):(.*)SRC=(\d+.\d+.\d+.\d+) DST=(\d+.\d+.\d+.\d+) LEN=(\d+).*TTL=(\d+) ID=(\d+).*PROTO=(\w+) SPT=(\d+) DPT=(\d+).*/;

	$month = $1;
	$day = $2;
	$time = $3;
	$machine = $4;
	$log_type = $5; # kernel all the time, so we don't care
	$flow = $6; # [10667.959403] IN= OUT=eth1
	$src = $7;
	$dst = $8;
	$len = $9;
	$ttl = $10;
	$id = $11;
	$proto = $12;
	$sport = $13;
	$dport = $14;

	if ($proto =~ m/TCP/) {
		print "    t=\"$time\",src=\"$src\",dst=\"$dst\",len=\"$len\",ttl=\"$ttl\", id=\"$id\", spt=\"$sport\", dpt=\"$dport\" [color=\"yellow\"];\n";
	} elsif ($proto =~ m/UDP/) {
		print "    t=\"$time\",src=\"$src\",dst=\"$dst\",len=\"$len\",ttl=\"$ttl\", id=\"$id\", spt=\"$sport\", dpt=\"$dport\" [color=\"blue\"];\n";
	} elsif ($proto =~ m/ICMP/) {
		print "    t=\"$time\",src=\"$src\",dst=\"$dst\",len=\"$len\",ttl=\"$ttl\", id=\"$id\", spt=\"$sport\", dpt=\"$dport\" [color=\"turquoise\"];\n";
	} else {
		print "    t=\"$time\",src=\"$src\",dst=\"$dst\",len=\"$len\",ttl=\"$ttl\", id=\"$id\", spt=\"$sport\", dpt=\"$dport\";\n";
	}
}

print "}\n";

