#include "regexp.h"
#include <string>


using namespace Paco;
using std::string;


Regexp::Regexp(string const& exp, bool icase /* = 0 */)
:
	mOk(false)
{
	mOk = !regcomp(&mRegex, exp.c_str(), REG_NOSUB | REG_EXTENDED | (REG_ICASE & icase));
}


Regexp::~Regexp()
{
	regfree(&mRegex);
}


bool Regexp::run(string const& str)
{
	return mOk && regexec(&mRegex, str.c_str(), 0, 0, 0) != REG_NOMATCH;
}

