//=======================================================================
// out.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef PACO_OUT_H
#define PACO_OUT_H

#include <iosfwd>


namespace Paco {

class Out
{
	public:

	enum {
		QUIET,
		VERBOSE,
		DEBUG
	};

	Out();
	
	int& verbosity()	{ return mVerbosity; }

	static int screenWidth();

	void vrb(std::string const&, int __errno = 0);
	void dbg(std::string const&, bool printProgName = true);
	void dbgTitle(std::string const& title);

	class Silencer
	{
		public:

		Silencer();
		~Silencer();

		private:

		int mOldVerbosity;
	};

	private:

	int mVerbosity;
};

}	// namespace Paco


#endif  // PACO_OUT_H

