//=======================================================================
// preferences.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "gconfig.h"
#include "preferences.h"
#include "mainwindow.h"
#include <gtkmm/frame.h>
#include <gtkmm/stock.h>	// Gtk::RESPONSE_OK
#include <gtkmm/checkbutton.h>

using namespace Gpaco;


Preferences::Preferences(MainWindow& w)
:
	Gtk::Dialog("GPaco :: Preferences"),
	mButtons(),
	mButtonHour("Show _hour in date", true),
	mMainWindow(w)
{
	set_border_width(4);
	set_has_separator();
	set_resizable(false);

	signal_response().connect(mem_fun(*this, &Preferences::response));

	add_button(Gtk::Stock::OK, Gtk::RESPONSE_OK);

	Gtk::VButtonBox* buttonBoxLeft = Gtk::manage
		(new Gtk::VButtonBox(Gtk::BUTTONBOX_START));
	buttonBoxLeft->set_border_width(4);

	Gtk::VButtonBox* buttonBoxRight = Gtk::manage
		(new Gtk::VButtonBox(Gtk::BUTTONBOX_START));
	buttonBoxRight->set_border_width(4);

	Glib::ustring names[] = { "_Icon", "_Name", "_Size", "Size _missing", 
		"Size _percent", "_Date", "_Files", "Files missin_g", 
		"Files per_cent", "Summ_ary" };

	for (int i(0); i < MainTreeView::N_COLS; ++i) {
		mButtons[i] = Gtk::manage(new Gtk::CheckButton(names[i], true));
		mButtons[i]->set_active(mMainWindow.isColumnVisible(i));
		mButtons[i]->signal_clicked().connect(sigc::mem_fun(*this, 
			&Preferences::onButtonClicked));
		if (i < MainTreeView::N_COLS / 2)
			buttonBoxLeft->pack_start(*mButtons[i]);
		else
			buttonBoxRight->pack_start(*mButtons[i]);
	}

	mButtonHour.set_active(GConfig::hour());
	mButtonHour.signal_clicked().connect(sigc::mem_fun(*this, 
		&Preferences::onButtonClicked));
	
	Gtk::HBox* pHBox = Gtk::manage(new Gtk::HBox());
	pHBox->pack_start(*buttonBoxLeft);
	pHBox->pack_start(*buttonBoxRight);
	Gtk::Frame* pVisibleColumnsFrame = Gtk::manage
		(new Gtk::Frame(" Visible columns "));
	pVisibleColumnsFrame->add(*pHBox);

	get_vbox()->set_spacing(4);
	get_vbox()->pack_start(*pVisibleColumnsFrame);
	get_vbox()->pack_start(mButtonHour);
	
	show_all();
}


void Preferences::response(int)
{
	hide();
}


void Preferences::onButtonClicked()
{
	for (int j(0); j < MainTreeView::N_COLS; ++j)
		mMainWindow.setColumnVisible(j, mButtons[j]->get_active());
	GConfig::hour(mButtonHour.get_active());
	mMainWindow.treeView()->refresh();
}

