# Orthanc - A Lightweight, RESTful DICOM Store
# Copyright (C) 2012-2016 Sebastien Jodogne, Medical Physics
# Department, University Hospital of Liege, Belgium
# Copyright (C) 2017-2023 Osimis S.A., Belgium
# Copyright (C) 2024-2025 Orthanc Team SRL, Belgium
# Copyright (C) 2021-2025 Sebastien Jodogne, ICTEAM UCLouvain, Belgium
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation, either version 3 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program. If not, see
# <http://www.gnu.org/licenses/>.


set(EMBED_RESOURCES_PYTHON "${CMAKE_CURRENT_LIST_DIR}/../EmbedResources.py"
  CACHE INTERNAL "Path to the EmbedResources.py script from Orthanc")
set(AUTOGENERATED_DIR "${CMAKE_CURRENT_BINARY_DIR}/AUTOGENERATED")
set(AUTOGENERATED_SOURCES)

file(MAKE_DIRECTORY ${AUTOGENERATED_DIR})
include_directories(${AUTOGENERATED_DIR})

macro(EmbedResources)
  # Convert a semicolon separated list to a whitespace separated string
  set(SCRIPT_OPTIONS)
  set(SCRIPT_ARGUMENTS)
  set(DEPENDENCIES)
  set(IS_PATH_NAME false)

  set(TARGET_BASE "${AUTOGENERATED_DIR}/EmbeddedResources")

  # Loop over the arguments of the function
  foreach(arg ${ARGN})
    # Extract the first character of the argument
    string(SUBSTRING "${arg}" 0 1 FIRST_CHAR)
    if (${FIRST_CHAR} STREQUAL "-")
      # If the argument starts with a dash "-", this is an option to
      # EmbedResources.py
      if (${arg} MATCHES "--target=.*")
        # Does the argument starts with "--target="?
        string(SUBSTRING "${arg}" 9 -1 TARGET)  # 9 is the length of "--target="
        set(TARGET_BASE "${AUTOGENERATED_DIR}/${TARGET}")
      else()
        list(APPEND SCRIPT_OPTIONS ${arg})
      endif()
    else()
      if (${IS_PATH_NAME})
        list(APPEND SCRIPT_ARGUMENTS "${arg}")
        list(APPEND DEPENDENCIES "${arg}")
        set(IS_PATH_NAME false)
      else()
        list(APPEND SCRIPT_ARGUMENTS "${arg}")
        set(IS_PATH_NAME true)
      endif()
    endif()
  endforeach()

  add_custom_command(
    OUTPUT
    "${TARGET_BASE}.h"
    "${TARGET_BASE}.cpp"
    COMMAND ${PYTHON_EXECUTABLE} ${EMBED_RESOURCES_PYTHON}
            ${SCRIPT_OPTIONS} "${TARGET_BASE}" ${SCRIPT_ARGUMENTS}
    DEPENDS
    ${EMBED_RESOURCES_PYTHON}
    ${DEPENDENCIES}
    )

  list(APPEND AUTOGENERATED_SOURCES
    "${TARGET_BASE}.cpp"
    ) 
endmacro()
