Minutes from 78th OpenVDB TSC meeting, Feb 2nd, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Ken* M., *Dan* B, *Andre* P.

Additional Attendees: Johannes Meng (Intel), JT Nelson (Blender),
Bruce Chernaik (Intel), Laura Lediaev (ImageWorks)

Regrets: none

Agenda:

1) Confirm Quorum
2) Secretary
3) Blender Update
4) GitHub Issues
5) Removal of EXR from Core
6) Half Update
7) NanoVDB
8) CSG Intersection Fix
9) Update Documentation Process
10) Boost Minimum Requirements
11) AX SOP
12) Next meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait.

3) Blender Update

A brief update on the current integration status of VDB with Blender,
a more full update will be done when the documentation and code are
properly in sync.

4) GitHub Issues

We have an issue with issues.  We have too many and it is growing.  Some issues are things like tbb 2021 not being supported.   Others are things we have already triaged - but they stay on the list.  For example, the suggestion for a proxy for meshes.   Moving to Jira would clear our Issue list, but mean there are many places to look (and submit) for the current status.  We find the Issues are mixture of bugs, ideas, and questions.  One option is a discussion tab.  But this again is another place to go, and what happens when a discussion becomes a bug?  Submitters should not be expected to know where things go.

There is a flow of new issues from Unprocessed to In Process to Discussed.  Should we make this explicit so we can ensure all issues have been Discussed?

There is a risk that if we leave discussed issues active, our project looks incompetent as there are many open issues.

Bug vs Enhancement labels is something we should probably add as a result of discussion rather than from the submitter.   The How To Submit Issues should talk about how we use labels and what they mean.

Do we want a tag for issues we are currently working on?

We decided to continute the discussion offline.  Nick will provide an initial google doc seeded with the Jira workflow.

5) Removal of EXR from Core

Problematic as people use it.  However, known use cases are with the command
line render tool, which will be unaffected.  Could we have it still kept
without support in our CMake?  But this leaves people little better off,
if they can alter the CMake to add the library support, they could as
easily add the explicit saveEXR code from the command line utility.
We are now in agreement to remove the saveEXR from the core library.

6) Half Update

CMake now configures BuildConfig.h.  This stores if you built with EXR half.  Still needs to be validated that this works with external Half implementations.  It was proposed the flag refer to IMath half rather than Exr as it is planned to move to an external library.  Or maybe it should be an external half flag?

7) NanoVDB

How to store half in memory?  Could quantize on statistics?  Ie, the leaf nodes know their min/max, so if had 8bits of precision could store values within that.  If the quantization is stored per leaf node, this would require the codec switch to be done per leaf node.  The suggestion is instead that the entire tree gets quantized with a fixed codec.

It was noted you need to dither the quantization.  Raytracing soft fog can become very sensitive to quantization jumps.  It was pointed out Bayer dithering does not work for this as it is optimal for area integrals, but volumes need to be optimal for arbitrary line integrals.

NanoVDB stores tile offsets rather than byte offsets, so cannot have varying codec in the leaf nodes as leave nodes must be fixed size.  Points tried varying codecs, but not very useful.  Maybe leave room for a codec per leaf node?

Maybe a global range to avoid jumps in quality between neighbour leaves.  Having each leaf have its own quantization can result in neighbour leaves having very different qualities - imagine a single stray 1000 value that crushes low values around it; versus a leaf with only low density that is preserved.  Out of range values could then be clamped, letting an artist control quality with an a priori quality metric.

A big question is do we have half as a type or a codec?  Discussion is tabled until a later meeting.

8) CSG Intersection Fix


Fix is complete.  Resolves the root node problem.  Updated the old unit tests and verified against the old composite header.  One change is to make the operations commutative in an rare case, but this is likely more correct.

Does this need migration documentation?  The migration document is required for the leaf manager, not for this.  This merely fixes what should have been a drop in replacement.

9) Update Documentation Process

The 7.2.2 update is a chance to streamline this.  Will try to build documentation via github actions.  Goal is to get into github pages.  Then website can point to the github pages.

10) Boost Minimum Requirements

We need to support 1.66, but do not need to prohibit 1.61.  While Houdini is technically correct to have 1.61 in 18.0 because it is hboost, not boost, in practice we pass void * across from the built OpenVDB with the native Houdini OpenVDB; so if there are any internal boost structures they need to be binary compatible.  So moving forward the Houdini boost should sync with the vfx reference platform even though it is hboosted.  18.5 has already moved forward.

In the short term we can change the cmake to only require 1.61 so you can use 18.0.  We should consider adding a CI test for Houdini 18.0 compatibility to explicitly use 1.61 rather than 1.66, however, to verify we do not introduce a 1.61 incompatibility.

11) AX SOP

Ready to go, needs approval

12) Next meeting

Next meeting is Feb 9th, 2021. 12pm-1pm EST (GMT-5).
