###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_viplay_vpl_file_bof_vuln.nasl 2376 2009-05-25 14:34:29Z may $
#
# ViPlay .vpl File Stack Overflow Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900361);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1660");
  script_bugtraq_id(34877);
  script_name("ViPlay .vpl File Stack Overflow Vulnerability");
  desc = "

  Overview: This host is installed with ViPlay Media Player and is prone to
  stack overflow vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper boundry checks while parsing .vpl files.

  Impact:
  Attackers may leverage this issue by executing arbitrary codes in the context
  of an affected application and cause stack overflow to crash the application.

  Impact Level: System/Application

  Affected Software/OS:
  ViPlay3 version 3.0 and prior.

  Fix: No solution or patch is available as on 26th May, 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.urusoft.net/home.php?lang=1

  References:
  http://www.milw0rm.com/exploits/8644
  http://xforce.iss.net/xforce/xfdb/50403

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of ViPlay");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_viplay_detect.nasl");
  script_require_keys("ViPlay/MediaPlayer/Ver");
  exit(0);
}


include("version_func.inc");

viplayVer = get_kb_item("ViPlay/MediaPlayer/Ver");
if(!viplayVer){
  exit(0);
}

if(version_is_less_equal(version:viplayVer, test_version:"3.0")){
  security_hole(0);
}
