##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_opendocman_detect.nasl 5500 2009-10-28 23:38:29Z oct $
#
# OpenDocMan Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900884);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("OpenDocMan Version Detection");
  desc = "
  Overview: This script detects the installed OpenDocMan version and sets
  the result in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Set KB for the version of OpenDocMan");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

docmanPort = get_http_port(default:80);
if(!docmanPort){
  exit(0);
}

foreach dir (make_list("/", "/docman", "/opendocman", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:docmanPort);
  rcvRes = http_send_recv(port:docmanPort, data:sndReq);
  if(isnull(rcvRes))
  {
    sndReq = http_get(item:string(dir, "/admin.php"), port:docmanPort);
    rcvRes = http_send_recv(port:docmanPort, data:sndReq);
    if(isnull(rcvRes)){
      exit(0);
    }
  }

  if("Welcome to OpenDocMan" >< rcvRes &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    docmanVer = eregmatch(pattern:"OpenDocMan v([0-9.]+)([a-z]+[0-9])?",
                          string:rcvRes);
    if(docmanVer[1])
    {
      if(docmanVer[2])
        docmanVer = docmanVer[1] + "." + docmanVer[2];
      else
        docmanVer = docmanVer[1];
      set_kb_item(name:"www/"+ docmanPort + "/OpenDocMan",
                  value:docmanVer + " under " + dir);
      security_note(data:"OpenDocMan version " + docmanVer + " running at " +
                         "location " + dir +  " was detected on the host");
    }
  }
}
