###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_url_spoof_vuln_win.nasl 1060 2009-02-25 16:05:33Z feb $
#
# Firefox URL Spoofing And Phising Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900513);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-0652");
  script_bugtraq_id(33837);
  script_name("Firefox URL Spoofing And Phising Vulnerability (Win)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to URL spoofing and phising vulnerability.

  Vulnerability Insight:
  Firefox doesn't properly prevent the literal rendering of homoglyph
  characters in IDN domain names. This renders the user vulnerable to URL
  spoofing and phising attacks as the atatcker may redirect the user to a
  different arbitrary malformed website.

  Impact: Successful remote exploitation will let the attacker spoof the URL
  information by using homoglyphs of say the /(slash) and ?(question mark)and
  can gain sensitive information by redirecting the user to any malicious URL.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version 3.0.6 and prior on Windows.

  Fix: Upgrade to Mozilla Firefox version 3.6.3 or later
  For updates refer, http://www.mozilla.com/en-US/firefox/

  References:
  http://www.mozilla.org/projects/security/tld-idn-policy-list.html
  http://www.blackhat.com/html/bh-dc-09/bh-dc-09-speakers.html#Marlinspike

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score : 4.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Mozilla Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

firefoxVer = get_kb_item("Firefox/Win/Ver");
if(!firefoxVer){
  exit(0);
}

if(version_is_less_equal(version:firefoxVer, test_version:"3.0.6")){
  security_warning(0);
}
