###############################################################################
# OpenVAS Vulnerabilities Test
# $Id: secpod_cowon_jetaudio_wav_dos_vuln.nasl 5794 2009-11-18 17:21:45Z nov $
#
# COWON Media Center JetAudio .wav File Denial Of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900977);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3948");
  script_name("COWON Media Center JetAudio .wav File Denial Of Service Vulnerability");
  desc = "
  Overview: This host has COWON Media Center JetAudio installed and is prone
  to Denial of Service vulnerability.

  Vulnerabilities Insight:
  An error occurs while parsing a .wav file containing an overly long string
  at the end.

  Impact:
  Attackers can exploit this issue to corrupt memory and cause the application
  to crash.

  Impact Level: Application

  Affected Software/OS:
  COWON Media Center JetAudio 7.5.3 on Windows.

  Fix: Upgrade to COWON Media Center JetAudio version 8.0.6 or later
  For updates refer, http://www.jetaudio.com/

  References:
  http://www.milw0rm.com/exploits/9139
  http://xforce.iss.net/xforce/xfdb/51697

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of COWON Media Center JetAudio");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_cowon_jetaudio_detect.nasl");
  script_require_keys("JetAudio/Ver");
  exit(0);
}


include("version_func.inc");

jaVer = get_kb_item("JetAudio/Ver");

if(jaVer != NULL)
{
  # Check if the version is equal to 7.5.3 => 7.5.3.15
  if(version_is_equal(version:jaVer, test_version:"7.5.3.15")){
    security_warning(0);
  }
}
