###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_perforce_2009_2.nasl 7463 2010-04-29 11:57:02Z chandra $
#
# Perforce 2009.2 Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100519);
 script_bugtraq_id(38590,38591,38586);
 script_version ("1.0-$Revision: 7463 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Perforce 2009.2 Multiple Vulnerabilities");

desc = "Overview:
Perforce Server is prone to Multiple Vulnerabilities.

1. An information-disclosure vulnerability.
An attacker can exploit this issue gain access to sensitive
information that may lead to further attacks.

2. A directory-traversal vulnerability. 
An attacker can exploit this issue to overwrite arbitrary files within
the context of the application. Successful exploits may compromise the
affected application and possibly the underlying computer.

3. A security-bypass vulnerability.
An attacker can exploit this issue to change a user's password,
thereby aiding in further attacks. 

Perforce Server 2009.2 is vulnerable; other versions may also
be affected.

References:
http://www.securityfocus.com/bid/38590
http://www.securityfocus.com/bid/38591
http://www.securityfocus.com/bid/38586
http://www.perforce.com/perforce/products/p4d.html
http://resources.mcafee.com/forms/Aurora_VDTRG_WP

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if installed Perforce Server is vulnerable");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("perforce_detect.nasl");
 script_require_ports("Services/perforce", 1666);
 exit(0);
}

include("version_func.inc");

port = get_kb_item("Services/perforce");
if(!port)exit(0);
if (!get_tcp_port_state(port))exit(0);

if(!vers = get_kb_item(string("perforce/", port, "/version")))exit(0);
if(!isnull(vers)) {

  if(!version = split(vers, sep: "/", keep: 0))exit(0);
  if(version_is_equal(version: version[2], test_version: "2009.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);

