# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 783-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55164);
 script_cve_id("CVE-2005-1636");
 script_bugtraq_id(13660);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 783-1 (mysql-dfsg-4.1)";
 script_name(name);

 desc = "The remote host is missing an update to mysql-dfsg-4.1
announced via advisory DSA 783-1.

Eric Romang discovered a temporary file vulnerability in a script
accompanied with MySQL, a popular database, that allows an attacker to
execute arbitrary SQL commands when the server is installed or
updated.

The old stable distribution (woody) as well as mysql-dfsg are not
affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 4.1_4.1.11a-4sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 4.1.12 for mysql-dfsg-4.1 and 5.0.11beta-3 of mysql-dfsg-5.0.

We recommend that you upgrade your mysql packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20783-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 783-1 (mysql-dfsg-4.1)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mysql-common-4.1", ver:"4.1.11a-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient14", ver:"4.1.11a-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmysqlclient14-dev", ver:"4.1.11a-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-client-4.1", ver:"4.1.11a-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mysql-server-4.1", ver:"4.1.11a-4sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
