# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1053-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56717);
 script_cve_id("CVE-2006-1993");
 script_bugtraq_id(17671);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1053-1 (mozilla)";
 script_name(name);

 desc = "The remote host is missing an update to mozilla
announced via advisory DSA 1053-1.

Martijn Wargers and Nick Mott described crashes of Mozilla due to the
use of a deleted controller context.  In theory this could be abused to
execute malicious code.

For the stable distribution (sarge) this problem has been fixed in
version 1.7.8-1sarge6.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your mozilla packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201053-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1053-1 (mozilla)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnspr4", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss-dev", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss3", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-browser", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-calendar", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-chatzilla", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-dev", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-dom-inspector", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-js-debugger", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-mailnews", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-psm", ver:"1.7.8-1sarge6", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
