/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "Color.h"

#include "Debug.h"
#include "RgbaF.h"
#include "SharedPointer.h"

using namespace GTLCore;

struct Color::Private : public SharedPointerData {
  Private() {}
  Private(const Private& _rhs) : SharedPointerData(), rgbaf(_rhs.rgbaf)
  {}
  RgbaF rgbaf;
};

Color::Color() : d(new Private)
{
  d->ref();
  d->rgbaf.r = 0.0;
  d->rgbaf.g = 0.0;
  d->rgbaf.b = 0.0;
  d->rgbaf.a = 0.0;
}

Color::Color(float r, float g, float b, float a) : d(new Private)
{
  d->ref();
  d->rgbaf.r = r;
  d->rgbaf.g = g;
  d->rgbaf.b = b;
  d->rgbaf.a = a;
}

GTL_SHARED_DATA(Color)

bool Color::operator==(const Color& c)
{
  if (d == c.d) return true;
  return d->rgbaf.r == c.d->rgbaf.r and d->rgbaf.g == c.d->rgbaf.g and d->rgbaf.b == c.d->rgbaf.b and d->rgbaf.a == c.d->rgbaf.a;
}

float Color::red() const
{
  return d->rgbaf.r;
}

float Color::green() const
{
  return d->rgbaf.g;
}

float Color::blue() const
{
  return d->rgbaf.b;
}

float Color::alpha() const
{
  return d->rgbaf.a;
}

void Color::setRed(float r)
{
  deref();
  d->rgbaf.r = r;
}

void Color::setGreen(float r)
{
  deref();
  d->rgbaf.g = r;
}

void Color::setBlue(float r)
{
  deref();
  d->rgbaf.b = r;
}

void Color::setAlpha(float r)
{
  deref();
  d->rgbaf.a = r;
}

const RgbaF& Color::rgbaf() const
{
  return d->rgbaf;
}
