#!/bin/bash

#################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#################################################################################

if test "$2" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$2" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$2" = sfcb
then
	/etc/init.d/sfcb stop
fi

$4/registration/OpenDRIM_GroupOnSystem-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Account-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountManagementCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_IdentityInGroup-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_GroupIdentity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountAssociatedCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountManagementServiceCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Group-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountManagementServiceConformsToProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_RegisteredSimpleIdentityManagementProfile-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_HostedAccountManagementService-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountManagementService-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountManagementServiceAffectsIdentity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_GroupAssignedIdentity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountAssignedIdentity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountIdentity-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountCapabilities-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_AccountOnSystem-remove.sh $1 $2 $3 $4
$4/registration/OpenDRIM_Identity-remove.sh $1 $2 $3 $4

if test "$2" = sfcb
then
	/etc/init.d/sfcb start
fi

