% etxt2int(text)
% converts text vector to integer vector 
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010
function [intVector, nInt]=etxt2int(text)
  if (nargin~=1)
    eusage('intVector=etxt2int(text)');
  end
  text=text+0;
  [n m]=size(text);
  if n==1
    nInt=ceil(m/4);
    text=[text 0 0 0];
  else
    nInt=ceil(n/4);
    text=[text' 0 0 0];
  end
  ind=1:4:(nInt*4)-3;
  intVector=text(ind);
  ind=ind+1;
  intVector=intVector+bitshift(text(ind),8);
  ind=ind+1;
  intVector=intVector+bitshift(text(ind),16);
  ind=ind+1;
  intVector=intVector+bitshift(text(ind),24);
