// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeFix_Shape_HeaderFile
#define _ShapeFix_Shape_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_ShapeFix_Shape.hxx>

#include <TopoDS_Shape.hxx>
#include <Handle_ShapeFix_Solid.hxx>
#include <TopTools_MapOfShape.hxx>
#include <Standard_Integer.hxx>
#include <ShapeFix_Root.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Message_ProgressIndicator.hxx>
#include <Handle_ShapeFix_Shell.hxx>
#include <Handle_ShapeFix_Face.hxx>
#include <Handle_ShapeFix_Wire.hxx>
#include <Handle_ShapeFix_Edge.hxx>
#include <ShapeExtend_Status.hxx>
#include <Handle_ShapeExtend_BasicMsgRegistrator.hxx>
#include <Standard_Real.hxx>
class ShapeFix_Solid;
class TopoDS_Shape;
class Message_ProgressIndicator;
class ShapeFix_Shell;
class ShapeFix_Face;
class ShapeFix_Wire;
class ShapeFix_Edge;
class ShapeExtend_BasicMsgRegistrator;


//! Fixing shape in general
class ShapeFix_Shape : public ShapeFix_Root
{

public:

  
  //! Empty Constructor
  Standard_EXPORT ShapeFix_Shape();
  
  //! Initislises by shape.
  Standard_EXPORT ShapeFix_Shape(const TopoDS_Shape& shape);
  
  //! Initislises by shape.
  Standard_EXPORT   void Init (const TopoDS_Shape& shape) ;
  
  //! Iterates on sub- shape and performs fixes
  Standard_EXPORT   Standard_Boolean Perform (const Handle(Message_ProgressIndicator)& theProgress = 0) ;
  
  //! Returns resulting shape
  Standard_EXPORT   TopoDS_Shape Shape()  const;
  
  //! Returns tool for fixing solids.
      Handle(ShapeFix_Solid) FixSolidTool()  const;
  
  //! Returns tool for fixing shells.
      Handle(ShapeFix_Shell) FixShellTool()  const;
  
  //! Returns tool for fixing faces.
      Handle(ShapeFix_Face) FixFaceTool()  const;
  
  //! Returns tool for fixing wires.
      Handle(ShapeFix_Wire) FixWireTool()  const;
  
  //! Returns tool for fixing edges.
      Handle(ShapeFix_Edge) FixEdgeTool()  const;
  
  //! Returns the status of the last Fix.
  //! This can be a combination of the following flags:
  //! ShapeExtend_DONE1: some free edges were fixed
  //! ShapeExtend_DONE2: some free wires were fixed
  //! ShapeExtend_DONE3: some free faces were fixed
  //! ShapeExtend_DONE4: some free shells were fixed
  //! ShapeExtend_DONE5: some free solids were fixed
  //! ShapeExtend_DONE6: shapes in compound(s) were fixed
  Standard_EXPORT   Standard_Boolean Status (const ShapeExtend_Status status)  const;
  
  //! Sets message registrator
  Standard_EXPORT virtual   void SetMsgRegistrator (const Handle(ShapeExtend_BasicMsgRegistrator)& msgreg) ;
  
  //! Sets basic precision value (also to FixSolidTool)
  Standard_EXPORT virtual   void SetPrecision (const Standard_Real preci) ;
  
  //! Sets minimal allowed tolerance (also to FixSolidTool)
  Standard_EXPORT virtual   void SetMinTolerance (const Standard_Real mintol) ;
  
  //! Sets maximal allowed tolerance (also to FixSolidTool)
  Standard_EXPORT virtual   void SetMaxTolerance (const Standard_Real maxtol) ;
  
  //! Returns (modifiable) the mode for applying fixes of
  //! ShapeFix_Solid, by default True.
      Standard_Integer& FixSolidMode() ;
  
  //! Returns (modifiable) the mode for applying fixes of
  //! ShapeFix_Shell, by default True.
      Standard_Integer& FixFreeShellMode() ;
  
  //! Returns (modifiable) the mode for applying fixes of
  //! ShapeFix_Face, by default True.
      Standard_Integer& FixFreeFaceMode() ;
  
  //! Returns (modifiable) the mode for applying fixes of
  //! ShapeFix_Wire, by default True.
      Standard_Integer& FixFreeWireMode() ;
  
  //! Returns (modifiable) the mode for applying
  //! ShapeFix::SameParameter after all fixes, by default True.
      Standard_Integer& FixSameParameterMode() ;
  
  //! Returns (modifiable) the mode for applying
  //! ShapeFix::FixVertexPosition before all fixes, by default False.
      Standard_Integer& FixVertexPositionMode() ;




  DEFINE_STANDARD_RTTI(ShapeFix_Shape)

protected:

  
  //! Fixes same parameterization problem on the passed shape
  //! by updating tolerances of the corresponding topological
  //! entitites.
  Standard_EXPORT   void SameParameter (const TopoDS_Shape& shape, const Standard_Boolean enforce, const Handle(Message_ProgressIndicator)& theProgress = 0) ;

  TopoDS_Shape myResult;
  Handle(ShapeFix_Solid) myFixSolid;
  TopTools_MapOfShape myMapFixingShape;
  Standard_Integer myFixSolidMode;
  Standard_Integer myFixShellMode;
  Standard_Integer myFixFaceMode;
  Standard_Integer myFixWireMode;
  Standard_Integer myFixSameParameterMode;
  Standard_Integer myFixVertexPositionMode;
  Standard_Integer myStatus;


private: 




};


#include <ShapeFix_Shape.lxx>





#endif // _ShapeFix_Shape_HeaderFile
