/* NVTV i810 TV-I2C header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_i810.h,v 1.6 2003/10/15 10:57:58 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Routines to control the TV and the I2C bus on Intel i810 etc. 
 * cards.
 *
 */

#ifndef _TV_I810_H
#define _TV_I810_H

#include "i810_type.h"

Bool I810TvBusInit (I810Ptr pI810);
void I810TvBusConfig (I810Ptr pI810);

void I810UpdateTvState (I810Ptr pI810);

void I810SetTvDevice (I810Ptr pI810, I2CChainPtr chain, Bool init);
void I810DestroyDevices (I810Ptr pI810);
void I810DestroyBusses (I810Ptr pI810);
void I810ProbeTvDevices (I810Ptr pI810);

void I810SetTestImage (I810Ptr pI810, TVEncoderRegs *r);
void I810SetTvMode (I810Ptr pI810, TVRegs *r);
void I830SetTvMode (I810Ptr pI810, TVRegs *r);
void IntelSetTvMode (I810Ptr pI810, TVRegs *r);

long I810GetTvStatus (I810Ptr pI810, int index);
TVConnect I810GetTvConnect (I810Ptr pI810);

int I810GetDevFlags (I810Ptr pI810);
int I830GetDevFlags (I810Ptr pI810, int head);
int IntelGetDevFlags (I810Ptr pI810, int head);

#endif /* _TV_I810_H */
