/*
   For more information, please see: http://software.sci.utah.edu

   The MIT License

   Copyright (c) 2009 Scientific Computing and Imaging Institute,
   University of Utah.


   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included
   in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
   THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
   DEALINGS IN THE SOFTWARE.
*/
/**
  \file    tr1.h
  \author  Tom Fogal
           SCI Institute
           University of Utah
  \brief   Works around issues using TR1.
*/
#ifndef BASICS_TR1_H
#define BASICS_TR1_H

// gcc 4.0.[01] had a bug in which a function which should have been was not
// marked `const' (see gcc bug 23053).  We use this define to do some evil
// const_cast-ing in that case.
#if __GNUC__ && (__GNUC__ == 4 && __GNUC_MINOR__ == 0)
# define TR1_NOT_CONST_CORRECT
#endif
// Apple ships the broken tr1 on both 10.4 and 10.5, *despite* using gcc 4.2
// for 10.5.  Blacklist Apple as shipping broken libraries, regardless of the
// compiler version.  We should revisit this at some point.
#if defined(DETECTED_OS_APPLE) && defined(__GNUC__)
# define TR1_NOT_CONST_CORRECT
#endif

#endif /* BASICS_TR1_H */
