# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ALPINE_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(ALPINE_RELEASES),$(foreach a,x86_64 aarch64,alpine-cloud-$r.$a))

$(foreach R,$(ALPINE_RELEASES),alpine-cloud-$R.x86_64.run): alpine-cloud-%.x86_64.run: $(MAKEFILE_LIST) | alpine-cloud-%.x86_64.qcow2 alpine-cloud-%.x86_64.efi-code.img alpine-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/alpine" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(ALPINE_RELEASES),alpine-cloud-$R.aarch64.run): alpine-cloud-%.aarch64.run: $(MAKEFILE_LIST) | alpine-cloud-%.aarch64.qcow2 alpine-cloud-%.aarch64.efi-code.img alpine-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/alpine" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(ALPINE_RELEASES),alpine-cloud-$R.x86_64.qcow2): alpine-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/alpine/alpine-cloud-%.x86_64.qcow2 alpine-cloud-%.seed.iso alpine-cloud-%.x86_64.efi-code.img alpine-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(foreach R,$(ALPINE_RELEASES),alpine-cloud-$R.aarch64.qcow2): alpine-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/alpine/alpine-cloud-%.aarch64.qcow2 alpine-cloud-%.seed.iso alpine-cloud-%.aarch64.efi-code.img alpine-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/alpine: | $(GARDEN_DL_DIR)
	mkdir -p $@

alpine-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,alpine-$*)
alpine-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

alpine-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,ALPINE,$*),alpine-$*,alpine)
alpine-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@
	touch --reference=$(shell stat $^ -c '%Y %n' | sort -nr | cut -d ' ' -f 2 | head -n 1) $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(ALPINE_RELEASES),$(foreach A,x86_64 aarch64,alpine-cloud-$R.$A.qcow2 alpine-cloud-$R.$A.run))
