//go:build unix

package cli_test

import (
	"os"
	"testing"

	"golang.org/x/sys/unix"
	. "src.elv.sh/pkg/cli"
)

func TestTTYSignal(t *testing.T) {
	tty := NewTTY(os.Stdin, os.Stderr)
	sigch := tty.NotifySignals()

	err := unix.Kill(unix.Getpid(), unix.SIGUSR1)
	if err != nil {
		t.Skip("cannot send SIGUSR1 to myself:", err)
	}

	if sig := nextSig(sigch); sig != unix.SIGUSR1 {
		t.Errorf("Got signal %v, want SIGUSR1", sig)
	}

	tty.StopSignals()

	err = unix.Kill(unix.Getpid(), unix.SIGUSR2)
	if err != nil {
		t.Skip("cannot send SIGUSR2 to myself:", err)
	}

	if sig := nextSig(sigch); sig != nil {
		t.Errorf("Got signal %v, want nil", sig)
	}
}

// Gets the next signal from the channel, ignoring all SIGURG generated by the
// Go runtime. See https://github.com/golang/go/issues/37942.
func nextSig(sigch <-chan os.Signal) os.Signal {
	for {
		sig := <-sigch
		if sig != unix.SIGURG {
			return sig
		}
	}
}
