/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.webservices.dns.client.impl;

import com.amazon.webservices.dns.v20110505.AliasTarget;
import com.amazon.webservices.dns.v20110505.Change;
import com.amazon.webservices.dns.v20110505.ChangeBatch;
import com.amazon.webservices.dns.v20110505.ChangeResourceRecordSetsRequest;
import com.amazon.webservices.dns.v20110505.Changes;
import com.amazon.webservices.dns.v20110505.CreateHostedZoneRequest;
import com.amazon.webservices.dns.v20110505.HostedZoneConfig;
import com.amazon.webservices.dns.v20110505.ResourceRecord;
import com.amazon.webservices.dns.v20110505.ResourceRecordSet;
import com.amazon.webservices.dns.v20110505.ResourceRecords;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route53Serializer {
    private final String xmlns;

    public Route53Serializer(String xmlns) {
        this.xmlns = xmlns;
    }

    public String serialize(ChangeResourceRecordSetsRequest request) {
        return "<ChangeResourceRecordSetsRequest xmlns=\"" + this.xmlns + "\">" + this.serialize(request.getChangeBatch()) + "</ChangeResourceRecordSetsRequest>";
    }

    private String serialize(ChangeBatch changeBatch) {
        if (changeBatch == null) {
            return "";
        }
        return "<ChangeBatch>" + this.serialize("Comment", changeBatch.getComment()) + this.serialize(changeBatch.getChanges()) + "</ChangeBatch>";
    }

    private String serialize(Changes changes) {
        if (changes == null) {
            return "";
        }
        return this.serialize(changes.getChange());
    }

    private String serialize(String field, String value) {
        if (value == null) {
            return "";
        }
        return "<" + field + ">" + value + "</" + field + ">";
    }

    private String serialize(String field, long value) {
        return "<" + field + ">" + value + "</" + field + ">";
    }

    private String serialize(List<Change> changes) {
        if (changes == null) {
            return "";
        }
        String xml = "<Changes>";
        for (Change change : changes) {
            xml = xml + this.serialize(change);
        }
        return xml + "</Changes>";
    }

    private String serialize(Change change) {
        if (change == null) {
            return "";
        }
        return "<Change>" + this.serialize("Action", change.getAction().toString()) + this.serialize(change.getResourceRecordSet()) + "</Change>";
    }

    private String serialize(AliasTarget aliasTarget) {
        if (aliasTarget == null) {
            return "";
        }
        return "<AliasTarget>" + this.serialize("HostedZoneId", aliasTarget.getHostedZoneId()) + this.serialize("DNSName", aliasTarget.getDNSName()) + "</AliasTarget>";
    }

    private String serialize(ResourceRecordSet resourceRecordSet) {
        if (resourceRecordSet == null) {
            return "";
        }
        String output = "<ResourceRecordSet>" + this.serialize("Name", resourceRecordSet.getName()) + this.serialize("Type", resourceRecordSet.getType().toString());
        output = output + this.serialize("SetIdentifier", resourceRecordSet.getSetIdentifier());
        if (resourceRecordSet.getWeight() != null) {
            output = output + this.serialize("Weight", resourceRecordSet.getWeight());
        }
        if (resourceRecordSet.getTTL() != null) {
            output = output + this.serialize("TTL", resourceRecordSet.getTTL());
        }
        output = output + this.serialize(resourceRecordSet.getAliasTarget());
        output = output + this.serializeResourceRecord(resourceRecordSet.getResourceRecords());
        output = output + "</ResourceRecordSet>";
        return output;
    }

    private String serializeResourceRecord(ResourceRecords resourceRecords) {
        if (resourceRecords == null) {
            return "";
        }
        return this.serializeResourceRecord(resourceRecords.getResourceRecord());
    }

    private String serializeResourceRecord(List<ResourceRecord> resourceRecords) {
        if (resourceRecords == null) {
            return "";
        }
        String xml = "<ResourceRecords>";
        for (ResourceRecord record : resourceRecords) {
            xml = xml + this.serialize(record);
        }
        return xml + "</ResourceRecords>";
    }

    private String serialize(ResourceRecord record) {
        if (record == null) {
            return "";
        }
        return "<ResourceRecord>" + this.serialize("Value", record.getValue()) + "</ResourceRecord>";
    }

    public String serialize(CreateHostedZoneRequest request) {
        if (request == null) {
            return "";
        }
        return "<CreateHostedZoneRequest xmlns=\"" + this.xmlns + "\">" + this.serialize("Name", request.getName()) + this.serialize("CallerReference", request.getCallerReference()) + this.serialize(request.getHostedZoneConfig()) + "</CreateHostedZoneRequest>";
    }

    private String serialize(HostedZoneConfig hostedZoneConfig) {
        if (hostedZoneConfig == null) {
            return "";
        }
        return "<HostedZoneConfig>" + this.serialize("Comment", hostedZoneConfig.getComment()) + "</HostedZoneConfig>";
    }
}

