(define-library (srfi 132 test)
  (import (scheme base) (srfi 132) (chibi test))
  (export run-tests)
  (begin
    (define (run-tests)
      (test-begin "srfi-132: sorting")
      (test '()
          (list-sort > (list)))
      (test '(987)
          (list-sort > (list 987)))
      (test '(987 654)
          (list-sort > (list 987 654)))
      (test '(9 8 7 6 5 4 3 2 1 0)
          (list-sort > (list 9 8 6 3 0 4 2 5 7 1)))
      (test '()
          (list-stable-sort > (list)))
      (test '(987)
          (list-stable-sort > (list 987)))
      (test '(987 654)
          (list-stable-sort > (list 987 654)))
      (test '(9 8 7 6 5 4 3 2 1 0)
          (list-stable-sort > (list 9 8 6 3 0 4 2 5 7 1)))
      (test '(9 8 6 7 4 5 3 2 0 1)
          (list-stable-sort (lambda (x y)
                              (> (quotient x 2)
                                 (quotient y 2)))
                            (list 9 8 6 3 0 4 2 5 7 1)))
      (test '#()
          (let ((v (vector)))
            (vector-sort > v)))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-sort > (vector 987))))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-sort > v)))
      (test '#(9 8 7 6 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-sort > v)))
      (test '#()
          (let ((v (vector)))
            (vector-stable-sort > v)))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-stable-sort > (vector 987))))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-stable-sort > v)))
      (test '#(9 8 7 6 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort > v)))
      (test '#(9 8 6 7 4 5 3 2 0 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort (lambda (x y)
                                  (> (quotient x 2)
                                     (quotient y 2)))
                                v)))
      (test '#()
          (let ((v (vector)))
            (vector-sort > v 0)))
      (test '#()
          (let ((v (vector 987)))
            (vector-sort > (vector 987) 1)))
      (test '#(654)
          (let ((v (vector 987 654)))
            (vector-sort > v 1)))
      (test '#(7 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-sort > v 3)))
      (test '#()
          (let ((v (vector)))
            (vector-stable-sort > v 0)))
      (test '#()
          (let ((v (vector 987)))
            (vector-stable-sort > (vector 987) 1)))
      (test '#(654 987)
          (let ((v (vector 987 654)))
            (vector-stable-sort < v 0 2)))
      (test '#(7 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort > v 3)))
      (test '#(7 4 5 3 2 0 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort (lambda (x y)
                                  (> (quotient x 2)
                                     (quotient y 2)))
                                v
                                3)))
      (test '#()
          (let ((v (vector)))
            (vector-sort > v 0 0)))
      (test '#()
          (let ((v (vector 987)))
            (vector-sort > (vector 987) 1 1)))
      (test '#(654)
          (let ((v (vector 987 654)))
            (vector-sort > v 1 2)))
      (test '#(5 4 2 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-sort > v 4 8)))
      (test '#()
          (let ((v (vector)))
            (vector-stable-sort > v 0 0)))
      (test '#()
          (let ((v (vector 987)))
            (vector-stable-sort > (vector 987) 1 1)))
      (test '#(654)
          (let ((v (vector 987 654)))
            (vector-stable-sort > v 1 2)))
      (test '#(6 4 3 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort > v 2 6)))
      (test '#(8 6 4 5 3 2 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort (lambda (x y)
                                  (> (quotient x 2)
                                     (quotient y 2)))
                                v
                                1
                                8)))
      (test '()
          (list-sort! > (list)))
      (test '(987)
          (list-sort! > (list 987)))
      (test '(987 654)
          (list-sort! > (list 987 654)))
      (test '(9 8 7 6 5 4 3 2 1 0)
          (list-sort! > (list 9 8 6 3 0 4 2 5 7 1)))
      (test '()
          (list-stable-sort! > (list)))
      (test '(987)
          (list-stable-sort! > (list 987)))
      (test '(987 654)
          (list-stable-sort! > (list 987 654)))
      (test '(9 8 7 6 5 4 3 2 1 0)
          (list-stable-sort! > (list 9 8 6 3 0 4 2 5 7 1)))
      (test '(9 8 6 7 4 5 3 2 0 1)
          (list-stable-sort! (lambda (x y)
                               (> (quotient x 2)
                                  (quotient y 2)))
                             (list 9 8 6 3 0 4 2 5 7 1)))
      (test '#()
          (let ((v (vector)))
            (vector-sort! > v)
            v))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-sort! > (vector 987))
            v))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-sort! > v)
            v))
      (test '#(9 8 7 6 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-sort! > v)
            v))
      (test '#()
          (let ((v (vector)))
            (vector-stable-sort! > v)
            v))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-stable-sort! > (vector 987))
            v))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-stable-sort! > v)
            v))
      (test '#(9 8 7 6 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort! > v)
            v))
      (test '#(9 8 6 7 4 5 3 2 0 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort! (lambda (x y)
                                   (> (quotient x 2)
                                      (quotient y 2)))
                                 v)
            v))
      (test '#()
          (let ((v (vector)))
            (vector-sort! > v 0)
            v))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-sort! > (vector 987) 1)
            v))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-sort! > v 1)
            v))
      (test '#(9 8 6 7 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-sort! > v 3)
            v))
      (test '#()
          (let ((v (vector)))
            (vector-stable-sort! > v 0)
            v))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-stable-sort! > (vector 987) 1)
            v))
      (test '#(654 987)
          (let ((v (vector 987 654)))
            (vector-stable-sort! < v 0 2)
            v))
      (test '#(9 8 6 7 5 4 3 2 1 0)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort! > v 3)
            v))
      (test '#(9 8 6 7 4 5 3 2 0 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort! (lambda (x y)
                                   (> (quotient x 2)
                                      (quotient y 2)))
                                 v
                                 3)
            v))
      (test '#()
          (let ((v (vector)))
            (vector-sort! > v 0 0)
            v))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-sort! > (vector 987) 1 1)
            v))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-sort! > v 1 2)
            v))
      (test '#(9 8 6 3 5 4 2 0 7 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-sort! > v 4 8)
            v))
      (test '#()
          (let ((v (vector)))
            (vector-stable-sort! > v 0 0)
            v))
      (test '#(987)
          (let ((v (vector 987)))
            (vector-stable-sort! > (vector 987) 1 1)
            v))
      (test '#(987 654)
          (let ((v (vector 987 654)))
            (vector-stable-sort! > v 1 2)
            v))
      (test '#(9 8 6 4 3 0 2 5 7 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort! > v 2 6)
            v))
      (test '#(9 8 6 4 5 3 2 0 7 1)
          (let ((v (vector 9 8 6 3 0 4 2 5 7 1)))
            (vector-stable-sort! (lambda (x y)
                                   (> (quotient x 2)
                                      (quotient y 2)))
                                 v
                                 1
                                 8)
            v))
      (test (list-merge > (list) (list))
          '())
      (test '(9 6 3 0)
          (list-merge > (list) (list 9 6 3 0)))
      (test '(9 7 5 3 1)
          (list-merge > (list 9 7 5 3 1) (list)))
      (test '(9 9 7 6 5 3 3 1 0)
          (list-merge > (list 9 7 5 3 1) (list 9 6 3 0)))
      (test '()
          (list-merge! > (list) (list)))
      (test '(9 6 3 0)
          (list-merge! > (list) (list 9 6 3 0)))
      (test '(9 7 5 3 1)
          (list-merge! > (list 9 7 5 3 1) (list)))
      (test '(9 9 7 6 5 3 3 1 0)
          (list-merge! > (list 9 7 5 3 1) (list 9 6 3 0)))
      (test '#()
          (vector-merge > (vector) (vector)))
      (test '#(9 6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0)))
      (test '#(9 7 5 3 1)
          (vector-merge > (vector 9 7 5 3 1) (vector)))
      (test '#(9 9 7 6 5 3 3 1 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0)))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector))
            v))
      (test '#( 9  6  3  0 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0))
            v))
      (test '#( 9  7  5  3  1 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector))
            v))
      (test '#( 9  9  7  6  5  3  3  1  0 #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0))
            v))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 0)
            v))
      (test '#( 9  6  3  0 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 0)
            v))
      (test '#( 9  7  5  3  1 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 0)
            v))
      (test '#( 9  9  7  6  5  3  3  1  0 #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 0)
            v))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2)
            v))
      (test '#(#f #f 9  6  3  0 #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2)
            v))
      (test '#(#f #f  9  7  5  3  1 #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2)
            v))
      (test '#(#f #f 9  9  7  6  5  3  3  1  0 #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0))
      (test '#(9 6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0) 0))
      (test '#(5 3 1)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2))
      (test '#(9 6 5 3 3 1 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0)
            v))
      (test '#(#f #f 9  6  3  0 #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0)
            v))
      (test '#(#f #f 5  3  1 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2)
            v))
      (test '#(#f #f  9   6  5  3  3  1  0 #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0 0))
      (test '#(9 6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0) 0 0))
      (test '#(5 3 1)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2 5))
      (test '#(9 6 5 3 3 1 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2 5))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0 0)
            v))
      (test '#(#f #f 9  6  3  0 #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0 0)
            v))
      (test '#(#f #f 5  3  1 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2 5)
            v))
      (test '#(#f #f  9  6  5  3  3  1  0 #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2 5)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0 0))
      (test '#(9 6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0) 0 0))
      (test '#(5 3)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2 4))
      (test '#(9 6 5 3 3 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2 4))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0 0)
            v))
      (test '#(#f #f 9  6  3  0 #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0 0)
            v))
      (test '#(#f #f 5  3 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2 4)
            v))
      (test '#(#f #f  9  6  5  3  3  0 #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2 4)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0 0 0))
      (test '#(9 6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0) 0 0 0))
      (test '#(5 3)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2 4 0))
      (test '#(9 6 5 3 3 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2 4 0))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0 0 0)
            v))
      (test '#(#f #f  9  6  3  0 #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0 0 0)
            v))
      (test '#(#f #f  5  3 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2 4 0)
            v))
      (test '#(#f #f  9  6  5  3  3  0 #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2 4 0)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0 0 0))
      (test '#(6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0) 0 0 1))
      (test '#(5 3)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2 4 0))
      (test '#(6 5 3 3 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2 4 1))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0 0 0)
            v))
      (test '#(#f #f  6  3  0 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0 0 1)
            v))
      (test '#(#f #f  5  3 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2 4 0)
            v))
      (test '#(#f #f  6  5  3  3  0 #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2 4 1)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0 0 0 0))
      (test '#(6 3 0)
          (vector-merge > (vector) (vector 9 6 3 0) 0 0 1 4))
      (test '#(5 3)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2 4 0 0))
      (test '#(6 5 3 3 0)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2 4 1 4))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0 0 0 0)
            v))
      (test '#(#f #f  6  3  0 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0 0 1 4)
            v))
      (test '#(#f #f  5  3 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2 4 0 0)
            v))
      (test '#(#f #f  6  5  3  3  0 #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2 4 1 4)
            v))
      (test '#()
          (vector-merge > (vector) (vector) 0 0 0 0))
      (test '#(6)
          (vector-merge > (vector) (vector 9 6 3 0) 0 0 1 2))
      (test '#(5 3)
          (vector-merge > (vector 9 7 5 3 1) (vector) 2 4 0 0))
      (test '#(6 5 3)
          (vector-merge > (vector 9 7 5 3 1) (vector 9 6 3 0) 2 4 1 2))
      (test '#(#f #f #f #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector) 2 0 0 0 0)
            v))
      (test '#(#f #f  6 #f #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector) (vector 9 6 3 0) 2 0 0 1 2)
            v))
      (test '#(#f #f  5  3 #f #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector) 2 2 4 0 0)
            v))
      (test '#(#f #f  6  5  3 #f #f #f #f #f #f #f)
          (let ((v (make-vector 12 #f)))
            (vector-merge! > v (vector 9 7 5 3 1) (vector 9 6 3 0) 2 2 4 1 2)
            v))
      (test '()
          (list-delete-neighbor-dups char=? (list)))
      (test '(#\a)
          (list-delete-neighbor-dups char=? (list #\a)))
      (test '(#\a #\b #\a)
          (list-delete-neighbor-dups char=? (list #\a #\a #\a #\b #\b #\a)))
      (test '()
          (list-delete-neighbor-dups! char=? (list)))
      (test '(#\a)
          (list-delete-neighbor-dups! char=? (list #\a)))
      (test '(#\a #\b #\a)
          (list-delete-neighbor-dups! char=? (list #\a #\a #\a #\b #\b #\a)))
      (test '#()
          (let ((v (vector)))
            (vector-delete-neighbor-dups char=? v)))
      (test '#(#\a)
          (let ((v (vector #\a)))
            (vector-delete-neighbor-dups char=? v)))
      (test '#(#\a #\b #\a)
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (vector-delete-neighbor-dups char=? v)))
      (test '(0 #())
          (let ((v (vector)))
            (list (vector-delete-neighbor-dups! char=? v) v)))
      (test '(1 #(#\a))
          (let ((v (vector #\a)))
            (list (vector-delete-neighbor-dups! char=? v) v)))
      (test '(3 #(#\a #\b #\a #\b #\b #\a))
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (list (vector-delete-neighbor-dups! char=? v) v)))
      (test '#()
          (let ((v (vector)))
            (vector-delete-neighbor-dups char=? v 0)))
      (test '#(#\a)
          (let ((v (vector #\a)))
            (vector-delete-neighbor-dups char=? v 0)))
      (test '#(#\a #\b #\a)
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (vector-delete-neighbor-dups char=? v 0)))
      (test '(0 #())
          (let ((v (vector)))
            (list (vector-delete-neighbor-dups! char=? v 0) v)))
      (test '(1 #(#\a))
          (let ((v (vector #\a)))
            (list (vector-delete-neighbor-dups! char=? v 0) v)))
      (test '(3 #(#\a #\b #\a #\b #\b #\a))
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (list (vector-delete-neighbor-dups! char=? v 0) v)))
      (test '#()
          (let ((v (vector)))
            (vector-delete-neighbor-dups char=? v 0)))
      (test '#()
          (let ((v (vector #\a)))
            (vector-delete-neighbor-dups char=? v 1)))
      (test '#(#\b #\a)
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (vector-delete-neighbor-dups char=? v 3)))
      (test '(0 #())
          (let ((v (vector)))
            (list (vector-delete-neighbor-dups! char=? v 0) v)))
      (test '(1 #(#\a))
          (let ((v (vector #\a)))
            (list (vector-delete-neighbor-dups! char=? v 1) v)))
      (test '(5 #(#\a #\a #\a #\b #\a #\a))
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (list (vector-delete-neighbor-dups! char=? v 3) v)))
      (test '#()
          (let ((v (vector)))
            (vector-delete-neighbor-dups char=? v 0 0)))
      (test '#()
          (let ((v (vector #\a)))
            (vector-delete-neighbor-dups char=? v 1 1)))
      (test '#(#\b)
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (vector-delete-neighbor-dups char=? v 3 5)))
      (test '(0 #())
          (let ((v (vector)))
            (list (vector-delete-neighbor-dups! char=? v 0 0) v)))
      (test '(1 #(#\a))
          (let ((v (vector #\a)))
            (list (vector-delete-neighbor-dups! char=? v 0 1) v)))
      (test '(1 #(#\a))
          (let ((v (vector #\a)))
            (list (vector-delete-neighbor-dups! char=? v 1 1) v)))
      (test '(4 #(#\a #\a #\a #\b #\b #\a))
          (let ((v (vector #\a #\a #\a #\b #\b #\a)))
            (list (vector-delete-neighbor-dups! char=? v 3 5) v)))
      (let ((v (vector 0 0 0 1 1 2 2 3 3 4 4 5 5 6 6)))
        (test '(9 . #(0 0 0 1 2 3 4 5 6 4 4 5 5 6 6))
            (cons (vector-delete-neighbor-dups! = v 3) v)))
      (test "knil" (vector-find-median < (vector) "knil"))
      (test 17 (vector-find-median < (vector 17) "knil"))
      (test 12 (vector-find-median < (vector 18 1 12 14 12 5 18 2) "knil"))
      (test 23/2 (vector-find-median < (vector 18 1 11 14 12 5 18 2) "knil"))
      (test (list 12 12)
          (vector-find-median < (vector 18 1 12 14 12 5 18 2) "knil" list))
      (test (list 11 12)
          (vector-find-median < (vector 18 1 11 14 12 5 18 2) "knil" list))
      (test 7 (vector-find-median < (vector 7 6 9 3 1 18 15 7 8) "knil"))
      (test 7 (vector-find-median < (vector 7 6 9 3 1 18 15 7 8) "knil" list))
      (test 19
          (let ((v (vector 19)))
            (vector-select! < v 0)))
      (test 3
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 0)))
      (test 9
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 2)))
      (test 22
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 8)))
      (test 23
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 9)))
      (test 19
          (let ((v (vector 19)))
            (vector-select! < v 0 0)))
      (test 3
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 0 0)))
      (test 9
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 2 0)))
      (test 22
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 8 0)))
      (test 23
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 9 0)))
      (test 19
          (let ((v (vector 19)))
            (vector-select! < v 0 0 1)))
      (test 3
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 0 0 10)))
      (test 9
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 2 0 10)))
      (test 22
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 8 0 10)))
      (test 23
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 9 0 10)))
      (test 3
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 0 4 10)))
      (test 13
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 2 4 10)))
      (test 21
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 4 4 10)))
      (test 23
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 5 4 10)))
      (test 3
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 0 4 10)))
      (test 13
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 2 4 10)))
      (test 13
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 3 4 10)))
      (test 21
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 4 4 10)))
      (test 23
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 5 4 10)))
      (test 9
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 0 4 8)))
      (test 13
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 1 4 8)))
      (test 13
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 2 4 8)))
      (test 21
          (let ((v (vector 8 22 19 19 13 9 21 13 3 23)))
            (vector-select! < v 3 4 8)))
      (test-end))))
