#! /usr/bin/python
# -*- coding: UTF-8 -*-

"""
Copyright (C) 2005-07 Adolfo González Blázquez <code@infinicode.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details. 

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

If you find any bugs or have any suggestions email: code@infinicode.org
"""

import pygtk
pygtk.require("2.0")
import gtk

import os
import camglobals

home = os.getenv("HOME")
pidfile = '.cameramonitor.pid'
path = os.path.join(home, pidfile)


# Check if another instance is running
def pid_check():
    if os.path.isfile(path):
        try:
            fd = open(path, 'r')
            pid = fd.read()
            fd.close()
        except IOError:
            display_dialog_error("Error reading pidfile!")
            
        if pid_running(pid):
            display_dialog_error("Another instance of Camera Monitor is already running!")
            return True
        else:
			#display_dialog_warning("Camera Monitor didn't exit properly last time!")
			os.remove(path)
			return False

    else: return False
        
# Check if the process with pid is running
def pid_running(pid):
	return os.path.isdir('/proc/'+pid)
        
# Saves the pidfile
def pid_save():
    pid = os.getpid()
    if os.path.isfile(path):
        display_dialog_error("Another instance of Camera Monitor is already running")
    else:
        try:
            fd = open(path, "w")
            fd.write(`pid`)
            fd.close()
        except IOError:
            display_dialog_error("Error writing pidfile!")

# Saves the pidfile
def pid_read():
    if not os.path.isfile(path):
        return "0"
    else:
        try:
            fd = open(path, "r")
            pid = fd.read()
            fd.close()
        except IOError:
            display_dialog_error("Error reading pidfile!")
        return pid
            

# Cleans pidfile on exit            
def pid_clean():
    if os.path.isfile(path):
        os.remove(path)
    else:
        #display_dialog_error("Pidfile doesn't exit!")
        pass
            
# Display a dialog error
def display_dialog_error(text):
    dialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, text)
    dialog.run()
    dialog.destroy()

# Display a dialog warning
def display_dialog_warning(text):
    dialog = gtk.MessageDialog(None, 0, gtk.MESSAGE_WARNING, gtk.BUTTONS_OK, text)
    dialog.run()
    dialog.destroy()
