dnl Makeup aclocal macros.
dnl
dnl Copyright 2003 - 2015, Ron <ron@debian.org>
dnl
dnl These macros are distributed under the terms of the GNU GPL version 2.
dnl
dnl As a special exception to the GPL, it may be distributed without
dnl modification as a part of a program using a makeup generated build
dnl system, under the same distribution terms as the program itself.
dnl Modified versions are not obliged to also offer this exception,
dnl though if you wish not to do so then you should remove this paragraph
dnl and make it clear that your modifications are licenced strictly
dnl according to the GPL 2 or a compatible licence.


#~ SHUT_THE_FUP(AC_MACRO)
#
# Stealth mode for AC_ macros.  Exploits implementation so it's
# potentially fragile, but almost all failure modes do not
# affect the functional output, and those that do should be
# immediately obvious if they occur :)  Use it to wrap a macro
# that would output something you don't want on the console.
# Do NOT quote them.  Will honour all other nasty hack's disclaimers
# upon presentation.
# -------------------------------------------------------------------

AC_DEFUN([SHUT_THE_FUP],
[
exec 6>/dev/null
$@dnl
exec 6>&1
])
#~


#~ ACM_REQUIRE_LN_S
#
# This macro should be AC_REQUIRE'd by any macro that
# may need $LN_S to be defined before it is expanded.
# ---------------------------------------------------

AC_DEFUN([ACM_REQUIRE_LN_S],
[
if test -z "$LN_S"; then
    SHUT_THE_FUP(AC_PROG_LN_S)
fi
])
#~


#~ FIND_AND_LINK_IF_LOCAL([FILE][,DEST][,SOURCE_DIRS])
#
# If FILE does not exist in dir DEST look for it in the immediate
# parent directories and if found create a symlink to it.  Else
# try to find it in a space separated list of SOURCE_DIRS (which
# default to a list of standard system locations) and then copy it.
# If DEST is not supplied explicitly, it will default to $srcdir,
# if DEST is supplied and does not exist, it will be created too.
# DEST is assumed to always be relative to $srcdir.
# ---------------------------------------------------------------

AC_DEFUN([FIND_AND_LINK_IF_LOCAL],
[
AC_REQUIRE([ACM_REQUIRE_LN_S])

if test -n "[$2]"; then
    _filedest=$srcdir/[$2]
    mkdir -p $_filedest
else
    _filedest=$srcdir
fi
if test -n "[$3]"; then
    _filesources="[$3]"
else
    _filesources="/usr/share/misc /usr/share/automake* /usr/share/libtool"
fi
if test ! -e "$_filedest/[$1]" ; then
    AC_MSG_CHECKING([for $_filedest/[$1]])

    ( cd $_filedest
        for d in ".." "../.." ; do
            if test -r "$d/[$1]" ; then
                AC_MSG_RESULT([linking from $d/[$1].])
                $LN_S "$d/[$1]" .
                break
            fi
        done
    )

    if test ! -e "$_filedest/[$1]" ; then
        for d in $_filesources;
	do
            if test -r "$d/[$1]" ; then
                AC_MSG_RESULT([copying from $d/[$1].])
                cp -a "$d/[$1]" "$_filedest/[$1]"
                break
            fi
        done
    fi

    if test ! -e "$_filedest/[$1]" ; then
        AC_MSG_ERROR([Failed to locate [$1].  Stopping.])
    fi
fi
])
#~


#~ FIND_AND_COPY_UNLESS_LOCAL([FILE][,DEST])
#
# If FILE does not exist in dir DEST look for it in the immediate
# parent directories and if found do nothing.  Else try to find
# it in a standard system location and then copy it over.
# Note that we dereference symlinks here, which is probably what
# you want if you're using this macro..  maybe.
# If DEST is not supplied explicitly, it will default to $srcdir,
# if DEST is supplied and does not exist, it will be created too.
# ---------------------------------------------------------------

AC_DEFUN([FIND_AND_COPY_UNLESS_LOCAL],
[
if test -n "[$2]"; then
    _filedest=[$2]
    mkdir -p $_filedest
else
    _filedest=$srcdir
fi
if test ! -e "$_filedest/[$1]" ; then
    AC_MSG_CHECKING([for $_filedest/[$1]])

    if (
        if (
            cd $_filedest
            for d in ".." "../.." ; do
                if test -r "$d/[$1]" ; then
                    AC_MSG_RESULT([leeching from $d/[$1].])
                    exit 1
                fi
            done
           ) ;
        then
            for d in "/usr/share/misc" "/usr/share/automake" "/usr/share/libtool" \
	    	     "/usr/share/automake-1.6" "/usr/share/automake-1.7" 	  ; do
                if test -r "$d/[$1]" ; then
                    cp -aL "$d/[$1]" "$_filedest/[$1]"
                    AC_MSG_RESULT([copying from $d/[$1].])
                    exit 1
                fi
            done
        else
            exit 1
        fi
       ) ;
    then
        AC_MSG_ERROR([Failed to locate [$1].  Stopping.])
    fi
fi
])
#~


#~ ACM_CONFIG_MAKEFILE(MAKEUP_GMAKE_DIR,[GLOBAL_VARIABLES])
#
# This macro instantiates a forwarding Makefile in the build directory
# and its corresponding Makefile.acsubst.  It is also used to define
# global variables that need to be available in config.status.
# --------------------------------------------------------------------

AC_DEFUN([ACM_CONFIG_MAKEFILE],
[
dnl This 'before' is not strictly required, but since this macro
dnl will usually define globals needed before ACM_CONFIG_HEADER
dnl then it seems like a reasonable sanity check.  Feel free to
dnl remove or work around it if it is causing real problems.
AC_BEFORE([$0],[ACM_CONFIG_HEADER])

m4_if([$#],0,[AC_MSG_ERROR([[ACM_CONFIG_MAKEFILE] must have at least one parameter])])

AC_CONFIG_COMMANDS([Makefile],
                   [
                    cat > Makefile <<EOF
# Makeup ACM_CONFIG_MAKEFILE generated luser makefile.
#
#  Copyright 2003 - 2007, Ron <ron@debian.org>
#
# This file is distributed under the terms of the GNU GPL version 2.
#
# As a special exception to the GPL, it may be distributed without
# modification as a part of a program using a makeup generated build
# system, under the same distribution terms as the program itself.
# Modified versions are not obliged to also offer this exception,
# though if you wish not to do so then you should remove this paragraph
# and make it clear that your modifications are licenced strictly
# according to the GPL 2 or a compatible licence.

include Makefile.acsubst
include \$(MAKEUP_TOP_CONFIG)

ifneq (\$(strip \$(MAKEUP_VERBOSE)),)
  include \$(MAKEUP_GMAKE_DIR)/makefile.makeup
else
 -include \$(MAKEUP_GMAKE_DIR)/makefile.makeup
endif

EOF
                   ],[
                    [$2]
                   ])
AC_CONFIG_FILES([Makefile.acsubst:$1/makefile.acsubst])
])
#~


#~ ACM_DEFINE_PUBLIC(VARIABLE,[VALUE],[DESCRIPTION])
#
# Causes VARIABLE to be defined in a public config header, such as:
#
# /* DESCRIPTION */
# #ifndef VARIABLE
# #define VARIABLE VALUE
# #endif
#
# If VALUE is unspecified then VARIABLE will be defined to be empty.
# This macro should be used in conjunction with ACM_CONFIG_HEADER
# which defines the name of the config headers in which to output
# variables defined with this macro.
# ------------------------------------------------------------------

AC_DEFUN([ACM_DEFINE_PUBLIC],
[
AC_BEFORE([$0],[ACM_CONFIG_HEADER])

m4_if(m4_bregexp([$1],[^[A-Za-z_]+[A-Za-z0-9_]+$]),-1,
[AC_MSG_ERROR([Bad variable name '[$1]' supplied to [ACM_DEFINE_PUBLIC]])])

acm_public_macros="$acm_public_macros [$1]"
if test -z "$acm_public_macros_def"; then
    acm_public_macros_def="acm_public_macro_[$1]=\"[$2]\"; acm_public_macro_desc_[$1]=\"[$3]\""
else
    acm_public_macros_def="$acm_public_macros_def; acm_public_macro_[$1]=\"[$2]\"; acm_public_macro_desc_[$1]=\"[$3]\""
fi
])
#~


#~ ACM_DEFINE_PUBLIC_STRING(VARIABLE,[VALUE],[DESCRIPTION])
#
# Causes VARIABLE to be defined as a literal string
# in a public config header, such as:
#
# /* DESCRIPTION */
# #ifndef VARIABLE
# #define VARIABLE "VALUE"
# #endif
#
# If VALUE is unspecified then VARIABLE will be defined to be empty.
# This macro should be used in conjunction with ACM_CONFIG_HEADER
# which defines the name of the config headers in which to output
# variables defined with this macro.
# ------------------------------------------------------------------

AC_DEFUN([ACM_DEFINE_PUBLIC_STRING],
[
AC_BEFORE([$0],[ACM_CONFIG_HEADER])

m4_if(m4_bregexp([$1],[^[A-Za-z_]+[A-Za-z0-9_]+$]),-1,
[AC_MSG_ERROR([Bad variable name '[$1]' supplied to [ACM_DEFINE_PUBLIC_STRING]])])

acm_public_strings="$acm_public_strings [$1]"
if test -z "$acm_public_strings_def"; then
    acm_public_strings_def="acm_public_string_[$1]=\"[$2]\"; acm_public_string_desc_[$1]=\"[$3]\""
else
    acm_public_strings_def="$acm_public_strings_def; acm_public_string_[$1]=\"[$2]\"; acm_public_string_desc_[$1]=\"[$3]\""
fi
])
#~


#~ ACM_CONFIG_HEADER(NAME)
#
# This is an instantiating macro that should usually be included
# shortly before AC_OUTPUT.  If will create a config file containing
# the public symbols declared by ACM_DEFINE_PUBLIC
# -----------------------------------------------------------------

AC_DEFUN([ACM_CONFIG_HEADER],
[
AC_REQUIRE([ACM_REQUIRE_LN_S])
m4_if([$#],1,[],[AC_MSG_ERROR([[ACM_CONFIG_HEADER] must have only one parameter])])

dnl is there a way to disable this at m4 time if ACM_DEFINE_PUBLIC has never been used?

AC_CONFIG_COMMANDS([include/$1],
                   [
                    _SUBDIR="$(dirname [$1])/"
                    if test "$_SUBDIR" = "./"; then
                        _SUBDIR=
                    fi
                    _TEMPFILE="include/.tempfile"

                    _GUARD="_MAKEFILE_PLATFORM_$(echo $package_name | tr "a-z .-" "A-Z___")_CONF_H"

                    cat > $_TEMPFILE <<EOF
/* Makeup ${makeup_version} generated [$1] for ${package_name} ${package_version}
 * Do not edit this file directly, your changes will be lost.
 * Copyright (C) 2003 - 2007, Ron <ron@debian.org>
 *
 * This file is distributed under the terms of the GNU GPL version 2.
 *
 * As a special exception to the GPL, it may be distributed without
 * modification as a part of a program using a makeup generated build
 * system, under the same distribution terms as the program itself.
 * Modified versions are not obliged to also offer this exception,
 * though if you wish not to do so then you should remove this paragraph
 * and make it clear that your modifications are licenced strictly
 * according to the GPL 2 or a compatible licence.
 */

#ifndef ${_GUARD}
#define ${_GUARD}

// Guard for POSIX dependent code
#if defined(__unix__) || defined(__unix) || (defined(__APPLE__) && defined(__MACH__))
    #if (EM_PLATFORM_POSIX != 1)
	#define EM_PLATFORM_POSIX 1
    #endif

    // Guard for Linux kernel dependent code
    #if defined(__linux__)
	#if linux == 1
	    #define SAVE_linux
	    #undef linux
	#elif defined(linux)
	    #warning Macro 'linux' is defined to a value other than 1
	#endif

	#if (EM_PLATFORM_LINUX != 1)
	    #define EM_PLATFORM_LINUX 1
	#endif
	#define EM_PLATFORM__ linux

    #else

	// Guard for BSD dependent code
	#include <sys/param.h>
	#if defined(BSD) || defined(__FreeBSD_kernel__)
	    #if (EM_PLATFORM_BSD != 1)
		#define EM_PLATFORM_BSD 1
	    #endif
	    #define EM_PLATFORM__ bsd
	#endif
    #endif
#endif

// Guard for billware dependent code
#if defined(_WIN32)
    #if (EM_PLATFORM_MSW != 1)
        #define EM_PLATFORM_MSW 1
    #endif
    #define EM_PLATFORM__ msw
#endif

#ifndef EM_PLATFORM__
    #error Platform unrecognised.
#endif

// Feature override macro.
//
// You may define the value of this macro to specify a configuration
// other than the system default. 'd' will attempt to use a debug
// build, 'r' a release build.  Other flavour options may be defined
// by individual packages in their own configuration.
#ifndef EM_CONFIG_FLAVOUR
#define EM_CONFIG_FLAVOUR
#endif

#define EM_CAT(a,b) EM_CAT_(a,b)
#define EM_CAT_(a,b) a ## b

#define EM_CONFIG_HEADER <${__package_config_dir}EM_CAT(EM_PLATFORM__,EM_CONFIG_FLAVOUR)_${__package_config_public}>
#include EM_CONFIG_HEADER

#ifndef _${_GUARD}
#error Config header cannot be located
#endif

#undef EM_CAT
#undef EM_CAT_
#undef EM_PLATFORM__
#undef EM_CONFIG_HEADER
#ifdef SAVE_linux
    #define linux 1
    #undef SAVE_linux
#endif


// Compiler version test.
//
// This macro will return false if the version of gcc in use
// is earlier than the specified major, minor limit, or if gcc
// is not being used.  Otherwise it will evaluate to be true.
#define EM_COMPILER_GCC( major, minor )                                 \\
    ( defined(__GNUC__) && defined(__GNUC_MINOR__)                      \\
      && ( ( __GNUC__ > (major) )                                       \\
           || ( __GNUC__ == (major) && __GNUC_MINOR__ >= (minor) ) ) )


#endif  // ${_GUARD}

EOF

                    if diff --brief include/[$1] $_TEMPFILE > /dev/null 2>&1; then
                        AC_MSG_NOTICE([[$1] is unchanged])
                        rm $_TEMPFILE
                    else
                        mv $_TEMPFILE include/[$1]
                    fi

                    echo "/* Makeup generated $_SUBDIR$config_flavour */" > $_TEMPFILE
                    echo                                                >> $_TEMPFILE
                    echo "#ifndef _${_GUARD}"                           >> $_TEMPFILE
                    echo "#define _${_GUARD}"                           >> $_TEMPFILE
                    echo                                                >> $_TEMPFILE
                    for m in $acm_public_macros; do
                        eval echo "/\* \$acm_public_macro_desc_$m \*/"  >> $_TEMPFILE
                             echo "#ifndef $m"                          >> $_TEMPFILE
                        eval echo "\#define $m \$acm_public_macro_$m"   >> $_TEMPFILE
                             echo "#endif"                              >> $_TEMPFILE
                             echo                                       >> $_TEMPFILE
                    done

                    for s in $acm_public_strings; do
                        eval echo "/\* \$acm_public_string_desc_$s \*/" >> $_TEMPFILE
                             echo "#ifndef $s"                          >> $_TEMPFILE
                        eval echo "\#define $s \\\"\$acm_public_string_$s\\\"" >> $_TEMPFILE
                             echo "#endif"                              >> $_TEMPFILE
                             echo                                       >> $_TEMPFILE
                    done
                    echo "#endif  // _${_GUARD}"                        >> $_TEMPFILE

                    if diff --brief include/$_SUBDIR$config_flavour $_TEMPFILE > /dev/null 2>&1; then
                        AC_MSG_NOTICE([$_SUBDIR$config_flavour is unchanged])
                        rm $_TEMPFILE
                    else
                        mv $_TEMPFILE include/$_SUBDIR$config_flavour
                    fi

                    ( cd include/$_SUBDIR
                      if test ! -e $config_platform; then
                        $LN_S $config_flavour $config_platform
                      fi
                    )
                   ],[
                    acm_public_macros="$acm_public_macros"
                    $acm_public_macros_def
                    acm_public_strings="$acm_public_strings"
                    $acm_public_strings_def
                    LN_S="$LN_S"
                    config_platform="$MAKEUP_PLATFORM_HEADER"
                    config_flavour="$MAKEUP_FLAVOUR_HEADER"
                   ])
])
#~

