;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: wasm-opt %s --optimize-instructions --ignore-implicit-traps --enable-reference-types --enable-gc -S -o - \
;; RUN:   | filecheck %s
;; RUN: wasm-opt %s --optimize-instructions --ignore-implicit-traps --enable-reference-types --enable-gc --nominal -S -o - \
;; RUN:   | filecheck %s --check-prefix NOMNL
;; Also test trapsNeverHappen (with nominal; no need for both type system modes).
;; RUN: wasm-opt %s --optimize-instructions --traps-never-happen --enable-reference-types --enable-gc --nominal -S -o - \
;; RUN:   | filecheck %s --check-prefix NOMNL-TNH

(module
  ;; CHECK:      (type $parent (struct (field i32)))
  ;; NOMNL:      (type $parent (struct_subtype (field i32) data))
  ;; NOMNL-TNH:      (type $parent (struct_subtype (field i32) data))
  (type $parent (struct (field i32)))
  ;; CHECK:      (type $child (struct (field i32) (field f64)))
  ;; NOMNL:      (type $child (struct_subtype (field i32) (field f64) $parent))
  ;; NOMNL-TNH:      (type $child (struct_subtype (field i32) (field f64) $parent))
  (type $child (struct_subtype (field i32) (field f64) $parent))
  ;; CHECK:      (type $other (struct (field i64) (field f32)))
  ;; NOMNL:      (type $other (struct_subtype (field i64) (field f32) data))
  ;; NOMNL-TNH:      (type $other (struct_subtype (field i64) (field f32) data))
  (type $other  (struct (field i64) (field f32)))

  ;; CHECK:      (func $foo
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $foo (type $none_=>_none)
  ;; NOMNL-NEXT:  (nop)
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $foo (type $none_=>_none)
  ;; NOMNL-TNH-NEXT:  (nop)
  ;; NOMNL-TNH-NEXT: )
  (func $foo)


  ;; CHECK:      (func $ref-cast-iit (param $parent (ref $parent)) (param $child (ref $child)) (param $other (ref $other)) (param $parent-rtt (rtt $parent)) (param $child-rtt (rtt $child)) (param $other-rtt (rtt $other))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref $parent))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $parent-rtt)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $parent)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref $child))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $parent-rtt)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.get $child)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast
  ;; CHECK-NEXT:    (local.get $parent)
  ;; CHECK-NEXT:    (local.get $child-rtt)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref $other))
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $child)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $other-rtt)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $ref-cast-iit (type $ref|$parent|_ref|$child|_ref|$other|_rtt_$parent_rtt_$child_rtt_$other_=>_none) (param $parent (ref $parent)) (param $child (ref $child)) (param $other (ref $other)) (param $parent-rtt (rtt $parent)) (param $child-rtt (rtt $child)) (param $other-rtt (rtt $other))
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (block (result (ref $parent))
  ;; NOMNL-NEXT:    (drop
  ;; NOMNL-NEXT:     (local.get $parent-rtt)
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (local.get $parent)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (block (result (ref $child))
  ;; NOMNL-NEXT:    (drop
  ;; NOMNL-NEXT:     (local.get $parent-rtt)
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (local.get $child)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.cast
  ;; NOMNL-NEXT:    (local.get $parent)
  ;; NOMNL-NEXT:    (local.get $child-rtt)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (block (result (ref $other))
  ;; NOMNL-NEXT:    (drop
  ;; NOMNL-NEXT:     (local.get $child)
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (drop
  ;; NOMNL-NEXT:     (local.get $other-rtt)
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (unreachable)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $ref-cast-iit (type $ref|$parent|_ref|$child|_ref|$other|_rtt_$parent_rtt_$child_rtt_$other_=>_none) (param $parent (ref $parent)) (param $child (ref $child)) (param $other (ref $other)) (param $parent-rtt (rtt $parent)) (param $child-rtt (rtt $child)) (param $other-rtt (rtt $other))
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (block (result (ref $parent))
  ;; NOMNL-TNH-NEXT:    (drop
  ;; NOMNL-TNH-NEXT:     (local.get $parent-rtt)
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (local.get $parent)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (block (result (ref $child))
  ;; NOMNL-TNH-NEXT:    (drop
  ;; NOMNL-TNH-NEXT:     (local.get $parent-rtt)
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (local.get $child)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (ref.cast
  ;; NOMNL-TNH-NEXT:    (local.get $parent)
  ;; NOMNL-TNH-NEXT:    (local.get $child-rtt)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (block (result (ref $other))
  ;; NOMNL-TNH-NEXT:    (drop
  ;; NOMNL-TNH-NEXT:     (local.get $child)
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (drop
  ;; NOMNL-TNH-NEXT:     (local.get $other-rtt)
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (unreachable)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $ref-cast-iit
    (param $parent (ref $parent))
    (param $child (ref $child))
    (param $other (ref $other))

    (param $parent-rtt (rtt $parent))
    (param $child-rtt (rtt $child))
    (param $other-rtt (rtt $other))

    ;; a cast of parent to an rtt of parent: assuming no traps as we do, we can
    ;; optimize this as the new type will be valid.
    (drop
      (ref.cast
        (local.get $parent)
        (local.get $parent-rtt)
      )
    )
    ;; a cast of child to a supertype: again, we replace with a valid type.
    (drop
      (ref.cast
        (local.get $child)
        (local.get $parent-rtt)
      )
    )
    ;; a cast of parent to a subtype: we cannot replace the original heap type
    ;; $child with one that is not equal or more specific, like $parent, so we
    ;; cannot optimize here.
    (drop
      (ref.cast
        (local.get $parent)
        (local.get $child-rtt)
      )
    )
    ;; a cast of child to an unrelated type: it will trap anyhow
    (drop
      (ref.cast
        (local.get $child)
        (local.get $other-rtt)
      )
    )
  )

  ;; CHECK:      (func $ref-cast-iit-bad (param $parent (ref $parent)) (param $parent-rtt (rtt $parent))
  ;; CHECK-NEXT:  (local $2 (ref null $parent))
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (block (result (ref $parent))
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (block $block (result (ref $parent))
  ;; CHECK-NEXT:      (call $foo)
  ;; CHECK-NEXT:      (local.get $parent)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (block $block0 (result (rtt $parent))
  ;; CHECK-NEXT:      (call $foo)
  ;; CHECK-NEXT:      (local.get $parent-rtt)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (ref.as_non_null
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast
  ;; CHECK-NEXT:    (local.get $parent)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (ref.cast
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (local.get $parent-rtt)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $ref-cast-iit-bad (type $ref|$parent|_rtt_$parent_=>_none) (param $parent (ref $parent)) (param $parent-rtt (rtt $parent))
  ;; NOMNL-NEXT:  (local $2 (ref null $parent))
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (block (result (ref $parent))
  ;; NOMNL-NEXT:    (local.set $2
  ;; NOMNL-NEXT:     (block $block (result (ref $parent))
  ;; NOMNL-NEXT:      (call $foo)
  ;; NOMNL-NEXT:      (local.get $parent)
  ;; NOMNL-NEXT:     )
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (drop
  ;; NOMNL-NEXT:     (block $block0 (result (rtt $parent))
  ;; NOMNL-NEXT:      (call $foo)
  ;; NOMNL-NEXT:      (local.get $parent-rtt)
  ;; NOMNL-NEXT:     )
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:    (ref.as_non_null
  ;; NOMNL-NEXT:     (local.get $2)
  ;; NOMNL-NEXT:    )
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.cast
  ;; NOMNL-NEXT:    (local.get $parent)
  ;; NOMNL-NEXT:    (unreachable)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (ref.cast
  ;; NOMNL-NEXT:    (unreachable)
  ;; NOMNL-NEXT:    (local.get $parent-rtt)
  ;; NOMNL-NEXT:   )
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $ref-cast-iit-bad (type $ref|$parent|_rtt_$parent_=>_none) (param $parent (ref $parent)) (param $parent-rtt (rtt $parent))
  ;; NOMNL-TNH-NEXT:  (local $2 (ref null $parent))
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (block (result (ref $parent))
  ;; NOMNL-TNH-NEXT:    (local.set $2
  ;; NOMNL-TNH-NEXT:     (block $block (result (ref $parent))
  ;; NOMNL-TNH-NEXT:      (call $foo)
  ;; NOMNL-TNH-NEXT:      (local.get $parent)
  ;; NOMNL-TNH-NEXT:     )
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (drop
  ;; NOMNL-TNH-NEXT:     (block $block0 (result (rtt $parent))
  ;; NOMNL-TNH-NEXT:      (call $foo)
  ;; NOMNL-TNH-NEXT:      (local.get $parent-rtt)
  ;; NOMNL-TNH-NEXT:     )
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:    (ref.as_non_null
  ;; NOMNL-TNH-NEXT:     (local.get $2)
  ;; NOMNL-TNH-NEXT:    )
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (ref.cast
  ;; NOMNL-TNH-NEXT:    (local.get $parent)
  ;; NOMNL-TNH-NEXT:    (unreachable)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (ref.cast
  ;; NOMNL-TNH-NEXT:    (unreachable)
  ;; NOMNL-TNH-NEXT:    (local.get $parent-rtt)
  ;; NOMNL-TNH-NEXT:   )
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $ref-cast-iit-bad
    (param $parent (ref $parent))
    (param $parent-rtt (rtt $parent))

    ;; optimizing this cast away requires reordering.
    (drop
      (ref.cast
        (block (result (ref $parent))
          (call $foo)
          (local.get $parent)
        )
        (block (result (rtt $parent))
          (call $foo)
          (local.get $parent-rtt)
        )
      )
    )

    ;; ignore unreachability
    (drop
      (ref.cast
        (local.get $parent)
        (unreachable)
      )
    )
    (drop
      (ref.cast
        (unreachable)
        (local.get $parent-rtt)
      )
    )
  )

  ;; CHECK:      (func $ref-eq-ref-cast (param $x eqref)
  ;; CHECK-NEXT:  (drop
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $ref-eq-ref-cast (type $eqref_=>_none) (param $x eqref)
  ;; NOMNL-NEXT:  (drop
  ;; NOMNL-NEXT:   (i32.const 1)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $ref-eq-ref-cast (type $eqref_=>_none) (param $x eqref)
  ;; NOMNL-TNH-NEXT:  (drop
  ;; NOMNL-TNH-NEXT:   (i32.const 1)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $ref-eq-ref-cast (param $x eqref)
    ;; we can look through a ref.cast if we ignore traps
    (drop
      (ref.eq
        (local.get $x)
        (ref.cast
          (local.get $x)
          (rtt.canon $parent)
        )
      )
    )
  )

  ;; CHECK:      (func $set-of-as-non-null (param $x anyref)
  ;; CHECK-NEXT:  (local.set $x
  ;; CHECK-NEXT:   (local.get $x)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  ;; NOMNL:      (func $set-of-as-non-null (type $anyref_=>_none) (param $x anyref)
  ;; NOMNL-NEXT:  (local.set $x
  ;; NOMNL-NEXT:   (local.get $x)
  ;; NOMNL-NEXT:  )
  ;; NOMNL-NEXT: )
  ;; NOMNL-TNH:      (func $set-of-as-non-null (type $anyref_=>_none) (param $x anyref)
  ;; NOMNL-TNH-NEXT:  (local.set $x
  ;; NOMNL-TNH-NEXT:   (local.get $x)
  ;; NOMNL-TNH-NEXT:  )
  ;; NOMNL-TNH-NEXT: )
  (func $set-of-as-non-null (param $x anyref)
    ;; As we ignore such traps, we can remove the ref.as here.
    (local.set $x
      (ref.as_non_null
        (local.get $x)
      )
    )
  )
)
