//
// BAGEL - Parallel electron correlation program.
// Filename: _breitroot_8.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot8(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[8] = {1.139873801581614e+00,2.826336481165991e-01,2.601524843406029e+00,4.724114537527791e+00,7.605256299231614e+00,
    1.141718207654583e+01,1.649941079765582e+01,2.373000399593471e+01};
  constexpr double aw[8] = {1.967972714018076e-01,1.135696809762358e-01,1.064544854336141e-01,2.393874160156909e-02,2.271258737381319e-03,
    8.120230009266285e-05,8.211887069030494e-07,1.086971563315459e-09};
  constexpr double x[3072] = {  6.038910939619137e-02, -1.629524894849707e-03,  3.198126791811978e-05, -5.342217687088425e-07,  7.859490831612807e-09,
 -1.010415206975803e-10,  1.070850838352644e-12, -7.369400439630854e-15, -3.167597466567247e-17,  2.443099084877796e-18, -5.852588668244569e-20,  1.023764315566414e-21,
  2.349452753252876e-01, -5.796652457968223e-03,  9.342297208494112e-05, -1.034036930519525e-06,  4.643396289776993e-09,  1.106703175044163e-10, -3.386252269057934e-12,
  4.728317737966574e-14, -1.924682410426494e-16, -8.231905636466730e-18,  2.427322127745054e-19, -3.330981916899148e-21,  5.042353432987289e-01, -1.062116412278011e-02,
  1.127476239839172e-04, -2.439533399423596e-08, -2.068363556016774e-08,  2.909436122270953e-10,  1.040884400000420e-12, -9.494459809740326e-14,  1.134597610201860e-15,
  1.123313323771707e-17, -5.314938196022788e-19,  4.788547127381413e-21,  8.372886145401172e-01, -1.383806446171483e-02,  5.063668313142722e-05,  1.637267876633255e-06,
 -1.779393597949089e-08, -3.059807413981708e-10,  6.410288505343132e-12,  5.513302366728927e-14, -2.297594719390939e-15, -5.016532447464576e-18,  8.014216829748345e-19,
 -2.910872021346129e-21,  1.194002689745616e+00, -1.381951420249121e-02, -5.509656585132990e-05,  1.643283485476529e-06,  1.875501576110600e-08, -3.126316393313952e-10,
 -6.744030921708782e-12,  5.856169590278429e-14,  2.440421988861843e-15, -6.386107680366903e-18, -8.717442810013204e-19, -2.531153519066228e-21,  1.528992851245657e+00,
 -1.044304535965668e-02, -1.186499069387340e-04, -1.255630417912034e-07,  2.145209217824153e-08,  3.360750231079971e-10, -7.113261288408127e-13, -1.075126150629615e-13,
 -1.461892481997914e-15,  1.099332341183015e-17,  6.583309102356231e-19,  6.983716550695501e-21,  1.797091327270089e+00, -5.329914627650265e-03, -9.277450447388277e-05,
 -1.151480535622578e-06, -7.469850611728058e-09,  8.215472902331669e-11,  3.629854821787877e-12,  6.292255009075741e-14,  4.984866760092022e-16, -5.965885009283220e-18,
 -2.938365108273323e-19, -5.471717018434110e-21,  1.960237319127674e+00, -1.144891603737982e-03, -2.421385743035341e-05, -4.421527227950703e-07, -7.275864016952329e-09,
 -1.088241206336879e-10, -1.460225719700236e-12, -1.678324099125242e-14, -1.412766222785499e-16, -1.055223780069192e-19,  3.051239924407594e-20,  9.001116686730782e-22,
  5.434493580352417e-02, -1.397324479261685e-03,  2.626275901169535e-05, -4.233114885554593e-07,  6.078651309520417e-09, -7.786467067952236e-11,  8.607733668765800e-13,
 -7.350486172516062e-15,  2.335210929559002e-17,  8.274138874633940e-19, -2.602680173786549e-20,  5.043417334884612e-22,  2.131768176017106e-01, -5.097497745994461e-03,
  8.152022720042795e-05, -9.460163014326609e-07,  6.146803201062121e-09,  4.437771522173283e-11, -2.181346072892053e-12,  3.798140877234821e-14, -3.475078792320325e-16,
 -1.233226456001999e-18,  1.144583467100213e-19, -2.365337824277588e-21,  4.635454412890551e-01, -9.725533178365843e-03,  1.106633861350257e-04, -3.082518377444806e-07,
 -1.480799423799540e-08,  2.883645243258522e-10, -1.075027329574141e-12, -5.579777886854862e-14,  1.215704903785342e-15, -4.962455258245706e-18, -2.688901073605134e-19,
  6.150800128075906e-21,  7.828636007894402e-01, -1.335963087417152e-02,  6.840188344431571e-05,  1.312342352360071e-06, -2.229291105918104e-08, -1.418729237956038e-10,
  6.939193532815965e-12, -1.554460577471119e-14, -1.961926536417006e-15,  2.132919481075737e-17,  4.555041800069742e-19, -1.112833581501705e-20,  1.137974484989446e+00,
 -1.417683669729657e-02, -3.380961141197988e-05,  1.885259637444587e-06,  1.106045924817358e-08, -4.464406110881979e-10, -4.093489354534097e-12,  1.262963668356839e-13,
  1.596838765762295e-15, -3.898549528108630e-17, -6.469231601721314e-19,  1.247516587155383e-20,  1.485321625381619e+00, -1.139193731012175e-02, -1.178814692618539e-04,
  2.694028127914236e-07,  2.773397083082637e-08,  2.781527323691674e-10, -4.278020392728667e-12, -1.424091398507779e-13, -5.390473541975998e-16,  4.100563228473589e-17,
  7.605640481106081e-19, -4.202207077960868e-21,  1.774197102889838e+00, -6.129254807059632e-03, -1.072381144597665e-04, -1.252492040183451e-06, -4.804743697163390e-09,
  1.919239175436531e-10,  5.563658675506437e-12,  7.266652734540058e-14,  9.521863908441886e-18, -2.299511731047871e-17, -5.625250176222690e-19, -6.038888188183997e-21,
  1.955233698776620e+00, -1.361983443009995e-03, -3.029662355195242e-05, -5.780514529948083e-07, -9.843482275347573e-09, -1.500124077241512e-10, -1.991803487240293e-12,
 -2.103361082624367e-14, -1.107065329509041e-16,  2.234740035425728e-18,  9.648542941618364e-20,  2.283243049023445e-21,  4.914585728996371e-02, -1.205999367502939e-03,
  2.171862999675874e-05, -3.374571341596120e-07,  4.711802771894532e-09, -5.957012977883234e-11,  6.686888072976474e-13, -6.290081392345127e-15,  3.886267148863858e-17,
  1.358256467307353e-19, -1.053484234496413e-20,  2.305465611064399e-22,  1.940216811184679e-01, -4.489022104270596e-03,  7.077913293519808e-05, -8.430727680211803e-07,
  6.590407949189411e-09,  3.516499579761726e-12, -1.274998332352930e-12,  2.685223119668265e-14, -3.313419723794368e-16,  1.615725520664956e-18,  3.625485256443411e-20,
 -1.237387134528620e-21,  4.263853729099452e-01, -8.858623070797093e-03,  1.057273093893524e-04, -5.008981055935349e-07, -9.403470702971609e-09,  2.479850716454465e-10,
 -2.131470242888635e-12, -2.133159520613515e-14,  9.036874832662787e-16, -1.088401450993484e-17, -4.492877325680335e-20,  3.775350667918656e-21,  7.306104732385743e-01,
 -1.275564512175862e-02,  8.194485759369032e-05,  9.417393254180647e-07, -2.353349196245997e-08,  1.316144960328976e-11,  5.759849302620113e-12, -6.350049742667950e-14,
 -9.861441957221970e-16,  2.966627203109150e-17, -2.477888998288148e-20, -9.330263253584493e-21,  1.080872780721135e+00, -1.435451962211096e-02, -1.043313741805680e-05,
  1.986746677151894e-06,  1.459434422527963e-09, -4.979197872547015e-10, -8.124271001602990e-14,  1.512055623557156e-13, -1.129178522976716e-16, -5.109834885434662e-17,
  8.341582035448482e-20,  1.814953854321081e-20,  1.437899400556153e+00, -1.231413434688070e-02, -1.118244105482788e-04,  7.507008623206447e-07,  3.194375031694729e-08,
  1.272408789868824e-10, -8.246797525646556e-12, -1.308398836677332e-13,  1.392668198596222e-15,  6.246805445938613e-17,  1.793528511831610e-19, -2.214996910083376e-20,
  1.747867687549704e+00, -7.048243973244685e-03, -1.225772365997455e-04, -1.290724112046981e-06,  5.301487005211892e-10,  3.489701851100761e-10,  7.444476319603742e-12,
  5.493071238006487e-14, -1.276243264325504e-15, -4.943007863692997e-17, -7.036871977630524e-19,  1.735034995304342e-21,  1.949252984096728e+00, -1.635026240920946e-03,
 -3.828619863035590e-05, -7.623526517092933e-07, -1.337110616993626e-08, -2.051767396808011e-10, -2.611602197927474e-12, -2.230713560494703e-14,  6.973534790913733e-17,
  8.822194094714225e-18,  2.540345412999479e-19,  5.198268408209420e-21,  4.464540789755283e-02, -1.047251827982887e-03,  1.808482825278479e-05, -2.707848608591474e-07,
  3.667355854279273e-09, -4.549249200380004e-11,  5.102326025439057e-13, -5.032646040576449e-15,  3.817839435262143e-17, -1.285854771124951e-19, -3.607478938580681e-21,
  1.033033887742610e-22,  1.771365109012705e-01, -3.961468215162180e-03,  6.129252243263082e-05, -7.384913536694662e-07,  6.409703953934470e-09, -1.919783632837515e-11,
 -6.613769664069001e-13,  1.736888234839775e-14, -2.578621345867826e-16,  2.227556064560807e-18, -1.468943762872761e-22, -4.772059629306187e-22,  3.926013116389808e-01,
 -8.039047355056894e-03,  9.896804214418940e-05, -6.146044497164089e-07, -4.988372317844332e-09,  1.925627926029879e-10, -2.383639570379858e-12,  1.246412272792434e-15,
  5.121732699940567e-16, -1.015764493499158e-17,  6.307196421235289e-20,  1.301803764690040e-21,  6.809616297266701e-01, -1.206121829889345e-02,  9.101775138691830e-05,
  5.741638758062921e-07, -2.204624318641643e-08,  1.274577751722254e-10,  3.695093960472781e-12, -7.885846118532772e-14, -1.873876811999390e-17,  2.227308662837368e-17,
 -2.971197490041213e-19, -2.872536803086410e-21,  1.023438335097607e+00, -1.434297439854718e-02,  1.322282717207045e-05,  1.931735407414491e-06, -8.184644292763789e-09,
 -4.511124331585953e-10,  3.838589420150433e-12,  1.202724022286379e-13, -1.715310819302572e-15, -3.367449514720522e-17,  7.176468064924779e-19,  8.738127606812930e-21,
  1.386923152252596e+00, -1.316388947369413e-02, -9.970338267200460e-05,  1.270277282950279e-06,  3.224745066374114e-08, -1.075327720737464e-10, -1.095064754344369e-11,
 -5.104246208091740e-14,  3.502819566883278e-15,  4.683600225047742e-17, -1.001478793188985e-18, -2.735583682791015e-20,  1.717616365871794e+00, -8.090076738522980e-03,
 -1.377520865734505e-04, -1.216281890991471e-06,  9.389302610416612e-09,  5.396503152507311e-10,  8.106922917605433e-12, -1.934690859486738e-14, -3.494273247199981e-15,
 -7.034138803148826e-17, -1.692240780463759e-19,  2.535484593275235e-20,  1.942036786357839e+00, -1.981880712719728e-03, -4.886506425745306e-05, -1.012727441777500e-06,
 -1.814917451634285e-08, -2.747221936661810e-10, -3.140271806950699e-12, -1.250947073718652e-14,  6.370972549123091e-16,  2.487516559317631e-17,  5.846232138859066e-19,
  1.011295896791480e-20,  4.072650045286606e-02, -9.146384083779490e-04,  1.515948119591607e-05, -2.187661125964704e-07,  2.869240149760231e-09, -3.480489797821048e-11,
  3.855743590297255e-13, -3.904968809369612e-15,  3.190124195131864e-17, -1.968516093767465e-19, -3.034721637642103e-23,  7.163559826627666e-23,  1.622176097760012e-01,
 -3.504866209031487e-03,  5.303090701308363e-05, -6.397206617978486e-07,  5.901901996622320e-09, -3.009414580428177e-11, -2.787125468012553e-13,  1.036792672123520e-14,
 -1.813678374560283e-16,  1.960178954684573e-18, -9.646509363798708e-21,  1.516520444877977e-23,  3.619803460934921e-01, -7.277888187734360e-03,  9.123103152318994e-05,
 -6.666755780919978e-07, -1.698154664323130e-09,  1.373080162761245e-10, -2.170280481471002e-12,  1.235593137038535e-14,  2.015552560768906e-16, -6.924480034298140e-18,
  9.050514537773841e-20,  1.856267064752017e-22,  6.342085015950828e-01, -1.131129166096238e-02,  9.588897357322256e-05,  2.458923280118944e-07, -1.878663478439174e-08,
  1.902306205114691e-10,  1.581955944459662e-12, -6.906134678245524e-14,  5.550019163901679e-16,  9.614850171610602e-18, -2.970865293985835e-19,  2.415149295110635e-21,
  9.664208150026937e-01, -1.414734268746275e-02,  3.533923894060159e-05,  1.734629748108102e-06, -1.604889492834416e-08, -3.256854178014180e-10,  6.298130786304150e-12,
  5.202719235799195e-14, -2.356300015570466e-15, -1.430857790116291e-18,  7.973088075839334e-19, -4.379722185708601e-21,  1.332780930198339e+00, -1.389202956974169e-02,
 -8.148226908217172e-05,  1.754510365706496e-06,  2.742376563104840e-08, -3.736046504559253e-10, -1.062461451236174e-11,  7.820440541370443e-14,  4.220829743023782e-15,
 -1.210562187165397e-17, -1.760221033239229e-18, -2.196119324182378e-21,  1.682964359242274e+00, -9.247034063112074e-03, -1.510567992332860e-04, -9.695790033806113e-07,
  2.200889613206654e-08,  7.127586262954941e-10,  5.625218048901285e-12, -1.702329018766085e-13, -5.792525366574990e-15, -4.526038938580495e-17,  1.651479666729188e-18,
  5.588153133104752e-20,  1.933242901382534e+00, -2.426793282285484e-03, -6.295489442176557e-05, -1.351229978911020e-06, -2.440957544675955e-08, -3.509760128006740e-10,
 -3.032801571434760e-12,  2.768488071642964e-14,  2.075115227092392e-15,  5.869753719791424e-17,  1.138458479023515e-18,  1.429621660957626e-20,  3.729490823263962e-02,
 -8.031327121771805e-04,  1.278829557163181e-05, -1.779594475700895e-07,  2.257392416436265e-09, -2.675423020747963e-11,  2.894961065685689e-13, -2.991489953960404e-15,
  2.556756989408127e-17, -1.332942615971023e-19,  3.244536666460291e-21,  7.457066856887082e-23,  1.490002242728316e-01, -3.109767886771548e-03,  4.590004530360350e-05,
 -5.503810207693653e-07,  5.253520583140725e-09, -3.389275373929602e-11, -5.954591650575579e-14,  5.626551071265003e-15, -1.166179554386898e-16,  1.690336106574843e-18,
 -1.806626964167016e-21,  2.895029047910890e-22,  3.342774231799466e-01, -6.580311312043861e-03,  8.314970479389713e-05, -6.745787771525386e-07,  5.580427839576596e-10,
  8.989664210447190e-11, -1.766444399698527e-12,  1.552698202324919e-14,  1.871886792448025e-17, -3.207702993750603e-18,  9.459920569007029e-20,  5.809862264702535e-23,
  5.905094265909079e-01, -1.053718755799317e-02,  9.716669686006840e-05, -2.281207757607867e-08, -1.474753389449484e-08,  2.072438899311036e-10, -6.595133652836574e-14,
 -4.779277340713680e-14,  7.210701099868035e-16,  7.097106491989448e-19, -1.335425172012916e-19,  4.412460535837063e-21,  9.105219579635117e-01, -1.378617169083838e-02,
  5.442674010617016e-05,  1.434293991020120e-06, -2.097652733516728e-08, -1.654090936445998e-10,  6.732520783911390e-12, -1.855984062836065e-14, -1.900516344581266e-15,
  2.452720155637018e-17,  4.681297590275175e-19, -8.900526999257649e-21,  1.276052112834281e+00, -1.445286507234712e-02, -5.808424616383739e-05,  2.120668591830815e-06,
  1.765455573374970e-08, -5.879365494111016e-10, -6.704028185560573e-12,  1.932178237223529e-13,  2.600563887037435e-15, -7.280941601898486e-17, -9.963058596276667e-19,
  3.518810578221021e-20,  1.643495554324033e+00, -1.049492040642053e-02, -1.600900780838578e-04, -4.980712849692716e-07,  3.711545132843491e-08,  7.686939188052495e-10,
 -1.861369397734737e-12, -3.638870156665668e-13, -5.612326646515739e-15,  7.211242205763720e-17,  4.143196352229091e-18,  4.456313359647497e-20,  1.922415649826144e+00,
 -3.002488104771257e-03, -8.175632176566950e-05, -1.801467233868219e-06, -3.204587236286258e-08, -4.046608540556674e-10, -9.406865192107803e-13,  1.378747960071490e-13,
  5.151127306191342e-15,  1.155544740147894e-16,  1.625193015691798e-18,  2.733532772155028e-21,  3.427428134322320e-02, -7.087927389703695e-04,  1.085298299793224e-05,
 -1.457712052707439e-07,  1.785464915985058e-09, -2.072240125130280e-11,  2.166802506034648e-13, -2.219248256135686e-15,  2.379290697359008e-17,  4.899672153656349e-20,
  5.303196417238639e-21, -4.752832157206383e-24,  1.372556735788815e-01, -2.767608639578300e-03,  3.977731995643575e-05, -4.717784817298437e-07,  4.572194934689906e-09,
 -3.379667744059632e-11,  5.494536888712162e-14,  2.879084965970920e-15, -5.409536273508371e-17,  1.852623550068934e-18,  8.190173770195187e-21,  4.701804296008421e-23,
  3.092356817072511e-01, -5.947219254927375e-03,  7.516060625365285e-05, -6.534221482807827e-07,  1.967236505484098e-09,  5.270619725783761e-11, -1.335445931850496e-12,
  1.500947902078842e-14, -2.875292366550790e-17,  5.324723432234246e-19,  8.791645431319552e-20, -5.790697139380996e-22,  5.499083588233693e-01, -9.764647908291457e-03,
  9.561256087301110e-05, -2.261076612010885e-07, -1.071340724415377e-08,  1.922060711771446e-10, -1.082466482278829e-12, -2.497214049403677e-14,  6.951941594889097e-16,
 -1.037077266267622e-18,  3.123549707755066e-20,  2.352734967274978e-21,  8.563487891476845e-01, -1.328781299734042e-02,  6.954303420681161e-05,  1.080694544494948e-06,
 -2.274264245139996e-08, -1.601059597711277e-11,  5.515557840138650e-12, -6.238458291371351e-14, -7.721724826110839e-16,  3.574715059034476e-17,  1.035173598744633e-19,
 -7.636300196225361e-21,  1.217478016817360e+00, -1.481188566510832e-02, -3.135238032432434e-05,  2.302305125101891e-06,  4.762658940233697e-09, -6.771232899540857e-10,
 -5.584039654072616e-13,  2.301855627507530e-13, -3.154638847071947e-16, -7.698764151423678e-17,  8.113392423897418e-19,  3.818489886288001e-20,  1.598932328394511e+00,
 -1.178831894350437e-02, -1.620146281181340e-04,  2.125529680321392e-07,  5.112700563680902e-08,  5.850749663222898e-10, -1.393030566789810e-11, -4.674482556890350e-13,
  2.287827924569623e-16,  2.524012603286367e-16,  4.072346729151865e-18, -6.417085382991068e-20,  1.908947567934646e+00, -3.752340575309215e-03, -1.067168725780535e-04,
 -2.378472311079803e-06, -3.993796349008403e-08, -3.579997553617796e-10,  5.940141368605383e-12,  3.812977468908295e-13,  1.038886416576027e-14,  1.684678548615298e-16,
  5.031056926944177e-19, -6.965668067686760e-20,  3.160232578667824e-02, -6.285100072060183e-04,  9.262317711959643e-06, -1.202563443620999e-07,  1.418443582381003e-09,
 -1.617868294799470e-11,  1.657393309630828e-13, -1.392411657101394e-15,  2.881134169259029e-17,  1.984630860323936e-19,  4.720399821141658e-22, -2.353732374368131e-22,
  1.267875097081385e-01, -2.470842590886944e-03,  3.453290335645562e-05, -4.039344820772331e-07,  3.915236489037682e-09, -3.164247460908396e-11,  1.217618357211320e-13,
  2.269166177087527e-15,  1.692007472156627e-17,  1.984219320789959e-18, -8.626382749071656e-21, -9.049436956679167e-22,  2.866005619521366e-01, -5.376694076869720e-03,
  6.753792722019464e-05, -6.151133225864936e-07,  2.734515629715587e-09,  2.563492518109347e-11, -9.207724952938643e-13,  1.499532529724442e-14,  4.293291713143981e-17,
  3.007795806404409e-18,  2.006190365322234e-20, -2.722198688181929e-21,  5.123586424404775e-01, -9.013232651031083e-03,  9.199252407291429e-05, -3.683735779059435e-07,
 -7.172826162618234e-09,  1.603276309663374e-10, -1.473381559998024e-12, -2.966772711407504e-15,  6.917519884978203e-16,  7.475918019752074e-19,  1.441185582333417e-20,
 -3.564151266818964e-21,  8.043836483176297e-01, -1.268576209173885e-02,  8.033909566718708e-05,  7.208141007953494e-07, -2.188994188328354e-08,  9.381064429879530e-11,
  3.618164065660987e-12, -6.637379153044416e-14,  5.059072779495769e-16,  3.281318874261670e-17, -2.709009286570934e-19, -1.045257433293918e-20,  1.157904290250422e+00,
 -1.495192188614891e-02, -3.710891487719087e-06,  2.271580606960274e-06, -8.407477373799733e-09, -6.165892470096256e-10,  5.389698523117775e-12,  1.847091271900986e-13,
 -2.190863014401562e-15, -2.173118338933619e-17,  1.614575087936468e-18, -7.195685344875189e-21,  1.549223602796953e+00, -1.305957721335529e-02, -1.542403612506550e-04,
  1.101713851618962e-06,  5.846846910397080e-08,  1.038452160409674e-10, -2.537156925708657e-11, -2.915417513873780e-13,  1.115570454474409e-14,  3.141037011198006e-16,
 -2.009484553317968e-18, -2.003686314958185e-19,  1.892034007090949e+00, -4.731578171476946e-03, -1.392920716033436e-04, -3.062636290778400e-06, -4.458972542006672e-08,
 -4.420806142919650e-11,  2.216237216966133e-11,  8.059579418488927e-13,  1.565211547618767e-14,  7.839677833898845e-17, -6.495947600769313e-18, -2.737417585941301e-19,
  2.922785731724793e-02, -5.598211987528388e-04,  7.945402786888218e-06, -9.994501237951518e-08,  1.132054412830091e-09, -1.255846600822415e-11,  1.406184541972382e-13,
 -3.775119624746902e-16,  3.308288473722611e-17, -6.696578734474861e-20, -1.540531065246411e-20, -4.566270296785225e-22,  1.174274082557694e-01, -2.212950225307187e-03,
  3.004124600272798e-05, -3.461712094213123e-07,  3.317336614543242e-09, -2.783524892007406e-11,  2.025919633954986e-13,  3.788930443596886e-15,  6.951701622911174e-17,
  5.166556982593114e-19, -7.180718256928666e-20, -1.844378695177615e-21,  2.661287363504486e-01, -4.865140421478065e-03,  6.043251014809126e-05, -5.683133392298670e-07,
  3.061464025454375e-09,  8.828997331328840e-12, -4.658694528992723e-13,  1.797667581284548e-14,  1.299315005519520e-16,  6.765617344469946e-19, -1.524560867872916e-19,
 -4.825256295678502e-21,  4.777471470846909e-01, -8.296694139814485e-03,  8.698307429497722e-05, -4.593906234534987e-07, -4.313597156282357e-09,  1.264900712269766e-10,
 -1.244064874007974e-12,  1.928696534753288e-14,  6.735781628300397e-16, -3.713826992893682e-18, -2.785359337251676e-19, -9.054236861010170e-21,  7.549726246124848e-01,
 -1.201423402610017e-02,  8.696300998750721e-05,  3.897169082288125e-07, -1.928216902585537e-08,  1.611668254058157e-10,  2.143282003263217e-12, -3.438249839474843e-14,
  1.365020612980632e-15,  1.100749104624818e-17, -8.592493454499877e-19, -1.564443448375532e-20,  1.098205471903678e+00, -1.487574340507395e-02,  2.236122487602589e-05,
  2.047045632865423e-06, -1.906930443673497e-08, -4.334071885535948e-10,  9.542881022321516e-12,  1.129521310165293e-13, -2.034023250269748e-15,  2.069796103413759e-17,
  1.645437924342629e-19, -5.315199481556205e-20,  1.494623554867512e+00, -1.422478191123348e-02, -1.354510157493176e-04,  2.018815203287896e-06,  5.404435371052814e-08,
 -5.532397411703532e-10, -2.705120465371638e-11,  2.129557263607931e-13,  1.881446778650609e-14,  5.263117871473408e-17, -1.069732106297457e-17, -1.490727442648131e-19,
  1.870629337793975e+00, -6.004886852065419e-03, -1.802364408554301e-04, -3.745543908903867e-06, -3.803210857668817e-08,  8.152283857427362e-10,  5.164717426252147e-11,
  1.273304354722280e-12,  1.014182291068331e-14, -5.040180746419014e-16, -2.443525495568005e-17, -5.089986485237493e-19,  2.710851417665214e-02, -5.007653251507417e-04,
  6.847040446699116e-06, -8.365964960629853e-08,  9.143674743853849e-10, -9.198300462892667e-12,  1.434297888673413e-13,  4.842460391054264e-16,  1.477337731690524e-17,
 -1.072362940498175e-18, -3.336038930759351e-20, -2.394082407587746e-22,  1.090311787564605e-01, -1.988374555469161e-03,  2.618824976138755e-05, -2.972426963759321e-07,
  2.819134078346037e-09, -2.145519256781679e-11,  3.377421921215983e-13,  5.597263388571893e-15,  1.695441229244767e-17, -3.931429050736102e-18, -1.444630889877733e-19,
 -9.578563194256074e-22,  2.475930924131218e-01, -4.408116305644484e-03,  5.391099752696660e-05, -5.183453851669297e-07,  3.169343493077592e-09,  4.128221330064031e-12,
  8.854641813119411e-14,  2.093298769520491e-14, -5.992784259497306e-18, -9.507932103876799e-18, -3.408817441418698e-19, -2.538306454336525e-21,  4.459157711285537e-01,
 -7.623870787308475e-03,  8.113511191286846e-05, -5.095670876166381e-07, -2.026908203368312e-09,  1.053285145719521e-10, -4.422928404585806e-13,  3.576045476655390e-14,
  2.424940145672070e-16, -2.272962250888986e-17, -6.450903483437676e-19, -5.123027071162377e-21,  7.083296551091303e-01, -1.130480640908341e-02,  8.990327243827505e-05,
  1.095473141039111e-07, -1.559633184408904e-08,  2.060848264038374e-10,  1.796655701568973e-12,  7.680890270051080e-15,  9.818089468214923e-16, -3.627146390648580e-17,
 -1.442464254548715e-18, -6.711310469475912e-21,  1.039207769934405e+00, -1.460435536756637e-02,  4.485201757652966e-05,  1.685986838793594e-06, -2.522628555250427e-08,
 -1.731652493588487e-10,  1.188770934501806e-11,  5.627085884414492e-14, -1.759913770434704e-15, -2.127555686104777e-17, -2.169546400292641e-18, -3.987474657206287e-20,
  1.435730014743952e+00, -1.519784192592571e-02, -1.065079054677239e-04,  2.762974451370165e-06,  3.731771842331366e-08, -1.064329993343815e-09, -1.301841799782365e-11,
  7.539366835557541e-13,  1.205176772563553e-14, -4.354958407036635e-16, -1.170424487094902e-17,  1.207350033489273e-19,  1.843429001996395e+00, -7.635170629905362e-03,
 -2.280437505869377e-04, -4.143780939747344e-06, -6.353972356822102e-09,  2.494695040237234e-09,  8.752534288167860e-11,  1.077278753222368e-12, -3.054996701353613e-14,
 -1.860784230235275e-15, -3.895047117298562e-17,  1.351461876623885e-19,  2.520898163459518e-02, -4.497686981660172e-04,  5.925452623852243e-06, -7.030944411185002e-08,
  7.660131688795695e-10, -5.584986341977660e-12,  1.559191457415288e-13,  7.611636547009859e-17, -4.800751608905563e-17, -2.337150266468566e-18, -2.051846517919215e-20,
  1.051256611069105e-21,  1.014751455611884e-01, -1.792398890896426e-03,  2.287938426023388e-05, -2.550766526414960e-07,  2.483396149186749e-09, -1.157900125393025e-11,
  4.726499388079606e-13,  2.739506178745419e-15, -2.288820887108807e-16, -9.391747225834712e-18, -8.973390839296415e-20,  4.395366566581653e-21,  2.307850363321911e-01,
 -4.000838846619940e-03,  4.799874134230345e-05, -4.666660170633741e-07,  3.318828471862265e-09,  1.285202502400030e-11,  6.012208651620206e-13,  1.256584583993071e-14,
 -5.965409689965847e-16, -2.254508588090408e-17, -2.166792179233024e-19,  1.046786148134300e-20,  4.166791527881174e-01, -6.999642363925119e-03,  7.489431566174401e-05,
 -5.253770754072433e-07,  5.527093395557761e-11,  1.066659550878587e-10,  5.079669006346084e-13,  2.530180679848287e-14, -1.047556567916872e-15, -4.750636907346739e-17,
 -4.083180946471006e-19,  2.045729531068520e-20,  6.645516512787779e-01, -1.058423513397021e-02,  8.986450924915910e-05, -1.045600016381309e-07, -1.101425827367568e-08,
  2.537261374137550e-10,  2.175129125190182e-12,  7.038516658487361e-15, -1.346892573612137e-15, -8.967950869634479e-17, -8.892013218776723e-19,  4.005951349302818e-20,
  9.816262113242237e-01, -1.417163376334414e-02,  6.259921628424837e-05,  1.270567135424362e-06, -2.574720181733602e-08,  1.233134663661421e-10,  1.242640764764687e-11,
 -3.122766785054819e-14, -4.311947311622170e-15, -1.199469509217012e-16, -2.014735856681819e-18,  6.313001949667932e-20,  1.373456611145251e+00, -1.590882196670547e-02,
 -7.050612379888453e-05,  3.180536061015515e-06,  1.476970886099994e-08, -1.097238036755883e-09,  1.057431711892538e-11,  8.136717683962770e-13, -1.003845963617060e-14,
 -7.184067636002176e-16, -6.983604832877395e-19,  3.601810899751376e-19,  1.808928234538495e+00, -9.655577166300722e-03, -2.763415905506512e-04, -3.724783626509916e-06,
  6.611939935927431e-08,  4.775110685124053e-09,  9.203771328452622e-11, -1.223150001701513e-12, -1.181383336267682e-13, -2.603000403084489e-15,  2.347376595182348e-17,
  3.054455506138359e-18,  2.349965517200151e-02, -4.055387558002166e-04,  5.152241288560554e-06, -5.874694009122283e-08,  6.906682134227975e-10, -2.071416780864393e-12,
  1.234753559806446e-13, -2.836095745024557e-15, -1.299208944575749e-16, -1.585157530439364e-18,  7.427828766942490e-20,  3.187709744152947e-21,  9.465316985320617e-02,
 -1.620945553574030e-03,  2.005125115912467e-05, -2.165715797172900e-07,  2.365810634761261e-09, -4.674784897016055e-13,  3.940157888336334e-13, -1.015007918056895e-14,
 -5.606386537257160e-16, -6.416639826332812e-18,  3.059407553789738e-19,  1.331547207281291e-20,  2.155155012879753e-01, -3.638321133018138e-03,  4.272859027645284e-05,
 -4.106535955124699e-07,  3.734205217393116e-09,  2.856594287637416e-11,  5.589719822140934e-13, -1.989611943498764e-14, -1.394080076367950e-15, -1.545160782363076e-17,
  7.357713064279498e-19,  3.222685689266683e-20,  3.898392051730243e-01, -6.425523622277381e-03,  6.866809046292590e-05, -5.066119822442418e-07,  2.341374498354587e-09,
  1.219351951036569e-10,  4.814661456218780e-13, -3.620961714659030e-14, -2.717296079131392e-15, -3.279299194005825e-17,  1.473701072766164e-18,  6.412978725675150e-20,
  6.236408983570495e-01, -9.872929887969603e-03,  8.772895292672835e-05, -2.374159690079741e-07, -5.440115587419623e-09,  3.003061538520873e-10,  1.261311609488545e-12,
 -8.973333401028035e-14, -4.575479341545525e-15, -6.606703293634621e-17,  2.679806265146040e-18,  1.209389599103568e-19,  9.260283162656590e-01, -1.361656614224119e-02,
  7.550655910045734e-05,  8.939131496400272e-07, -2.046836999016539e-08,  3.911042752705375e-10,  8.905889400197981e-12, -2.455133975595198e-13, -8.965102535114611e-15,
 -9.547526796554408e-17,  4.495650700453823e-18,  2.304841052592317e-19,  1.308938574097042e+00, -1.631773132821256e-02, -3.158237658610739e-05,  3.261873856869831e-06,
 -3.078873425513233e-09, -6.296238047304456e-10,  2.512844144943515e-11,  1.073761870939970e-13, -3.211193693926779e-14, -3.781507320775508e-16,  1.887115943834228e-17,
  5.146904491832425e-19,  1.765637206548718e+00, -1.201916963965989e-02, -3.112036903343686e-04, -1.803154823841522e-06,  1.784090631579068e-07,  6.073313789875449e-09,
 -6.131852815587156e-12, -6.004057271530244e-12, -1.546486534653115e-13,  1.810445009337634e-15,  2.043489417522082e-16,  3.766062710598361e-18,  2.195573341903811e-02,
 -3.669550892811697e-04,  4.512641499253394e-06, -4.790253369138478e-08,  6.698872494660301e-10, -5.559402081446690e-13, -1.699024835350728e-14, -7.050958839552669e-15,
 -9.909812628203010e-17,  4.150575347268708e-18,  1.967596980902895e-19,  8.785447044322498e-22,  8.847465918818052e-02, -1.470285486280767e-03,  1.768051013312703e-05,
 -1.784143833407604e-07,  2.417023541643691e-09,  3.451544856027084e-12, -1.523811247414385e-13, -2.824408798476435e-14, -4.273715220085840e-16,  1.739952310782321e-17,
  8.200022872946743e-19,  3.788329317652476e-21,  2.016161600706408e-01, -3.315141247647035e-03,  3.817970031326651e-05, -3.458909913865527e-07,  4.367288049249109e-09,
  3.001544573322313e-11, -6.491516014350247e-13, -6.486084085033126e-14, -1.070768387062384e-15,  4.214973811861289e-17,  1.990959498552374e-18,  9.630865897976052e-21,
  3.651984432248414e-01, -5.899672461953401e-03,  6.289464183234988e-05, -4.495428717800184e-07,  4.760035776861009e-09,  1.109562064139982e-10, -1.812875725953923e-12,
 -1.249471958626286e-13, -2.136833172182756e-15,  8.263832522575007e-17,  4.002984051504807e-18,  2.044268569586408e-20,  5.855333180167879e-01, -9.183512311086458e-03,
  8.455814659275428e-05, -2.759347667644050e-07,  5.739326987461484e-10,  2.826928547324259e-10, -3.448232212077773e-12, -2.426749425458717e-13, -3.698051322619457e-15,
  1.484237713785209e-16,  7.516236782699448e-18,  4.207631012056624e-20,  8.728310959282022e-01, -1.297451737113314e-02,  8.455645390730671e-05,  6.376642602516822e-07,
 -1.124053227608408e-08,  4.885168401331629e-10, -2.133052758233228e-12, -5.317672877637324e-13, -6.598572207237839e-15,  2.930559632876559e-16,  1.401426705918553e-17,
  9.171931504511890e-20,  1.243408052936305e+00, -1.641540577793021e-02,  6.952660852615062e-06,  3.143471439180463e-06, -1.002798562931922e-08, -1.128585613930630e-10,
  1.299491518130749e-11, -9.489013469946708e-13, -2.689136207533293e-14,  7.916569501570687e-16,  3.657058078109274e-17,  6.468477311315311e-20,  1.712524454362006e+00,
 -1.453796395997878e-02, -3.119092944707194e-04,  1.949278466443157e-06,  2.823764788830340e-07,  3.471844987778373e-09, -2.212616609885931e-10, -8.148250876611884e-12,
  7.490921269137260e-14,  1.057831458282500e-14,  1.395234882376927e-16, -8.866737451000091e-18,  2.055673024618168e-02, -3.329724102090375e-04,  4.001487583264279e-06,
 -3.736671842266736e-08,  6.376285051834582e-10, -3.499859044145312e-12, -2.258764680498493e-13, -6.401702337685765e-15,  1.755151784084723e-16,  9.856686002372706e-18,
  5.368590617708434e-21, -1.009194794130757e-20,  8.286377761566212e-02, -1.336745325130558e-03,  1.577242517934538e-05, -1.396755327915782e-07,  2.380709713370849e-09,
 -1.044006431875629e-11, -9.968038544025575e-13, -2.592991596564609e-14,  7.218771465822721e-16,  4.125891564696667e-17,  2.449331410115809e-20, -4.217866874922509e-20,
  1.889419088489671e-01, -3.025081656090774e-03,  3.446353143385720e-05, -2.727222198211337e-07,  4.652617281365726e-09, -9.286933937538794e-12, -2.610500830001988e-12,
 -6.031945332863425e-14,  1.720598815264587e-15,  1.004151587253038e-16,  7.097930188169378e-20, -1.026894376173274e-19,  3.425739255599320e-01, -5.416651675137936e-03,
  5.801917822776940e-05, -3.592757972674443e-07,  6.236414423565137e-09,  2.157601117019788e-11, -5.607033604884551e-12, -1.164111327320729e-13,  3.412494803792887e-15,
  2.008082236133222e-16,  1.840434209115010e-19, -2.067355750806578e-19,  5.501319633638958e-01, -8.519747582234586e-03,  8.146732642424385e-05, -2.284847453531265e-07,
  4.809192476258866e-09,  1.120141733909531e-10, -1.069213867778778e-11, -2.201675418950241e-13,  6.515372148172491e-15,  3.730069368299618e-16,  4.353395120240693e-19,
 -3.905846593061731e-19,  8.223309999717061e-01, -1.226981713151484e-02,  9.142822885070467e-05,  5.278682071496275e-07, -3.256025265408486e-09,  2.483858532309466e-10,
 -1.763397182659891e-11, -4.702101617576404e-13,  1.310002801884077e-14,  7.145031265170951e-16,  6.094609059803050e-19, -7.593939195668047e-19,  1.178092576569105e+00,
 -1.621173740950824e-02,  4.366407329675587e-05,  2.971562801176255e-06, -1.167354897865461e-08, -1.809965021050979e-10, -1.943060683355985e-11, -1.094386460571390e-12,
  2.409687940860916e-14,  1.792820087253437e-15, -1.534919996867741e-18, -1.913559603974583e-18,  1.649642796847101e+00, -1.685981287400852e-02, -2.602429681415265e-04,
  6.666276139807933e-06,  2.831886454330658e-07, -3.938676941989983e-09, -3.565913588716798e-10,  4.109668720812283e-13,  4.270144253660668e-13,  4.894505925878843e-15,
 -4.522304542065197e-16, -1.196381790296081e-17,  1.928625966391517e-02, -3.025881525549345e-04,  3.610905097134896e-06, -2.806468132818940e-08,  5.035026231055117e-10,
 -1.013158612675226e-11, -2.784441681041343e-13,  3.961233969340253e-15,  4.137277975035727e-16,  1.236241386255623e-19, -4.629763614329840e-19, -5.804128760281020e-21,
  7.775942121201675e-02, -1.216648085719203e-03,  1.431324156105611e-05, -1.047374466941349e-07,  1.892887308748691e-09, -3.918562621700691e-11, -1.198195102684106e-12,
  1.705412601993857e-14,  1.720360808518396e-15,  5.725921736933699e-19, -1.938579738496186e-18, -2.438897046259551e-20,  1.773740092066868e-01, -2.761237043862952e-03,
  3.161915051160604e-05, -2.035915824648509e-07,  3.749178071098845e-09, -8.286707428102032e-11, -3.038344411517385e-12,  4.319325456499296e-14,  4.154926381156876e-15,
  1.453944148132808e-18, -4.730754441310068e-18, -5.986614748685893e-20,  3.218106936346940e-01, -4.968066202228750e-03,  5.429480730407905e-05, -2.641565977885643e-07,
  5.148963272466121e-09, -1.335258974335114e-10, -6.356096407149665e-12,  8.980972401065714e-14,  8.284614558982757e-15,  2.239712170466241e-18, -9.542421694010666e-18,
 -1.215917951947064e-19,  5.173410325034231e-01, -7.877596609131383e-03,  7.921158653878274e-05, -1.490772614504831e-07,  4.155903991342610e-09, -1.834130910115525e-10,
 -1.211384163961698e-11,  1.684655298773858e-13,  1.553050460882032e-14, -8.899276577665724e-19, -1.806359201443482e-17, -2.302899915609767e-19,  7.747537385701561e-01,
 -1.151372885290440e-02,  9.752997902116358e-05,  4.891865389713468e-07, -3.246403763069450e-09, -2.633233933954308e-10, -2.145707055242338e-11,  2.909500557524558e-13,
  3.003539056127057e-14, -2.467026333717551e-17, -3.539321995054491e-17, -4.321813913216837e-19,  1.114164985635336e+00, -1.572344755811015e-02,  7.797753231215211e-05,
  2.722362624596217e-06, -2.175137374839487e-08, -8.731660376183822e-10, -3.071054854650212e-11,  5.152026439810081e-13,  6.504069631104269e-14, -1.084845958305093e-16,
 -8.587968579991182e-17, -8.037394005787786e-19,  1.578643502204482e+00, -1.855362057639606e-02, -1.570879623660116e-04,  1.013451256537503e-05,  1.279224168700287e-07,
 -1.079419986505899e-08, -1.559714911992617e-10,  1.282865456764997e-11,  2.223892632300673e-13, -1.550361286392878e-14, -3.321054122162948e-16,  1.855059920605365e-17,
  1.813171904318899e-02, -2.749285300245656e-04,  3.314767501209716e-06, -2.192940581539403e-08,  2.502952745452279e-10, -1.411534791519318e-11, -7.758275398317717e-15,
  1.363538070327170e-14,  9.058212658376722e-17, -1.603722178239835e-17, -1.608134694237914e-19,  1.808280147038237e-20,  7.311451774716500e-02, -1.106723153840200e-03,
  1.320788826887797e-05, -8.201432390316548e-08,  8.904978621705649e-10, -5.652599764169270e-11, -5.677832045717305e-14,  5.720791688748897e-14,  3.692959356008025e-16,
 -6.706367612241557e-17, -6.688658753902133e-19,  7.597380526838418e-20,  1.668207394236517e-01, -2.517185057415521e-03,  2.947019514457139e-05, -1.601566381408558e-07,
  1.533518885949954e-09, -1.275533770359829e-10, -2.279296597170646e-13,  1.398274314770767e-13,  8.608140541868955e-16, -1.633902426626842e-16, -1.608773109698831e-18,
  1.866049252905084e-19,  3.027887193142172e-01, -4.545237195892751e-03,  5.150783489570849e-05, -2.100575890680228e-07,  1.301865384159497e-09, -2.285905751011220e-10,
 -6.588329621864290e-13,  2.812839948413488e-13,  1.622626746218158e-15, -3.291855838913334e-16, -3.149104409729281e-18,  3.805479059712751e-19,  4.870878150181950e-01,
 -7.250298726931300e-03,  7.765611580685867e-05, -1.251623014361347e-07, -1.766298693236136e-09, -3.665666618971320e-10, -1.466525798036710e-12,  5.234303151991901e-13,
  2.785284740241157e-15, -6.227897099370298e-16, -5.577500700811927e-18,  7.330124909436611e-19,  7.302945035080652e-01, -1.071145177729727e-02,  1.028361839213125e-04,
  3.717466943677459e-07, -1.248153798286922e-08, -5.827863133809722e-10, -1.977174586333371e-12,  9.632711067903655e-13,  4.587052943587607e-15, -1.211474635633261e-15,
 -9.181445273334724e-18,  1.470769249168063e-18,  1.052715354500859e+00, -1.497641700829661e-02,  1.078747516894404e-04,  2.203441964395937e-06, -4.430361442378889e-08,
 -1.229290999024963e-09,  7.582209332318601e-12,  1.892515251088771e-12,  4.614721538860703e-15, -2.736631079720073e-15, -1.102351674345199e-17,  3.618092887868107e-18,
  1.502712441882856e+00, -1.930616100994050e-02, -3.062330001257552e-05,  1.038025323940719e-05, -9.452316412616198e-08, -9.985833316333378e-09,  2.111494058150694e-10,
  1.027131812265701e-11, -3.498814041051874e-13, -1.033161529369534e-14,  5.221116608534731e-16,  9.740295389755094e-18,  1.708344309770160e-02, -2.494157980408051e-04,
  3.066647759245287e-06, -2.006450175541766e-08, -3.551919608253013e-12, -9.930244848451376e-12,  3.283328108416952e-13,  7.662380490560820e-15, -4.074890174927095e-16,
 -6.933170854024690e-18,  5.169185472698855e-19,  5.240359544477590e-21,  6.889294961740405e-02, -1.004838220065806e-03,  1.227313963445473e-05, -7.634495851161103e-08,
 -1.265957271100116e-10, -3.957841671412158e-11,  1.350039783148623e-12,  3.197992425941759e-14, -1.708051860432429e-15, -2.865841708726370e-17,  2.169130444776611e-18,
  2.156050125692974e-20,  1.572116892747519e-01, -2.288883119870466e-03,  2.761400279814938e-05, -1.550096252120665e-07, -7.623847617198169e-10, -8.839481794566222e-11,
  3.196486165774887e-12,  7.738148072390578e-14, -4.174055090734987e-15, -6.827514847583331e-17,  5.315650079660907e-18,  5.079194052762166e-20,  2.854159824438196e-01,
 -4.143242984682978e-03,  4.896573044763593e-05, -2.240200658851855e-07, -2.806711773603208e-09, -1.550024530549059e-10,  6.185214188487703e-12,  1.528938825655012e-13,
 -8.425068989135825e-15, -1.321845756009522e-16,  1.079786251001271e-17,  9.578389762614156e-20,  4.593182070698320e-01, -6.636083087608455e-03,  7.574994128524250e-05,
 -2.090894743951915e-07, -8.298727996872622e-09, -2.364648391726399e-10,  1.113504879350799e-11,  2.750192181533170e-13, -1.588687580885862e-14, -2.323444977853672e-16,
  2.064348141250758e-17,  1.574461131509268e-19,  6.891164010274555e-01, -9.875171088323705e-03,  1.057305726059542e-04,  8.517121230214665e-08, -2.251129661904002e-08,
 -3.296363458817898e-10,  2.072927185422963e-11,  4.679775447977694e-13, -3.040883569772733e-14, -3.860080964371627e-16,  4.066063822427275e-17,  2.091864143686251e-19,
  9.946838547826695e-01, -1.402142195773389e-02,  1.293310644069564e-04,  1.324966468564419e-06, -6.306415622196870e-08, -4.812808183891537e-10,  4.896610148306855e-11,
  6.738456272428924e-13, -6.684030722919856e-14, -5.049474390121653e-16,  9.361585596755916e-17, -9.798683238296038e-20,  1.425733138524463e+00, -1.909161284520923e-02,
  7.937256506652941e-05,  7.617609369714253e-06, -2.277079620246679e-07, -2.922730410762728e-09,  3.165864694204959e-10, -2.630358829170020e-12, -3.359689697404226e-13,
  9.187288226603000e-15,  2.586020772970058e-16, -1.582221611501476e-17,  1.613330391389215e-02, -2.258587419088641e-04,  2.820497600978676e-06, -2.123711795747732e-08,
 -1.140449855025685e-10, -1.035556346987079e-12,  3.513319655850762e-13, -5.438041034170664e-15, -3.050834235795603e-16,  1.036079627390311e-17,  1.982610482030164e-19,
 -1.447820770971137e-20,  6.506405251172231e-02, -9.103997805761629e-04,  1.132497754474355e-05, -8.275549176594389e-08, -5.553790986763483e-10, -2.957503446824752e-12,
  1.444660124922237e-12, -2.272172908885865e-14, -1.267469372791665e-15,  4.353163591005010e-17,  8.159524718446843e-19, -6.079634925938458e-20,  1.484857674032211e-01,
 -2.075723709373135e-03,  2.563718491639851e-05, -1.767320973086322e-07, -1.669863712491429e-09, -1.567157009491745e-12,  3.415425998523446e-12, -5.535501995352031e-14,
 -3.046353142953260e-15,  1.068734342310190e-16,  1.926484039032988e-18, -1.491107788512131e-19,  2.696081203119797e-01, -3.763211837085858e-03,  4.593446447869098e-05,
 -2.847816666606341e-07, -4.240732624712635e-09,  1.293547690263979e-11,  6.565235992697961e-12, -1.119205907701079e-13, -5.978530753793158e-15,  2.174892944740449e-16,
  3.664824267350131e-18, -3.029557233878478e-19,  4.339664518772283e-01, -6.042633567335267e-03,  7.233972038386135e-05, -3.636417258994765e-07, -1.004086324042339e-08,
  6.365355659824754e-11,  1.157361801212232e-11, -2.146677147860247e-13, -1.073801104387342e-14,  4.160163701634675e-16,  6.211045875918366e-18, -5.777446832910782e-19,
  6.513048122686578e-01, -9.031672943766634e-03,  1.044688148655191e-04, -2.982993481257067e-07, -2.365031479760439e-08,  2.132175650438633e-10,  2.026321835070379e-11,
 -4.353159147197743e-13, -1.866927558108400e-14,  8.167468283988762e-16,  9.416928624377219e-18, -1.124707577636020e-18,  9.407435206812084e-01, -1.294063102382408e-02,
  1.390727695439816e-04,  3.048789408877176e-07, -6.064156556907196e-08,  6.857690119494655e-10,  3.981977051453850e-11, -1.128662070857749e-12, -3.129743464928141e-14,
  1.871164712799425e-15,  7.590781152835549e-18, -2.467699994304517e-18,  1.351125428421515e+00, -1.815488213761255e-02,  1.482205949434007e-04,  3.876928935459337e-06,
 -2.209751862137400e-07,  2.921014261964372e-09,  1.488248613025293e-10, -7.372961814669150e-12,  2.851243511072544e-14,  7.733281665935056e-15, -2.308041480783629e-16,
 -3.172137253768359e-18,  1.527334037755339e-02, -2.043440818650673e-04,  2.555325459829757e-06, -2.283629350308531e-08, -6.690539192053942e-11,  4.835882861665207e-12,
  1.225497123609203e-13, -8.857597327183061e-15,  7.321927367709627e-17,  7.670784245625157e-18, -2.418331910766635e-19, -2.879833438512680e-21,  6.159715820979594e-02,
 -8.239168835251387e-04,  1.028199905658008e-05, -9.050992583001198e-08, -3.364667849686569e-10,  2.104621888957270e-11,  4.925483713716659e-13, -3.674315749535177e-14,
  3.123123565211577e-16,  3.180611965682654e-17, -1.016772543143396e-18, -1.161450425058487e-20,  1.405790240139450e-01, -1.879540273953168e-03,  2.336767357717072e-05,
 -1.999237873692232e-07, -1.047938827742545e-09,  5.457290099780794e-11,  1.115409567005861e-12, -8.819664996880380e-14,  7.886176200619013e-16,  7.618852532619464e-17,
 -2.499038230454406e-18, -2.633346614826388e-20,  2.552670406003853e-01, -3.410490368573608e-03,  4.214260848878979e-05, -3.433593847648178e-07, -2.739525128185033e-09,
  1.189145025411832e-10,  1.991350711672567e-12, -1.733814515651113e-13,  1.681346649087233e-15,  1.487736276800675e-16, -5.092723092835810e-18, -4.635667763547644e-20,
  4.109220967492798e-01, -5.483919258280508e-03,  6.709613268584022e-05, -5.015763664253093e-07, -6.616427387677233e-09,  2.448694355258311e-10,  3.081589980981480e-12,
 -3.151637467176064e-13,  3.467026830683067e-15,  2.653152554410734e-16, -9.751391020163561e-18, -6.634721366148826e-20,  6.168184830873733e-01, -8.216202187811415e-03,
  9.883163797529152e-05, -6.211692715127709e-07, -1.574133320460447e-08,  5.133486843806539e-10,  4.148869620997404e-12, -5.734005668421464e-13,  7.702341899666963e-15,
  4.565772165735487e-16, -1.909983994261205e-17, -5.530690725583200e-20,  8.912077728820422e-01, -1.182858834665335e-02,  1.374979833815831e-04, -5.157382309470104e-07,
 -4.025719241357050e-08,  1.208861493617996e-09,  3.711708141841845e-12, -1.164171322996579e-12,  2.195130825671852e-14,  7.535672184526440e-16, -4.276867787480313e-17,
  2.132816145643758e-19,  1.281094258646928e+00, -1.683776073114034e-02,  1.759051938174280e-04,  9.370677256279860e-07, -1.421741633640178e-07,  4.310114392245639e-09,
 -1.603790103126128e-11, -3.815783051814984e-12,  1.428633460050608e-13, -6.251626548503021e-16, -1.299388534414605e-16,  4.735195929631273e-18,  1.449509852988329e-02,
 -1.850078197699362e-04,  2.278363185966368e-06, -2.305020132145369e-08,  4.133625845968947e-11,  5.252323587922405e-12, -6.475008271251413e-14, -3.984158892292563e-15,
  1.779502896946105e-16, -1.105964360227919e-18, -1.405227768497032e-19,  4.865267215066670e-21,  5.845904016182600e-02, -7.460623390539427e-04,  9.178667172415886e-06,
 -9.220247205557421e-08,  1.286136830797532e-10,  2.242181347292159e-11, -2.811977242363788e-13, -1.633228075522677e-14,  7.405675517233861e-16, -4.808373126903660e-18,
 -5.806843905134792e-19,  2.040433756955879e-20,  1.334192656193300e-01, -1.702391734528442e-03,  2.090660180166504e-05, -2.072674396472258e-07,  1.341167975077280e-10,
  5.639284880807275e-11, -7.276043571831683e-13, -3.834808574210356e-14,  1.787359382276422e-15, -1.252414965206768e-17, -1.382188324687544e-18,  4.991090192853489e-20,
  2.422724638720063e-01, -3.090385854366943e-03,  3.784205986586411e-05, -3.670605656203275e-07, -2.292976314926440e-10,  1.180625311247534e-10, -1.585430950370216e-12,
 -7.265439436550057e-14,  3.540876838399422e-15, -2.782746144431969e-17, -2.670378636858523e-18,  1.008736075113978e-19,  3.900198042248644e-01, -4.972640890247640e-03,
  6.060920783664571e-05, -5.669299368345375e-07, -1.601788521194752e-09,  2.316227166571702e-10, -3.281724819099383e-12, -1.241013726875455e-13,  6.499018830623941e-15,
 -6.020367283117475e-17, -4.676110300962954e-18,  1.903472402411825e-19,  5.854827700213855e-01, -7.458855958830515e-03,  9.020938647411931e-05, -7.902985883076222e-07,
 -5.589434395101974e-09,  4.581983893432838e-10, -6.988174137906804e-12, -2.013288434538977e-13,  1.194142339978323e-14, -1.401135494724356e-16, -7.770050876396857e-18,
  3.623382986391882e-19,  8.460411352590751e-01, -1.076248939998143e-02,  1.282315963133382e-04, -9.710379434610957e-07, -1.735287706365461e-08,  1.000392781730237e-09,
 -1.708634618071928e-11, -3.134698684901724e-13,  2.423930096264006e-14, -4.080917784229479e-16, -1.168158537261189e-17,  7.563525105086380e-19,  1.216582610339635e+00,
 -1.541794019587207e-02,  1.762001890287748e-04, -6.965881313910303e-07, -6.599328526185293e-08,  3.112553838761018e-09, -6.721315291739451e-11, -2.350343451188159e-13,
  7.118042136371746e-14, -2.367263089178555e-15,  1.804565654709369e-17,  1.563913512154871e-18,  1.378979477758599e-02, -1.678687893864019e-04,  2.008844667643709e-06,
 -2.166000797316342e-08,  1.248671745892751e-10,  2.937523942309348e-12, -1.079910484212113e-13,  3.816938676086645e-16,  8.412801931102200e-17, -3.015796536364263e-18,
  2.188991257606928e-20,  1.913770176187685e-21,  5.561473269132864e-02, -6.769926258329469e-04,  8.097879171329764e-06, -8.703443724387515e-08,  4.852335713718931e-10,
  1.258485334219861e-11, -4.550393297300831e-13,  1.756765918429015e-15,  3.463124119098190e-16, -1.256032706150183e-17,  9.488838659093583e-20,  7.863414396711289e-21,
  1.269286070514365e-01, -1.544973092574418e-03,  1.846567836574367e-05, -1.973045728642410e-07,  1.030949811495189e-09,  3.181199262332391e-11, -1.120950481560977e-12,
  4.955743748809807e-15,  8.191390135479912e-16, -3.034883916160822e-17,  2.457096049466732e-19,  1.851791976497190e-20,  2.304886252944666e-01, -2.805167185478937e-03,
  3.348517218795990e-05, -3.543854959068758e-07,  1.646890047607418e-09,  6.694505849021238e-11, -2.283935244859542e-12,  1.199130277276701e-14,  1.569481543313085e-15,
 -6.019357952156133e-17,  5.403081009332507e-19,  3.512904544973756e-20,  3.710557101288960e-01, -4.515095555101351e-03,  5.378899980541463e-05, -5.605722025756249e-07,
  2.071077112413798e-09,  1.317495522280970e-10, -4.340684979969959e-12,  2.788966061939064e-14,  2.725732529525133e-15, -1.105155918051386e-16,  1.148030895888187e-18,
  5.957963067715613e-20,  5.570293228393438e-01, -6.776004884269498e-03,  8.045858182497803e-05, -8.167452181158530e-07,  1.638627605056159e-09,  2.599158968875677e-10,
 -8.299220443210772e-12,  6.745193222039638e-14,  4.536507657376102e-15, -2.024018553159719e-16,  2.586333829336445e-18,  9.286289327650807e-20,  8.049642320281126e-01,
 -9.786599672436915e-03,  1.154965718724326e-04, -1.112503127607819e-06, -1.768459677307810e-09,  5.572509763729181e-10, -1.753405102124526e-11,  1.906883385993458e-13,
  7.411203251061963e-15, -4.036458285325730e-16,  7.048869916658895e-18,  1.148192636062276e-19,  1.157657295697574e+00, -1.405555903542986e-02,  1.632791227774959e-04,
 -1.340664652772610e-06, -1.938438103168805e-08,  1.606438643507437e-09, -5.320238051540495e-11,  9.017062508127368e-13,  7.972647980495942e-15, -1.056539904482880e-15,
  3.342873411959377e-17, -3.837192437410706e-19,  1.314886770095004e-02, -1.528001623638758e-04,  1.762414899781770e-06, -1.932504345392111e-08,  1.597438676460217e-10,
  6.868928025065481e-13, -7.406744131119061e-14,  1.612333875879224e-15,  3.018874694027874e-18, -1.359160267209431e-18,  4.386223140084048e-20, -4.292441806567046e-22,
  5.302992052070164e-02, -6.162398310180161e-04,  7.106521233755361e-06, -7.781623251604833e-08,  6.365403188179140e-10,  3.126989438850817e-12, -3.107451568912721e-13,
  6.771732077309474e-15,  1.009618567990997e-17, -5.598355692218307e-18,  1.825392137517920e-19, -1.837446063187726e-21,  1.210296185543968e-01, -1.406398600812805e-03,
  1.621348647164694e-05, -1.770927328182871e-07,  1.420766817167141e-09,  8.622972449161035e-12, -7.596258343867481e-13,  1.659539168535367e-14,  1.373935898965970e-17,
 -1.325453581653344e-17,  4.403757759932070e-19, -4.656754334501043e-21,  2.197775292863905e-01, -2.553765052609806e-03,  2.942568963784777e-05, -3.201097691806301e-07,
  2.486396570738585e-09,  2.003469799060063e-11, -1.529332511495047e-12,  3.358809417224354e-14, -5.683536937575026e-18, -2.542596830369220e-17,  8.709075591649004e-19,
 -9.921867018805398e-21,  3.538143637003731e-01, -4.110962317976565e-03,  4.733063371571577e-05, -5.116156913494222e-07,  3.764341537846473e-09,  4.352798182584589e-11,
 -2.854347267239697e-12,  6.336002342039562e-14, -1.017976899675771e-16, -4.420693641284844e-17,  1.590169069711314e-18, -2.017339774601860e-20,  5.311516345017738e-01,
 -6.170765420624067e-03,  7.095372912339784e-05, -7.589036767598903e-07,  5.057348726575583e-09,  9.391018220680252e-11, -5.303639653571413e-12,  1.202872651215821e-13,
 -4.470523939137051e-16, -7.359443978241789e-17,  2.879041147329752e-18, -4.270519058507901e-20,  7.675814914618194e-01, -8.915799360620570e-03,  1.022762702170658e-04,
 -1.072357029208891e-06,  5.689882542104659e-09,  2.159375577977767e-10, -1.064770111523362e-11,  2.529705185047247e-13, -1.798067769253083e-15, -1.198840343522764e-16,
  5.579535788455402e-18, -1.055812688223656e-19,  1.103940895871996e+00, -1.281691603384727e-02,  1.461896594134937e-04, -1.454424440617230e-06,  2.051329188023543e-09,
  6.345207433719098e-10, -2.848430907648220e-11,  7.672759859311007e-13, -1.087587308364729e-14, -1.297866479871932e-16,  1.298918479690807e-17, -4.016310415953358e-19,
  1.256445900622707e-02, -1.395845030101497e-04,  1.546031650743383e-06, -1.674074567930408e-08,  1.592674017689736e-10, -5.722898455918616e-13, -3.277743304812949e-14,
  1.217761868579795e-15, -2.025990558041744e-17, -1.115719877152665e-19,  1.788760338787696e-20, -5.493128918972845e-22,  5.067299926976550e-02, -5.629472650963105e-04,
  6.234758991264762e-06, -6.747328416695151e-08,  6.394263784265108e-10, -2.159669796211989e-12, -1.379916480189145e-13,  5.081026894818154e-15, -8.504103073614240e-17,
 -4.307061311611780e-19,  7.362470002104050e-20, -2.282230772148815e-21,  1.156505365768598e-01, -1.284797268492798e-03,  1.422767353813848e-05, -1.538170032795258e-07,
  1.447345229727710e-09, -4.313477940650744e-12, -3.390958538260304e-13,  1.230818080576357e-14, -2.082400510117642e-16, -8.939154298346193e-19,  1.740648941553223e-19,
 -5.488706689815001e-21,  2.100099322700935e-01, -2.333029453248558e-03,  2.583068304563823e-05, -2.788053959188746e-07,  2.593330400665571e-09, -6.034150345031380e-12,
 -6.868839971268361e-13,  2.446866963176506e-14, -4.211454197218032e-16, -1.316678427698459e-18,  3.330714991534195e-19, -1.079785391917777e-20,  3.380904276079369e-01,
 -3.755806005553276e-03,  4.157089297631409e-05, -4.475621539023585e-07,  4.086860265744413e-09, -5.135205887850144e-12, -1.288941080041755e-12,  4.493875031150762e-14,
 -7.942457090736748e-16, -1.143760985601532e-18,  5.765243733423590e-19, -1.954214175760378e-20,  5.075482361125963e-01, -5.638084074229115e-03,  6.237497340388653e-05,
 -6.687846778968321e-07,  5.919329668112342e-09,  3.672329880261349e-12, -2.398479731271928e-12,  8.187559882700861e-14, -1.509359680943303e-15,  1.550779178705109e-18,
  9.516389647560209e-19, -3.482274455840061e-20,  7.334757330835371e-01, -8.147265325219337e-03,  9.005797184201365e-05, -9.583999330758758e-07,  7.981282062241439e-09,
  3.621690334111808e-11, -4.764014889952579e-12,  1.605011139792978e-13, -3.184254756389277e-15,  1.565811015715524e-17,  1.520568658539952e-18, -6.524090229621251e-20,
  1.054903526013045e+00, -1.171589672816224e-02,  1.292501534931284e-04, -1.350652711045545e-06,  9.434698869977860e-09,  1.678817449518688e-10, -1.203542005716981e-11,
  4.153303635627249e-13, -9.677132370461728e-15,  1.210897037166408e-16,  1.525918216698330e-18, -1.356746272124391e-19,  1.202964492969869e-02, -1.279775802715653e-04,
  1.359944691453176e-06, -1.431650790103943e-08,  1.423370855054801e-10, -1.022868636701703e-12, -7.618590639807387e-15,  6.023437414332812e-16, -1.625226610561453e-17,
  2.274053718990872e-19,  1.679527842489017e-21, -1.980476354891646e-22,  4.851607838867063e-02, -5.161382210388809e-04,  5.484575039412801e-06, -5.772513071986363e-08,
  5.730484735056535e-10, -4.070132543894124e-12, -3.310681642668380e-14,  2.510303051086877e-15, -6.765899398202548e-17,  9.547046133722082e-19,  6.583120211229123e-21,
 -8.140454035549711e-22,  1.107278443484591e-01, -1.177974321149965e-03,  1.251682291253043e-05, -1.316881842868616e-07,  1.303730642550459e-09, -9.061407563297202e-12,
 -8.542963798347158e-14,  6.066708801231991e-15, -1.632788441359717e-16,  2.338705180261219e-18,  1.412610695661691e-20, -1.919701962776759e-21,  2.010708938698174e-01,
 -2.139075207641396e-03,  2.272766488158666e-05, -2.389675509621139e-07,  2.355501796024979e-09, -1.579316807649283e-11, -1.839533588826444e-13,  1.200947399234200e-14,
 -3.228705677020596e-16,  4.733410536907331e-18,  2.248170388869795e-20, -3.657791315227699e-21,  3.236998708000893e-01, -3.443627028167276e-03,  3.658469807452033e-05,
 -3.842978789602740e-07,  3.762186165906789e-09, -2.375820936918676e-11, -3.694214586625790e-13,  2.188825753671562e-14, -5.888358136321452e-16,  8.938883337175885e-18,
  2.584540662294435e-20, -6.286776219213874e-21,  4.859453307939225e-01, -5.169587152151384e-03,  5.491200448926897e-05, -5.759314728364712e-07,  5.575591233082369e-09,
 -3.158962440724434e-11, -7.363103970518709e-13,  3.931179201092047e-14, -1.063232192527954e-15,  1.702371365387525e-17,  3.419699817619923e-21, -1.024678415655565e-20,
  7.022578557734798e-01, -7.470612371909471e-03,  7.933085298121154e-05, -8.297863536285332e-07,  7.870114491537341e-09, -3.488402607595966e-11, -1.555379217517262e-12,
  7.480326381742039e-14, -2.059439072876377e-15,  3.600543218564988e-17, -1.418204175887087e-19, -1.593482876781039e-20,  1.010009143977870e+00, -1.074399011622553e-02,
  1.140174217247508e-04, -1.185152435397660e-06,  1.068281849450776e-08, -1.219290593491463e-11, -4.054877910665342e-12,  1.784955264232879e-13, -5.217443632428017e-15,
  1.089222083767478e-16, -1.259525651874326e-18, -1.413818727960824e-20,  1.153845822538452e-02, -1.177480942191979e-04,  1.201117020831435e-06, -1.220793251210114e-08,
  1.211463159023036e-10, -1.054406768794663e-12,  3.212215135631159e-15,  2.135238863556780e-16, -8.313285967133575e-18,  1.879542381230274e-19, -2.348922369865838e-21,
 -1.763534429704901e-23,  4.653510326103354e-02, -4.748829226898078e-04,  4.844115597357214e-06, -4.923083806863225e-08,  4.882659416277555e-10, -4.233706797573586e-12,
  1.208394391794278e-14,  8.938774911163428e-16, -3.451987329058647e-17,  7.815405043842187e-19, -9.862044220010564e-21, -6.908623989872987e-23,  1.062066897926284e-01,
 -1.083820405960875e-03,  1.105551589558930e-05, -1.123415789852906e-07,  1.113040870870196e-09, -9.585298699266483e-12,  2.398223054049608e-14,  2.175696883132149e-15,
 -8.291427441559247e-17,  1.882287566430808e-18, -2.416196921549399e-20, -1.480966401861269e-22,  1.928609456423288e-01, -1.968108709257374e-03,  2.007524818495368e-05,
 -2.039509524116992e-07,  2.017363641209288e-09, -1.718290640365952e-11,  3.311640250353209e-14,  4.346462644297134e-15, -1.627054042042303e-16,  3.711286848681949e-18,
 -4.891307142155825e-20, -2.353224301126417e-22,  3.104829054350646e-01, -3.168410777193967e-03,  3.231753797092783e-05, -3.282120794331993e-07,  3.238252195211801e-09,
 -2.710517708352117e-11,  2.706355599493445e-14,  8.001562013242895e-15, -2.931263593714281e-16,  6.741696152347580e-18, -9.239395264087530e-20, -2.700321534507941e-22,
  4.661038752889515e-01, -4.756471918427861e-03,  4.851299589227601e-05, -4.924243014549735e-07,  4.838724321363715e-09, -3.934664234985941e-11, -2.340223803940582e-14,
  1.449604141402074e-14, -5.186306218850250e-16,  1.210720724894441e-17, -1.759563077436381e-19, -3.795704598520465e-23,  6.735845755115727e-01, -6.873717779899160e-03,
  7.010100990415719e-05, -7.108812879027744e-07,  6.935166229832264e-09, -5.339281307047502e-11, -2.021100164062348e-13,  2.762969718735236e-14, -9.674351993450795e-16,
  2.325946756125467e-17, -3.714613220488220e-19,  1.436806523485810e-21,  9.687714339914423e-01, -9.885878010592035e-03,  1.007998880020924e-04, -1.020063058766130e-06,
  9.787171806278647e-09, -6.514080349440102e-11, -8.772615830287162e-13,  6.413226970851146e-14, -2.237537258418434e-15,  5.787678130298100e-17, -1.108249540754588e-18,
  1.227524556836788e-20,  1.108580036939846e-02, -1.086937543458340e-04,  1.065573950824418e-06, -1.043254232542661e-08,  1.011821449300685e-10, -9.300403568841233e-13,
  6.351872431361036e-15,  3.733173080561188e-17, -3.247800031076973e-18,  9.655704483477471e-20, -1.939352265190871e-21,  2.263847229249899e-23,  4.470951505678696e-02,
 -4.383665684604082e-04,  4.297494384138480e-06, -4.207364892577963e-08,  4.079743798378342e-10, -3.744947498176644e-12,  2.532548848634526e-14,  1.623351009110587e-16,
 -1.349170576420014e-17,  4.002166047280613e-19, -8.057746802239282e-21,  9.500711000549489e-23,  1.020401670201399e-01, -1.000480210439853e-03,  9.808089100279399e-06,
 -9.601924600737449e-08,  9.307166809221567e-10, -8.522652063342557e-12,  5.659895772840321e-14,  4.190862632949447e-16, -3.242021046634710e-17,  9.583342224764533e-19,
 -1.938007592751499e-20,  2.325858849669194e-22,  1.852949552956585e-01, -1.816773316513345e-03,  1.781039359095125e-05, -1.743469745845557e-07,  1.688944955472399e-09,
 -1.540616173854411e-11,  9.931360658880644e-14,  9.018087821916112e-16, -6.361670179086678e-17,  1.872162521884885e-18, -3.813361278112300e-20,  4.702610004959581e-22,
  2.983025886544100e-01, -2.924784509280470e-03,  2.867225812162824e-05, -2.806418544976973e-07,  2.716172570030567e-09, -2.462816328669444e-11,  1.512422431834203e-13,
  1.805425836296916e-15, -1.144385759943106e-16,  3.352228098551362e-18, -6.906858924634657e-20,  8.865466863289446e-22,  4.478185509639259e-01, -4.390747625316595e-03,
  4.304266033088935e-05, -4.212217411999979e-07,  4.070895084448498e-09, -3.655775406977319e-11,  2.062597667305078e-13,  3.570475991880275e-15, -2.014458313918316e-16,
  5.881958914233693e-18, -1.235025208419207e-19,  1.682555893489664e-21,  6.471598488451501e-01, -6.345227424906227e-03,  6.220070429330077e-05, -6.085159948238433e-07,
  5.866312935640615e-09, -5.178221641415645e-11,  2.446915143410727e-13,  7.408802614092124e-15, -3.704107498043464e-16,  1.084154311999422e-17, -2.355455009814514e-19,
  3.526295690650035e-21,  9.307668168168162e-01, -9.125883751843363e-03,  8.945336724969556e-05, -8.745479481830852e-07,  8.384592141114666e-09, -7.109133021268528e-11,
  1.745556673810493e-13,  1.839971450047339e-14, -8.182855230178523e-16,  2.453638172946566e-17, -5.758429527467866e-19,  1.028459274510059e-20,  1.066731872122145e-02,
 -1.006437620415052e-04,  9.495104748463250e-07, -8.953971246246665e-09,  8.414159877489659e-11, -7.740703878064519e-13,  6.369428306422843e-15, -2.397876494614269e-17,
 -9.260805216279732e-19,  3.881037774258811e-20, -9.849215235690471e-22,  1.813897592378607e-23,  4.302176052906733e-02, -4.059006526292437e-04,  3.829413887854600e-06,
 -3.611140801326580e-08,  3.393186446974523e-10, -3.120083223142711e-12,  2.559700083012734e-14, -9.282384104866645e-17, -3.873882272229826e-18,  1.607150710810753e-19,
 -4.077897482284719e-21,  7.531507042474927e-23,  9.818821907656591e-02, -9.263837289232856e-04,  8.739827689690554e-06, -8.241535812937543e-08,  7.743094138846350e-10,
 -7.113666681579685e-12,  5.804569947730444e-14, -1.958796325500655e-16, -9.414380650409190e-18,  3.841417492882181e-19, -9.746219091182844e-21,  1.809324966518968e-22,
  1.783001967326481e-01, -1.682221977227920e-03,  1.587063508765553e-05, -1.496541874834102e-07,  1.405742592625264e-09, -1.289691131473787e-11,  1.043314652010140e-13,
 -3.096829509615903e-16, -1.875408044774972e-17,  7.480413452897826e-19, -1.898639692848652e-20,  3.553765453275707e-22,  2.870418733090247e-01, -2.708174548343677e-03,
  2.554972450165266e-05, -2.409153810977624e-07,  2.262273327111076e-09, -2.071121817674310e-11,  1.653030268196574e-13, -3.839879713983399e-16, -3.434976805326627e-17,
  1.331913015338896e-18, -3.386177214307792e-20,  6.419415800863060e-22,  4.309137224903045e-01, -4.065571399850045e-03,  3.835561466132745e-05, -3.616446131303073e-07,
  3.394293019994765e-09, -3.097119482309729e-11,  2.418362354672798e-13, -3.015958375177590e-16, -6.164971884142229e-17,  2.313244839122357e-18, -5.908059487600378e-20,
  1.143085459146085e-21,  6.227300550297409e-01, -5.875311290584163e-03,  5.542867931999515e-05, -5.225705927686192e-07,  4.900592333221336e-09, -4.445686553819622e-11,
  3.335710856013402e-13,  2.664735733186381e-16, -1.153142259195310e-16,  4.177020463068714e-18, -1.079493877554428e-19,  2.164068004515757e-21,  8.956311499611003e-01,
 -8.450060400857620e-03,  7.971790019557899e-05, -7.514104812652268e-07,  7.034047403391910e-09, -6.300122244668964e-11,  4.289081263736626e-13,  2.691492519564882e-15,
 -2.550384033328670e-16,  8.968830339865101e-18, -2.400257005823153e-19,  5.194615949166792e-21,  1.027928616433525e-02, -9.345570630083865e-05,  8.496556938530313e-07,
 -7.723525569047740e-09,  7.012176683842656e-11, -6.315550916510571e-13,  5.447159495339154e-15, -3.747421138619558e-17, -7.194477408624550e-20,  1.251624488106296e-20,
 -3.969272302176569e-22,  9.014423768265886e-24,  4.145680838630644e-02, -3.769109253118509e-04,  3.426697556539227e-06, -3.114922162999499e-08,  2.827964056052707e-10,
 -2.546584397682921e-12,  2.194175269175123e-14, -1.499396170431328e-16, -3.352469282768477e-19,  5.193238212864682e-20, -1.640931197515184e-21,  3.729338205192497e-23,
  9.461654152151260e-02, -8.602207646955166e-04,  7.820721000538425e-06, -7.109123974790638e-08,  6.453924311553666e-10, -5.809986879567316e-12,  4.996748352165724e-14,
 -3.373037641282985e-16, -9.504437570104173e-19,  1.245158719536481e-19, -3.910914042437498e-21,  8.900947133499433e-23,  1.718143803174477e-01, -1.562076673576656e-03,
  1.420165447107663e-05, -1.290936590463207e-07,  1.171879835118768e-09, -1.054449005431082e-11,  9.042166954109756e-14, -5.984551843937724e-16, -2.259205865390554e-18,
  2.434262146250655e-19, -7.583843181077273e-21,  1.730378068981559e-22,  2.766004900795864e-01, -2.514755458388979e-03,  2.286293270828940e-05, -2.078226521838065e-07,
  1.886366898282199e-09, -1.696096940663723e-11,  1.447949048542482e-13, -9.287081841272514e-16, -4.962398230216642e-18,  4.352188751010756e-19, -1.342543525653153e-20,
  3.076783805135537e-22,  4.152388856247377e-01, -3.775207231228413e-03,  3.432229632275945e-05, -3.119820002709817e-07,  2.831348016917636e-09, -2.542853645486498e-11,
  2.155496743315959e-13, -1.311831698188660e-15, -1.062017962475205e-17,  7.581096365644335e-19, -2.313355581740317e-20,  5.344236348965587e-22,  6.000777496526403e-01,
 -5.455697044277779e-03,  4.960034877282283e-05, -4.508426819269066e-07,  4.090456063816532e-09, -3.666529998434600e-11,  3.069929413957291e-13, -1.689321466881366e-15,
 -2.340842010498292e-17,  1.366469301956014e-18, -4.130064445253372e-20,  9.693391344084089e-22,  8.630518670496709e-01, -7.846563698320312e-03,  7.133651111877883e-05,
 -6.483743414234406e-07,  5.879355747031233e-09, -5.248340659218634e-11,  4.275975578826327e-13, -1.776472324610761e-15, -5.987334972480329e-17,  2.875438207678669e-18,
 -8.694312300538518e-20,  2.121409884658151e-21,  9.918496559380536e-03, -8.701103244672900e-05,  7.633102827627024e-07, -6.695880059681763e-09,  5.871307036370775e-11,
 -5.133509883511798e-13,  4.415446040863323e-15, -3.497378393786083e-17,  1.708000823283740e-19,  2.692275318832852e-21, -1.335664373274547e-22,  3.597394037803182e-24,
  4.000172822107655e-02, -3.509192789037023e-04,  3.078463375834616e-06, -2.700475158919648e-08,  2.367903201473437e-10, -2.070229513629279e-12,  1.780014228532148e-14,
 -1.407030904371754e-16,  6.751678321471225e-19,  1.132202799223613e-20, -5.523265055386597e-22,  1.485614582546490e-23,  9.129562376569632e-02, -8.009002533512055e-04,
  7.025951442423528e-06, -6.163263031549297e-08,  5.404163137129394e-10, -4.724308202388250e-12,  4.059431973300072e-14, -3.197034252568696e-16,  1.484886908961682e-18,
  2.774562304944759e-20, -1.316765925914409e-21,  3.534248337634470e-23,  1.657839187774280e-01, -1.454356472277231e-03,  1.275843787340819e-05, -1.119185487250617e-07,
  9.813195167245472e-10, -8.577290776222282e-12,  7.362761108740992e-14, -5.764899235022651e-16,  2.535901389170206e-18,  5.586038431951785e-20, -2.553348282005195e-21,
  6.834763077938531e-23,  2.668921725137137e-01, -2.341338990862065e-03,  2.053954488357440e-05, -1.801747348017275e-07,  1.579749061799260e-09, -1.380453245792371e-11,
  1.183171872140000e-13, -9.181112377266476e-16,  3.686544747336462e-18,  1.035149168179303e-19, -4.515692334191303e-21,  1.205283956993815e-22,  4.006645413103431e-01,
 -3.514870759093107e-03,  3.083441418404383e-05, -2.704808322361785e-07,  2.371422528017157e-09, -2.071468854137638e-11,  1.771202445142175e-13, -1.354886189227906e-15,
  4.597909078143546e-18,  1.878046340681189e-19, -7.755171068849177e-21,  2.065529882052327e-22,  5.790158034434661e-01, -5.079475313498576e-03,  4.455997147586053e-05,
 -3.908786344678630e-07,  3.426716802374452e-09, -2.991386284604935e-11,  2.547425760562740e-13, -1.900291401599916e-15,  4.308268711439594e-18,  3.533747999124552e-19,
 -1.371737252017935e-20,  3.657183233437539e-22,  8.327598769265657e-01, -7.305470641326539e-03,  6.408755096928941e-05, -5.621641933114216e-07,  4.927494375613654e-09,
 -4.295888716121823e-11,  3.627099150053013e-13, -2.556222703375381e-15, -1.124437830631901e-18,  7.718823099195468e-19, -2.805933809062505e-20,  7.579095754461722e-22,
  9.582178069460339e-03, -8.121072696304226e-05,  6.882751348786786e-07, -5.833170350533150e-09,  4.942989641514375e-11, -4.184545495413547e-13,  3.521436222492018e-15,
 -2.873386932160451e-17,  2.015572128799371e-19, -3.445530595586774e-22, -3.536079753540478e-23,  1.225394396701092e-24,  3.864534111917924e-02, -3.275263954112863e-04,
  2.775843517516366e-06, -2.352542382491164e-08,  1.993523992336769e-10, -1.687609418977251e-12,  1.420007611860740e-14, -1.157885603504968e-16,  8.089647051186068e-19,
 -1.250957277057633e-21, -1.468942693042053e-22,  5.058080361644995e-24,  8.819995236311969e-02, -7.475108665495351e-04,  6.335285207765644e-06, -5.369186181238138e-08,
  4.549782538635211e-10, -3.851471006691553e-12,  3.240045068827253e-14, -2.638699832219546e-16,  1.830253323116812e-18, -2.287309401752514e-21, -3.528311492095558e-22,
  1.202133825367640e-23,  1.601624824757987e-01, -1.357406580941924e-03,  1.150425739482893e-05, -9.749909788807942e-08,  8.261899686674562e-10, -6.993479804639348e-12,
  5.881258337546133e-14, -4.780433108628223e-16,  3.277812900682653e-18, -2.529342412384557e-21, -6.911651131782654e-22,  2.320571223109805e-23,  2.578423361589868e-01,
 -2.185261350124062e-03,  1.852046952666232e-05, -1.569616563232883e-07,  1.330051951668359e-09, -1.125765632044920e-11,  9.462411804688373e-14, -7.668612975809066e-16,
  5.164752004834823e-18, -7.228577632002951e-23, -1.237622990763824e-21,  4.078758868550355e-23,  3.870787232855338e-01, -3.280563547004621e-03,  2.780334283619733e-05,
 -2.356339944840767e-07,  1.996670612769209e-09, -1.689793257465231e-11,  1.419197805039797e-13, -1.144873902521907e-15,  7.490851468548161e-18,  9.324573966145209e-21,
 -2.155033210837703e-21,  6.946631019141439e-23,  5.593824134796911e-01, -4.740869048320991e-03,  4.017967706664181e-05, -3.405228910580195e-07,  2.885386696879235e-09,
 -2.441432182560169e-11,  2.047755151471557e-13, -1.639051661334476e-15,  1.018058463343385e-17,  3.690179387645225e-20, -3.861975838617828e-21,  1.214434314814810e-22,
  8.045224804905852e-01, -6.818476181184575e-03,  5.778773324775100e-05, -4.897488759063643e-07,  4.149633750182569e-09, -3.509749386666502e-11,  2.935812675019425e-13,
 -2.311261381119417e-15,  1.268317615179509e-17,  1.257857962297660e-19, -7.933742240026455e-21,  2.436983673951805e-22,  9.267922421304272e-03, -7.597168065189630e-05,
  6.227603389326700e-07, -5.104913441536639e-09,  4.184447145265473e-11, -3.428848412409423e-13,  2.803879838387464e-15, -2.267106886533309e-17,  1.735783371401278e-19,
 -1.007074457669470e-21, -4.036715492386911e-24,  3.504577455898347e-25,  3.737793441607722e-02, -3.063970938871799e-04,  2.511619533822320e-06, -2.058833658079083e-08,
  1.687604442064335e-10, -1.382860367997022e-12,  1.130764332864704e-14, -9.140777206255285e-17,  6.989744815898390e-19, -4.022326138693733e-21, -1.754098822164617e-23,
  1.449203966806964e-24,  8.530736020318956e-02, -6.992876319024458e-04,  5.732249086153811e-06, -4.698858965132993e-08,  3.851600819512778e-10, -3.156054100429044e-12,
  2.580520419466331e-14, -2.085148293039159e-16,  1.590881751183449e-18, -9.019797857865092e-21, -4.519292832783359e-23,  3.454287051679381e-24,  1.549098181820430e-01,
 -1.269837908376240e-03,  1.040920325783219e-05, -8.532666389024415e-08,  6.994115312826671e-10, -5.730980837209705e-12,  4.685367311200794e-14, -3.783465749510285e-16,
  2.876433588957922e-18, -1.592229869971792e-20, -9.680878227997792e-23,  6.693523883493392e-24,  2.493861783318923e-01, -2.044286324154509e-03,  1.675756513279730e-05,
 -1.373656275653470e-07,  1.125964877513754e-09, -9.225937575118830e-12,  7.541412770441867e-14, -6.083737452562872e-16,  4.600363029149609e-18, -2.451523568981651e-20,
 -1.920914823882614e-22,  1.181581213063230e-23,  3.743841487083169e-01, -3.068928676290053e-03,  2.515683350636218e-05, -2.062162832208504e-07,  1.690315683523255e-09,
 -1.384960791844000e-11,  1.131797190106245e-13, -9.116446766337164e-16,  6.835707446374840e-18, -3.419197660260040e-20, -3.736096559490119e-22,  2.020389587497211e-23,
  5.410369935360857e-01, -4.435027355038772e-03,  3.635510999214904e-05, -2.980109025562285e-07,  2.442721312632670e-09, -2.001323741100591e-11,  1.634801775146127e-13,
 -1.313468542353591e-15,  9.707931996180136e-18, -4.302894508810891e-20, -7.506222300254916e-22,  3.537099675153294e-23,  7.781374847112704e-01, -6.378604527594202e-03,
  5.228712926432430e-05, -4.286086473894528e-07,  3.513149673622784e-09, -2.877983250157911e-11,  2.348922568214152e-13, -1.877466780804297e-15,  1.345733946398339e-17,
 -4.265442245215014e-20, -1.727501837200194e-21,  7.031358683500019e-23,  8.973627300503191e-03, -7.122375054705469e-05,  5.653034230020247e-07, -4.486812184791495e-09,
  3.561138743432571e-11, -2.826155461582207e-13,  2.241319989216273e-15, -1.770465107257193e-17,  1.371008229363878e-19, -9.680128387575783e-22,  3.980709588040733e-24,
  6.891422757609404e-26,  3.619102938786812e-02, -2.872484852227145e-04,  2.279893301109292e-06, -1.809550843529779e-08,  1.436222437615304e-10, -1.139798554194569e-12,
  9.039209082703637e-15, -7.139705255985146e-17,  5.526510169573170e-19, -3.893422117298096e-21,  1.570221735114113e-23,  2.883143826831205e-25,  8.259849636874489e-02,
 -6.555849160032187e-04,  5.203382200399990e-06, -4.129923249014917e-08,  3.277877689285425e-10, -2.601344016376427e-12,  2.062957866904346e-14, -1.629221920027567e-16,
  1.260160923645211e-18, -8.842658496436053e-21,  3.439947348376839e-23,  7.004670018325437e-25,  1.499907865424453e-01, -1.190478053536619e-03,  9.448832854487155e-06,
 -7.499536081340154e-08,  5.952301545005967e-10, -4.723760574691370e-12,  3.745978469694615e-14, -2.957752137434167e-16,  2.285071722908920e-18, -1.593457835335107e-20,
  5.837474866843145e-23,  1.393141058685944e-24,  2.414671289426009e-01, -1.916526502861277e-03,  1.521148453264741e-05, -1.207335027459350e-07,  9.582481110965252e-10,
 -7.604624920285717e-12,  6.030210537441718e-14, -4.759799043000452e-16,  3.670791774949520e-18, -2.535385799408379e-20,  8.398105774322451e-23,  2.540098943871850e-24,
  3.624958933857468e-01, -2.877132757848028e-03,  2.283582306678512e-05, -1.812478326391527e-07,  1.438541707951282e-09, -1.141609428126684e-11,  9.051856083256041e-14,
 -7.141329869280244e-16,  5.492476106115598e-18, -3.736948758351950e-20,  1.027868250413739e-22,  4.510575109759746e-24,  5.238568166176069e-01, -4.157855672927273e-03,
  3.300092952232481e-05, -2.619281939046840e-07,  2.078887658446141e-09, -1.649751080397948e-11,  1.307922538090253e-13, -1.031026953620721e-15,  7.893857430340717e-18,
 -5.233430673632528e-20,  9.184579221325525e-23,  8.234217291728054e-24,  7.534283801893306e-01, -5.979966972436791e-03,  4.746303858345326e-05, -3.767137461499833e-07,
  2.989913211171845e-09, -2.372635687284932e-11,  1.880544885735488e-13, -1.480019837572746e-15,  1.122726815462585e-17, -7.036433424992368e-20, -3.731064444013080e-23,
  1.707081752382375e-23  };
  constexpr double w[3072] = {  1.011507212876448e-02, -5.455332189787776e-04,  2.091056011420700e-05, -6.871051570254378e-07,  2.048475398197481e-08,
 -5.686109216277269e-10,  1.491429995484687e-11, -3.732376936312328e-13,  8.972145070125750e-15, -2.082049402203843e-16,  4.681702122809855e-18, -1.022625752159996e-19,
  3.481787833672718e-02, -3.116933547340388e-03,  1.899381548371138e-04, -9.387023256639148e-06,  4.023790696582338e-07, -1.549685332578906e-08,  5.477880457458068e-10,
 -1.802488788040552e-11,  5.576276629924034e-13, -1.633863047099511e-14,  4.559540098725965e-16, -1.216455779339604e-17,  6.151706931638347e-02, -8.882809945607955e-03,
  7.924253224369432e-04, -5.415623816395341e-05,  3.086180047545673e-06, -1.532924385096482e-07,  6.817622035422742e-09, -2.764016420975663e-10,  1.034577568359451e-11,
 -3.609082995861985e-13,  1.181924617118666e-14, -3.651512650484762e-16,  7.903090735534658e-02, -1.671216932499899e-02,  2.028874671696467e-03, -1.804344508879912e-04,
  1.295033961749256e-05, -7.896025822498391e-07,  4.220441541528993e-08, -2.019745334918910e-09,  8.785598842063211e-11, -3.512958645214305e-12,  1.302516843889382e-13,
 -4.504807105493062e-15,  8.233721022759218e-02, -2.315382298322853e-02,  3.582657982719383e-03, -3.930422152523762e-04,  3.391869881999669e-05, -2.435267631502044e-06,
  1.506202556080884e-07, -8.216795874395808e-09,  4.021492920362927e-10, -1.788521294886524e-11,  7.300416611651543e-13, -2.753628115366207e-14,  7.188802851044104e-02,
 -2.470975327840411e-02,  4.581146383514187e-03, -5.892502544523860e-04,  5.851785649753456e-05, -4.758885334603943e-06,  3.288925188332699e-07, -1.981394188604095e-08,
  1.059918227503455e-09, -5.105470538716217e-11,  2.238832140724852e-12, -9.005313195814636e-14,  5.082229978923478e-02, -1.987799353253026e-02,  4.164937246211919e-03,
 -5.976741234397677e-04,  6.541520496371565e-05, -5.799903246279944e-06,  4.328860916099690e-07, -2.793040148320823e-08,  1.588462622654152e-09, -8.081946413808982e-11,
  3.721922116122940e-12, -1.563964346517233e-13,  2.303689281132980e-02, -9.644954628150258e-03,  2.160577486802108e-03, -3.294036974734038e-04,  3.805683871962375e-05,
 -3.540678229080662e-06,  2.758356592820437e-07, -1.848954517397972e-08,  1.087909753154454e-09, -5.705549980546262e-11,  2.699549687057672e-12, -1.161984815323950e-13,
  8.222155029067217e-03, -4.064114108319395e-04,  1.431107498355215e-05, -4.339256607063594e-07,  1.198783742534370e-08, -3.094542373818832e-10,  7.570815652613849e-12,
 -1.771684982899781e-13,  3.991376835189274e-15, -8.697927545602744e-17,  1.840031092386177e-18, -3.787970147206106e-20,  2.480415683740238e-02, -1.958198161300418e-03,
  1.076136306140310e-04, -4.855361129411552e-06,  1.915323157945323e-07, -6.829358104130963e-09,  2.245957881659545e-10, -6.904224751003758e-12,  2.002689423880287e-13,
 -5.519735383837610e-15,  1.453233408597264e-16, -3.667982106226543e-18,  3.548620981633051e-02, -4.489492420556287e-03,  3.605979785115950e-04, -2.249919879299077e-05,
  1.181863033761787e-06, -5.451241949981867e-08,  2.264843194725644e-09, -8.621303540070659e-11,  3.043182511365143e-12, -1.005034088649631e-13,  3.126857048038098e-15,
 -9.207315016955902e-17,  3.467837533819863e-02, -6.538717175748569e-03,  7.225742300680901e-04, -5.925021020024173e-05,  3.958064406204677e-06, -2.262807341415021e-07,
  1.140939140466893e-08, -5.177118536345917e-10,  2.144712678025456e-11, -8.199042647791057e-13,  2.916527293451699e-14, -9.707964674818930e-16,  2.655291210578172e-02,
 -6.861837371285206e-03,  9.871687189630931e-04, -1.016614964022437e-04,  8.298096429003828e-06, -5.669920442810475e-07,  3.354484195132892e-08, -1.758099979466145e-09,
  8.297652575874473e-11, -3.570357339085317e-12,  1.414068714429734e-13, -5.188885381633997e-15,  1.712890335796625e-02, -5.591750109490540e-03,  9.892414900144059e-04,
 -1.221031875306502e-04,  1.169324665238543e-05, -9.207893225092387e-07,  6.183495500613763e-08, -3.630565131946917e-09,  1.897670398525505e-10, -8.951721883936769e-12,
  3.851875382256753e-13, -1.523009794617937e-14,  9.421144616186950e-03, -3.597464034500317e-03,  7.366645440090089e-04, -1.035632636551164e-04,  1.112994868081119e-05,
 -9.709142224411409e-07,  7.142239910902464e-08, -4.548746564603306e-09,  2.556890894230867e-10, -1.287259499602182e-11,  5.871721351645581e-13, -2.446037621030501e-14,
  3.652293435399619e-03, -1.518109698411111e-03,  3.376011061073774e-04, -5.112428050989552e-05,  5.870159567414888e-06, -5.430722425493263e-07,  4.209071547631360e-08,
 -2.808107672110157e-09,  1.645119521634826e-10, -8.593416126959941e-12,  4.050921710992504e-13, -1.737710444725493e-14,  6.796563124636524e-03, -3.099042155358631e-04,
  1.007848346488557e-05, -2.832202138434036e-07,  7.277863625212046e-09, -1.753061925312073e-10,  4.012627295712062e-12, -8.805446581075150e-14,  1.863886247938173e-15,
 -3.823231354841411e-17,  7.625182486480256e-19, -1.482325230818339e-20,  1.838609085746426e-02, -1.287008029966847e-03,  6.402504697652462e-05, -2.645379485908255e-06,
  9.627724444130157e-08, -3.184831558766820e-09,  9.760685449533881e-11, -2.806821075108014e-12,  7.641419297717586e-14, -1.982556758805104e-15,  4.926729250188234e-17,
 -1.176708098190691e-18,  2.195247196192425e-02, -2.430271730491482e-03,  1.758100902559549e-04, -1.001645984541496e-05,  4.849406869998947e-07, -2.076221106539203e-08,
  8.053196494227492e-10, -2.875795886720624e-11,  9.562946217339404e-13, -2.986331034545172e-14,  8.814785715708654e-16, -2.470218995390778e-17,  1.674559499157828e-02,
 -2.792638559859136e-03,  2.796569482324049e-04, -2.106558545239412e-05,  1.305409281682881e-06, -6.975517635265782e-08,  3.307750826075359e-09, -1.418912340580244e-10,
  5.581890523265742e-12, -2.034379824531269e-13,  6.923366144523124e-15, -2.211895535930176e-16,  9.501915179722355e-03, -2.230277438236837e-03,  2.959055498360570e-04,
 -2.841728760861802e-05,  2.181501823051964e-06, -1.411390442498175e-07,  7.950907187020490e-09, -3.986648062084094e-10,  1.807426728168765e-11, -7.497251926517323e-13,
  2.871501760644994e-14, -1.021880217023194e-15,  4.452746382717664e-03, -1.366037130645092e-03,  2.286888601146549e-04, -2.690149538670150e-05,  2.469773760254866e-06,
 -1.873616351387224e-07,  1.217127599387697e-08, -6.937043161377238e-10,  3.530398395434270e-11, -1.625719960748191e-12,  6.844477641125083e-14, -2.653341878934336e-15,
  1.838062945848763e-03, -6.810864237741207e-04,  1.355915090783640e-04, -1.859169638817136e-05,  1.954503689023909e-06, -1.672083023274413e-07,  1.208895518563599e-08,
 -7.581106480279056e-10,  4.202784557181675e-11, -2.089680791784143e-12,  9.425308610470316e-14, -3.886709458393122e-15,  5.892000451571887e-04, -2.427338457652114e-04,
  5.350288539306167e-05, -8.036507559161476e-06,  9.159895048553875e-07, -8.417871104858967e-08,  6.484898448764666e-09, -4.302669148888941e-10,  2.508044179540015e-11,
 -1.304062609021744e-12,  6.121268175034457e-14, -2.615568671395207e-15,  5.699158922504047e-03, -2.411275298248650e-04,  7.277732682853429e-06, -1.903223870477615e-07,
  4.565174492968268e-09, -1.029386367952967e-10,  2.210808188175833e-12, -4.561764531516503e-14,  9.094710808457196e-16, -1.760125881701739e-17,  3.316455402090480e-19,
 -6.099125474228291e-21,  1.409289962790361e-02, -8.797275232399997e-04,  3.977076026071410e-05, -1.509715490174709e-06,  5.083108519825521e-08, -1.563537889005728e-09,
  4.474047578029595e-11, -1.205427782373778e-12,  3.084039300421644e-14, -7.539895445557161e-16,  1.769937266241166e-17, -4.002499756370738e-19,  1.443489869691998e-02,
 -1.398557537119638e-03,  9.124357380055395e-05, -4.751480159789377e-06,  2.121480997052528e-07, -8.433274945850602e-09,  3.053743293120031e-10, -1.022719926060325e-11,
  3.202227972012101e-13, -9.449095738610764e-15,  2.643833816455392e-16, -7.043880622724741e-18,  8.838637926364301e-03, -1.294948313389167e-03,  1.171487449657361e-04,
 -8.085279634168246e-06,  4.636500405456040e-07, -2.310186353141144e-08,  1.027799425572611e-09, -4.158028905391951e-11,  1.549574076369194e-12, -5.371195702748199e-14,
  1.744574403060459e-15, -5.336732080076617e-17,  3.776927220833816e-03, -7.958439459455116e-04,  9.664831610471714e-05, -8.602852686240429e-06,  6.178382309093421e-07,
 -3.767048207509752e-08,  2.011894439660090e-09, -9.612147648673153e-11,  4.170421319028338e-12, -1.661775052190729e-13,  6.134560123880086e-15, -2.110578130520725e-16,
  1.274767175904451e-03, -3.630942940721408e-04,  5.699905917698117e-05, -6.342685913883934e-06,  5.547337382556805e-07, -4.032042493564000e-08,  2.521519431558048e-09,
 -1.389080709046409e-10,  6.856455182607999e-12, -3.071435943274391e-13,  1.261219101483850e-14, -4.779893356249545e-16,  3.813128769540362e-04, -1.360561411622338e-04,
  2.616278589239066e-05, -3.479916532003952e-06,  3.562298545062324e-07, -2.977063924942995e-08,  2.108297196479369e-09, -1.298040155854088e-10,  7.078825489495265e-12,
 -3.468254062646857e-13,  1.543740587398300e-14, -6.290425178229867e-16,  9.709551353775676e-05, -3.955669534471389e-05,  8.624165500427044e-06, -1.282635345513403e-06,
  1.448994822641091e-07, -1.321038058150044e-08,  1.010410360556283e-09, -6.660594180531600e-11,  3.859669476597124e-12, -1.996087183745745e-13,  9.323666349199653e-15,
 -3.966020343283120e-16,  4.838195985947544e-03, -1.909390915692666e-04,  5.372460840664189e-06, -1.312486887889752e-07,  2.948342541354690e-09, -6.242354961215217e-11,
  1.261312465268216e-12, -2.453757718021492e-14,  4.617881386513584e-16, -8.450954339873179e-18,  1.508391503760012e-19, -2.624994311055577e-21,  1.111238567497928e-02,
 -6.222490762083753e-04,  2.566386604404849e-05, -8.979911246396045e-07,  2.804943873554023e-08, -8.042013642909284e-10,  2.153013098282861e-11, -5.444495763163306e-13,
  1.310996072079739e-14, -3.024006200304135e-16,  6.712548673010934e-18, -1.438381922133326e-19,  1.000677394300971e-02, -8.496180056837589e-04,  5.009255366714113e-05,
 -2.388168656185341e-06,  9.845209600723296e-08, -3.636677152802564e-09,  1.229976420296268e-10, -3.864112433020207e-12,  1.139194873674813e-13, -3.175599430498530e-15,
  8.418892786934644e-17, -2.131217149223582e-18,  5.059469851602389e-03, -6.477692619282033e-04,  5.284922267028035e-05, -3.336880373047235e-06,  1.768038449881950e-07,
 -8.201165575518228e-09,  3.417452917290020e-10, -1.301546518563073e-11,  4.586391301229556e-13, -1.509023153407834e-14,  4.668550906915759e-16, -1.364651927624556e-17,
  1.664870564812927e-03, -3.114012518383632e-04,  3.438846467832950e-05, -2.822112831014437e-06,  1.887344392432589e-07, -1.079882723201892e-08,  5.446364344618129e-10,
 -2.470227891723915e-11,  1.022063246750987e-12, -3.899143209897940e-14,  1.382929830148912e-15, -4.585900932974645e-17,  4.051750812630925e-04, -1.057101350938147e-04,
  1.541193958282604e-05, -1.609796210499658e-06,  1.332482545856282e-07, -9.226451366534651e-09,  5.526515665194037e-10, -2.929334575595085e-11,  1.396625754810810e-12,
 -6.063468334013414e-14,  2.420175372231540e-15, -8.939219288405109e-17,  8.511645937469103e-05, -2.895926215846874e-05,  5.336324043462044e-06, -6.840634058186666e-07,
  6.781609891162453e-08, -5.510767925463363e-09,  3.807451717375902e-10, -2.293492212808794e-11,  1.226653367421537e-12, -5.906360011780917e-14,  2.588255778816205e-15,
 -1.039980342860231e-16,  1.642785404748949e-05, -6.598232074411632e-06,  1.419016535772135e-06, -2.084801692710620e-07,  2.329806195025609e-08, -2.103696284838773e-09,
  1.595249465590063e-10, -1.043495626478563e-11,  6.004879479865687e-13, -3.085992966649620e-14,  1.433212815320526e-15, -6.064695189099828e-17,  4.151443338071106e-03,
 -1.535426397895326e-04,  4.044072640270476e-06, -9.262501172888485e-08,  1.954507750638763e-09, -3.897129799254273e-11,  7.425632031966337e-13, -1.365659617845602e-14,
  2.432139227368358e-16, -4.209971182321002e-18,  7.163039357432819e-20, -1.177098536136441e-21,  8.975125316372521e-03, -4.534749241472719e-04,  1.712853140695292e-05,
 -5.542400978768906e-07,  1.610602417803879e-08, -4.314798346277465e-10,  1.083064976867099e-11, -2.575421904151134e-13,  5.846094299390181e-15, -1.274011991765866e-16,
  2.677565305540582e-18, -5.442129649862647e-20,  7.259920644076256e-03, -5.413730375613804e-04,  2.892004190412650e-05, -1.264945724822350e-06,  4.822688321143830e-08,
 -1.657389758046637e-09,  5.240443889286766e-11, -1.545323841188915e-12,  4.291260988413469e-14, -1.130248360802351e-15,  2.839008739851521e-17, -6.827200514498123e-19,
  3.114853985911763e-03, -3.471385901593364e-04,  2.553200670779696e-05, -1.473999608186580e-06,  7.211153367433474e-08, -3.111260727687811e-09,  1.213046374418267e-10,
 -4.344032535260582e-12,  1.445484226134214e-13, -4.507924231639543e-15,  1.326349521018417e-16, -3.698643328427895e-18,  8.104874705288265e-04, -1.331647702397389e-04,
  1.330251540439527e-05, -1.002154777253792e-06,  6.217193212003072e-08, -3.326383647639581e-09,  1.578915542888291e-10, -6.776290807507566e-12,  2.665322828285607e-13,
 -9.705536191475698e-15,  3.297542617258452e-16, -1.050950433403400e-17,  1.438217788738938e-04, -3.387210296554787e-05,  4.542389037366452e-06, -4.419290265731927e-07,
  3.439360314450497e-08, -2.255739064334559e-09,  1.287524396624615e-10, -6.535950239720253e-12,  2.997231708574292e-13, -1.256250026070010e-14,  4.856567730824806e-16,
 -1.742533999933571e-17,  2.071491063039079e-05, -6.638259607170962e-06,  1.161103226709899e-06, -1.423510613463263e-07,  1.358001860152225e-08, -1.067212415015675e-09,
  7.160301558237504e-11, -4.202873390656048e-12,  2.196783651703717e-13, -1.036292741295664e-14,  4.458599236983092e-16, -1.762256974621015e-17,  2.872946608019883e-06,
 -1.132830056240454e-06,  2.394386227740056e-07, -3.464492915139687e-08,  3.820182155844255e-09, -3.409069810933105e-10,  2.558345047439925e-11, -1.658044882337739e-12,
  9.462539497827111e-14, -4.826780366167811e-15,  2.226607464101686e-16, -9.364581048272510e-18,  3.595618080203187e-03, -1.251579653901958e-04,  3.097300071077977e-06,
 -6.673579867334484e-08,  1.326339424718008e-09, -2.498144708001817e-11,  4.497800493480025e-13, -7.832946493506789e-15,  1.328360691603677e-16, -2.159466790475530e-18,
  3.536288676239434e-20, -5.568003596233113e-22,  7.398582286235219e-03, -3.392442475496245e-04,  1.177891152237395e-05, -3.535766323294007e-07,  9.585307252803281e-09,
 -2.405390392500348e-10,  5.673133736845432e-12, -1.270916211016962e-13,  2.724590135957192e-15, -5.616983091475001e-17,  1.119288297488751e-18, -2.160728331516791e-20,
  5.476692985762725e-03, -3.597508121875797e-04,  1.746356182939100e-05, -7.024969744811541e-07,  2.481824381237240e-08, -7.947434586640095e-10,  2.352119424121763e-11,
 -6.516591044822959e-13,  1.705669879149401e-14, -4.246959110276667e-16,  1.010976123651411e-17, -2.309710797264452e-19,  2.045326597210858e-03, -1.978944491516575e-04,
  1.313174976540599e-05, -6.934016218428820e-07,  3.132391836350345e-08, -1.256787241281851e-09,  4.582789409787474e-11, -1.542153921096558e-12,  4.841718142197728e-14,
 -1.429832997691552e-15,  3.996502034791647e-17, -1.061881692618556e-18,  4.330770262396425e-04, -6.191765532353689e-05,  5.574654822537485e-06, -3.842961000315432e-07,
  2.205195334580556e-08, -1.100177946801963e-09,  4.901371020152841e-11, -1.985088545890066e-12,  7.402736654217666e-14, -2.566203401146804e-15,  8.330397581323362e-17,
 -2.545098504128791e-18,  5.718539541976610e-05, -1.197342453506404e-05,  1.463525947343322e-06, -1.316592005191798e-07,  9.574316890830807e-09, -5.915087067689713e-10,
  3.201185934951214e-11, -1.549230784848795e-12,  6.804532098041771e-14, -2.742665848144929e-15,  1.023240566054343e-16, -3.554370173575720e-18,  5.573456023575132e-06,
 -1.656980766540683e-06,  2.720815245866259e-07, -3.162334259518153e-08,  2.881998545679959e-09, -2.176909897764187e-10,  1.410835779329329e-11, -8.032295795701535e-13,
  4.086383789613783e-14, -1.881828237932854e-15,  7.924082529075624e-17, -3.072205728238286e-18,  5.240038383724733e-07, -2.016415277229997e-07,  4.167914670732874e-08,
 -5.915296087933148e-09,  6.414604934445025e-10, -5.641760415968867e-11,  4.180342670297059e-12, -2.679005079826418e-13,  1.513755026692294e-14, -7.653118429102066e-16,
  3.502289663527760e-17, -1.462415221170724e-18,  3.139934737593190e-03, -1.032566181425844e-04,  2.409026409539168e-06, -4.899164683094304e-08,  9.191022517710700e-10,
 -1.640140471314525e-11,  2.799800392474372e-13, -4.594931752735208e-15,  7.554797428698806e-17, -1.140147865567750e-18,  1.751641178260065e-20, -2.909432320594782e-22,
  6.206448762842258e-03, -2.597003484287203e-04,  8.318463044268158e-06, -2.323540799623604e-07,  5.891816390650474e-09, -1.388344550841450e-10,  3.083496734637152e-12,
 -6.518391988529138e-14,  1.322700409143267e-15, -2.582937677963938e-17,  4.884152121650044e-19, -8.978042272686156e-21,  4.271872674127979e-03, -2.480471960887284e-04,
  1.097634654537800e-05, -4.071435039958296e-07,  1.335808473415129e-08, -3.992753573661496e-10,  1.107703512431238e-11, -2.887055690840167e-13,  7.128023387737315e-15,
 -1.679328319620439e-16,  3.790867385628371e-18, -8.228436826192811e-20,  1.421081342932026e-03, -1.191876092979053e-04,  7.148451592903838e-06, -3.455931097028399e-07,
  1.442619065683453e-08, -5.384415135530232e-10,  1.836419897739520e-11, -5.806422741337141e-13,  1.719320454933183e-14, -4.805647627892355e-16,  1.275173557077795e-17,
 -3.225487855825188e-19,  2.520857662563967e-04, -3.110299715517655e-05,  2.518962922198032e-06, -1.585654967884255e-07,  8.399783629951541e-09, -3.899912278862756e-10,
  1.627380517465830e-11, -6.206866457006687e-13,  2.189788889166680e-14, -7.210761268311507e-16,  2.231502100122107e-17, -6.520946000190590e-19,  2.546298852493749e-05,
 -4.667127147164606e-06,  5.158444352474332e-07, -4.263104349009512e-08,  2.880640287558586e-09, -1.668010908996228e-10,  8.519661694959192e-12, -3.913907504518940e-13,
  1.639879934309323e-14, -6.332271044285868e-16,  2.271774767746568e-17, -7.614170417863618e-19,  1.680389521294354e-06, -4.551230553675364e-07,  6.929962021384529e-08,
 -7.562288439903806e-09,  6.531547682366877e-10, -4.709893890161552e-11,  2.931255674132397e-12, -1.610405564207412e-13,  7.938283131886244e-15, -3.554418328139189e-16,
  1.459608181741590e-17, -5.533256917011505e-19,  1.008825559420670e-07, -3.756461047602782e-08,  7.541861030117877e-09, -1.044257553140824e-09,  1.108819811329882e-10,
 -9.577444574096381e-12,  6.986084720991846e-13, -4.416096566534084e-14,  2.465323820552813e-15, -1.233120052426054e-16,  5.589472323507125e-18, -2.314082584871748e-19,
  2.762052134348537e-03, -8.610876701441083e-05,  1.899609507469354e-06, -3.658441329973805e-08,  6.491147207768355e-10, -1.098626040794743e-11,  1.798292588208826e-13,
 -2.721282089502439e-15,  4.442483566306647e-17, -6.533689778909612e-19,  7.714997799546874e-21, -1.666730168367836e-22,  5.285097627072004e-03, -2.028907367688469e-04,
  6.015712386825635e-06, -1.568219685578511e-07,  3.728837869125240e-09, -8.269074008816594e-11,  1.734118887553486e-12, -3.462064035937870e-14,  6.666092259978519e-16,
 -1.236469059535223e-17,  2.213769310286272e-19, -3.892865976762317e-21,  3.428795444422779e-03, -1.766709493183640e-04,  7.149737048527022e-06, -2.452010056721108e-07,
  7.489100346146794e-09, -2.093483186699840e-10,  5.451578715795628e-12, -1.339248505511536e-13,  3.121005635761890e-15, -6.962401045488145e-17,  1.493254956693815e-18,
 -3.077524748077563e-20,  1.037068878031257e-03, -7.535091095355025e-05,  4.095650402761600e-06, -1.815618852039585e-07,  7.012254632437453e-09, -2.436748156055794e-10,
  7.776368838720401e-12, -2.311428864160216e-13,  6.454444539013579e-15, -1.707192103133821e-16,  4.300292550176525e-18, -1.034794373330605e-19,  1.585139073408129e-04,
 -1.675707009651475e-05,  1.220620323898037e-06, -7.008697381448394e-08,  3.424051775975190e-09, -1.477672928213040e-10,  5.767476879388766e-12, -2.068563516175461e-13,
  6.892997884780848e-15, -2.152417755947068e-16,  6.339038263444823e-18, -1.768477512234379e-19,  1.265253848268558e-05, -1.999431301719870e-06,  1.986140096013784e-07,
 -1.499749141424424e-08,  9.372581765736375e-10, -5.064654481576563e-11,  2.431523190083827e-12, -1.056269839967268e-13,  4.206222032806700e-15, -1.550524225932155e-16,
  5.331103095280424e-18, -1.718466858278488e-19,  5.743805969416794e-07, -1.387550403973708e-07,  1.934025962437206e-08, -1.961493220328918e-09,  1.592149031187605e-10,
 -1.088200528948284e-11,  6.463058787453979e-13, -3.407512017491875e-14,  1.619514361072111e-15, -7.019687775728617e-17,  2.800074841552060e-18, -1.034227973793425e-19,
  2.083164767079568e-08, -7.414114000277116e-09,  1.432503592208532e-09, -1.921240138244366e-10,  1.986193947433483e-11, -1.677064738446254e-12,  1.199694931505131e-13,
 -7.456635655313879e-15,  4.101784849714744e-16, -2.025200701252875e-17,  9.074905407771766e-19, -3.718896283345361e-20,  2.445459421804366e-03, -7.250667698240725e-05,
  1.516355829073952e-06, -2.774515862235588e-08,  4.671213515186183e-10, -7.443997563027949e-12,  1.203493592899723e-13, -1.629154504701824e-15,  2.494315856863346e-17,
 -4.637012994917444e-19,  2.468614867932625e-21, -6.935485180180575e-23,  4.559150471590749e-03, -1.613907235426760e-04,  4.443759675487117e-06, -1.084207385971057e-07,
  2.423602743429198e-09, -5.065153318380720e-11,  1.006951049762651e-12, -1.898862565207041e-14,  3.468076534630041e-16, -6.171507171963794e-18,  1.037364260006711e-19,
 -1.745500178269831e-21,  2.820379779041444e-03, -1.294832867197825e-04,  4.808083868582345e-06, -1.528602731651524e-07,  4.356583312696313e-09, -1.141846073538055e-10,
  2.792147450985027e-12, -6.483549198753070e-14,  1.428630643378415e-15, -3.010659318165438e-17,  6.166674721099328e-19, -1.207461580685028e-20,  7.896727581980400e-04,
 -4.970728989403642e-05,  2.456966441592889e-06, -1.000565799113109e-07,  3.581084305052149e-09, -1.160469560344530e-10,  3.465559867314798e-12, -9.696481270136633e-14,
  2.554762194940025e-15, -6.389166514705155e-17,  1.529551209881642e-18, -3.500271560501229e-20,  1.067591295043932e-04, -9.608913120429335e-06,  6.306494300046446e-07,
 -3.302204584212777e-08,  1.487524354028563e-09, -5.965161380393619e-11,  2.175620941488717e-12, -7.332581245111189e-14,  2.305414119127059e-15, -6.817306467451638e-17,
  1.908459555083495e-18, -5.075477097603157e-20,  6.972199175489660e-06, -9.359205432813453e-07,  8.325642785618791e-08, -5.720079939095428e-09,  3.294283517987149e-10,
 -1.655596386338435e-11,  7.445790882977870e-13, -3.048631019569377e-14,  1.150121297925385e-15, -4.034582815311799e-17,  1.325383433323092e-18, -4.096658804983646e-20,
  2.244057487907519e-07, -4.721063983005835e-08,  5.949410519202373e-09, -5.551845948023940e-10,  4.200036628676989e-11, -2.701305405629700e-12,  1.521296023454471e-13,
 -7.653315911629047e-15,  3.489126816391450e-16, -1.457192732106609e-17,  5.622335926020054e-19, -2.015572483130395e-20,  4.711565566092681e-09, -1.574270329906155e-09,
  2.890867608208976e-10, -3.720264423443865e-11,  3.717018460190292e-12, -3.049924133820273e-13,  2.129333257781748e-14, -1.296105655248081e-15,  7.001721121379714e-17,
 -3.402743600675288e-18,  1.503694865059695e-19, -6.086876203936268e-21,  2.177751429456491e-03, -6.159090731101019e-05,  1.223814002019063e-06, -2.131939965708101e-08,
  3.438331246672358e-10, -5.027666801567235e-12,  8.350967223118433e-14, -1.082845724369733e-15,  9.621471790130322e-18, -3.888513316596266e-19,  2.314624466764957e-21,
  7.367396057643676e-23,  3.977286665046423e-03, -1.304548952794598e-04,  3.345755184536827e-06, -7.659486033578058e-08,  1.614877611703790e-09, -3.179079932576829e-11,
  6.021859285297266e-13, -1.077345950328012e-14,  1.840133953479136e-16, -3.218167490758864e-18,  5.097033155947360e-20, -7.686321788360833e-22,  2.369229159193496e-03,
 -9.732355061672680e-05,  3.326937047314644e-06, -9.831914700376104e-08,  2.618954402010943e-09, -6.464571344002647e-11,  1.482591589231829e-12, -3.257431875022798e-14,
  6.851681351865446e-16, -1.349397728408051e-17,  2.644565664648623e-19, -5.038646258965050e-21,  6.237254421318726e-04, -3.403124166756489e-05,  1.535944930136690e-06,
 -5.758815001905552e-08,  1.912015943213187e-09, -5.798296790357134e-11,  1.618769075130012e-12, -4.267366641335826e-14,  1.065152365748073e-15, -2.508564029182133e-17,
  5.715239732553316e-19, -1.250269738940295e-20,  7.637547535142042e-05, -5.819351518922472e-06,  3.454063139438477e-07, -1.650159675914579e-08,  6.854190502818198e-10,
 -2.556982185992341e-11,  8.705896703299967e-13, -2.756538846924007e-14,  8.178742358017049e-16, -2.286502225050457e-17,  6.080913214264952e-19, -1.540873358653015e-20,
  4.225708022620827e-06, -4.748728121167264e-07,  3.781448459496804e-08, -2.356838640583684e-09,  1.247604810278538e-10, -5.818613289222067e-12,  2.444584193874781e-13,
 -9.409934701439846e-15,  3.354611148483075e-16, -1.116777494900614e-17,  3.496084185567397e-19, -1.033453429659736e-20,  1.005459106583738e-07, -1.794448666925484e-08,
  2.023517406282380e-09, -1.721373059082896e-10,  1.204336107317304e-11, -7.239519130933836e-13,  3.842103966814797e-14, -1.834002064524663e-15,  7.978961148929455e-17,
 -3.195586400435272e-18,  1.187414380181340e-19, -4.115027579103722e-21,  1.198452644144417e-09, -3.662470849996612e-10,  6.288701886659066e-11, -7.672049162802103e-12,
  7.339196638580242e-13, -5.808496910012874e-14,  3.933767925257751e-15, -2.333171039639304e-16,  1.232596400472374e-17, -5.875382011667833e-19,  2.552794258464311e-20,
 -1.018115483611979e-21,  1.949471337539194e-03, -5.273718761753152e-05,  9.979966648794224e-07, -1.652344024164809e-08,  2.609941357186814e-10, -3.364560125407878e-12,
  5.557559465394786e-14, -9.715744110154310e-16, -1.451999463957580e-18, -1.796177186989612e-19,  9.303832737432109e-21,  2.252158597310157e-22,  3.503740220148315e-03,
 -1.069698456342074e-04,  2.562952660457275e-06, -5.514993259596716e-08,  1.102183169651565e-09, -2.038724437416718e-11,  3.680257536116612e-13, -6.400680114774400e-15,
  9.830107501855548e-17, -1.685804359684373e-18,  2.921985572033586e-20, -2.771690354872856e-22,  2.026583962173737e-03, -7.480209521541030e-05,  2.361371935899116e-06,
 -6.509653331485435e-08,  1.619117990240063e-09, -3.791632835954878e-11,  8.167956756185763e-13, -1.675057057610962e-14,  3.456883270228992e-16, -6.366273801386237e-18,
  1.114327149125412e-19, -2.316787381900323e-21,  5.084320238651499e-04, -2.406403339287880e-05,  9.960458129691487e-07, -3.450857868817216e-08,  1.060940926588342e-09,
 -3.031908381138951e-11,  7.914829357841136e-13, -1.951707807951232e-14,  4.683036259041689e-16, -1.035900241895726e-17,  2.200840566065215e-19, -4.774555191307661e-21,
  5.759033302023467e-05, -3.694350343937741e-06,  1.993813609715497e-07, -8.708348540917800e-09,  3.330228838315902e-10, -1.160080303184917e-11,  3.685149705462219e-13,
 -1.093565940388818e-14,  3.073903622643567e-16, -8.109149174410048e-18,  2.041152849581443e-19, -4.956083503943105e-21,  2.790531923754903e-06, -2.586937392979773e-07,
  1.850074468934910e-08, -1.044592997188525e-09,  5.070086441710050e-11, -2.193544444568161e-12,  8.590858419801996e-14, -3.101769134242420e-15,  1.043565643651200e-16,
 -3.288800021157814e-18,  9.787768352580088e-20, -2.762569260970508e-21,  5.156050827755535e-08, -7.587554316125330e-09,  7.608721352139521e-10, -5.854112006129607e-11,
  3.762044092085377e-12, -2.101379947044121e-13,  1.044990453855026e-14, -4.708197902341437e-16,  1.945220489835962e-17, -7.436266415115813e-19,  2.649603718259154e-20,
 -8.840774339004172e-22,  3.535979930630285e-10, -9.521312627516276e-11,  1.498678718396883e-11, -1.707704066964722e-12,  1.546336686035516e-13, -1.169705661317699e-14,
  7.627312750121998e-16, -4.380962650585607e-17,  2.251699409992676e-18, -1.048149035156083e-19,  4.461117801162478e-21, -1.747425308117190e-22,  1.753328767865251e-03,
 -4.548003880232978e-05,  8.227593517173686e-07, -1.282278448557762e-08,  2.047959421728213e-10, -2.365378493110924e-12,  2.737082238153279e-14, -1.031019290570539e-15,
  1.004459983084792e-18,  3.632329609961963e-19,  1.588629773192025e-20, -5.135039795396075e-23,  3.113062654568838e-03, -8.884177680300004e-05,  1.994909498034552e-06,
 -4.035223786676392e-08,  7.698745321852301e-10, -1.339831486515491e-11,  2.252143347042513e-13, -4.019991077922609e-15,  5.633627442398241e-17, -6.988197527020711e-19,
  2.080549953006276e-20, -1.881244095657590e-22,  1.760763802905069e-03, -5.864677511877394e-05,  1.713687275976391e-06, -4.433157850133872e-08,  1.024491301679298e-09,
 -2.287684472616723e-11,  4.733092979129125e-13, -8.667012802454142e-15,  1.763173038571713e-16, -3.500044407371926e-18,  4.209136361811942e-20, -8.932838740555374e-22,
  4.258440663597241e-04, -1.750369472505930e-05,  6.666829237920556e-07, -2.151170873902419e-08,  6.077320367423322e-10, -1.648058369351207e-11,  4.088100595917552e-13,
 -9.143082154936122e-15,  2.131396283631919e-16, -4.707527762005968e-18,  8.368093096343745e-20, -1.814314172324554e-21,  4.544921863724259e-05, -2.441675280984289e-06,
  1.205085714334202e-07, -4.842651960991904e-09,  1.694238621253240e-10, -5.541735552900910e-12,  1.653065398805435e-13, -4.540790812920294e-15,  1.216676842707714e-16,
 -3.070645453080369e-18,  7.122534689217924e-20, -1.672416443640552e-21,  1.988219080731073e-06, -1.497671768225802e-07,  9.681111395909469e-09, -4.962371364730365e-10,
  2.198150374467571e-11, -8.838743637983964e-13,  3.227715875491791e-14, -1.088183226807576e-15,  3.457430711445334e-17, -1.031480901669846e-18,  2.901774526848016e-20,
 -7.827075906876713e-22,  3.004806071175003e-08, -3.536182065636110e-09,  3.152133262960720e-10, -2.181802894007882e-11,  1.279615342767472e-12, -6.614683602168867e-14,
  3.067722043576013e-15, -1.298099794335501e-16,  5.072481305072532e-18, -1.843029531162917e-19,  6.269603836034309e-21, -2.006869411841395e-22,  1.248638537958764e-10,
 -2.814647081398050e-11,  3.976292887175921e-12, -4.160449791673015e-13,  3.519211274465653e-14, -2.517588078640330e-15,  1.566776954933561e-16, -8.651177142137520e-18,
  4.299330498768715e-19, -1.944139009479509e-20,  8.069424570963319e-22, -3.092492202532253e-23,  1.583672365859564e-03, -3.946116443874774e-05,  6.870745712596041e-07,
 -9.898373131076124e-09,  1.618039392576103e-10, -2.035166859676943e-12,  1.698129425412730e-15, -6.856054263885224e-16,  2.278262444609929e-17,  7.080956508419339e-19,
 -5.038691374677908e-21, -8.879077445097219e-22,  2.786818299358225e-03, -7.462863577354760e-05,  1.576602728119285e-06, -2.991914655287076e-08,  5.478158971047819e-10,
 -9.158160393514390e-12,  1.351405673828169e-13, -2.479957666678229e-15,  4.342661401370105e-17, -1.179518140125575e-19,  5.626074043934568e-21, -5.270406560711502e-22,
  1.550578659779373e-03, -4.681766188958454e-05,  1.266759159092732e-06, -3.105524610997216e-08,  6.637302702223142e-10, -1.389824894915421e-11,  2.926685361347394e-13,
 -4.769202015658338e-15,  7.472978104168048e-17, -2.212209182813032e-18,  3.138769165205429e-20,  3.243113939898653e-22,  3.650655618954416e-04, -1.305945945917316e-05,
  4.575259028371295e-07, -1.396678254359273e-08,  3.588903754361592e-10, -9.107254203784052e-12,  2.266762238225245e-13, -4.511729998092598e-15,  8.955658844859734e-17,
 -2.434017139207095e-18,  4.130186367055256e-20, -2.674265002564344e-22,  3.729810225051089e-05, -1.671180165996056e-06,  7.560057469483139e-08, -2.839441069820915e-09,
  8.986613320136626e-11, -2.745661997791186e-12,  7.927610248908201e-14, -1.982972512066524e-15,  4.870117378287944e-17, -1.269077310368596e-18,  2.717896044917746e-20,
 -5.122177373399317e-22,  1.513294826027131e-06, -9.127235055695058e-08,  5.365758512389694e-09, -2.523459856401138e-10,  1.010764157972139e-11, -3.775345884561529e-13,
  1.299177368673766e-14, -4.054015933418581e-16,  1.207513215580318e-17, -3.467600325934702e-19,  9.143690763380073e-21, -2.302466685068492e-22,  1.967397445465550e-08,
 -1.793262752326056e-09,  1.428164599054982e-10, -8.897542894286460e-12,  4.724579225525311e-13, -2.254501975264593e-14,  9.735787686526080e-16, -3.846647469324695e-17,
  1.416362364982317e-18, -4.883035978037446e-20,  1.577347315401902e-21, -4.822339172669773e-23,  5.402917889219182e-11, -9.551961825184879e-12,  1.190211372156313e-12,
 -1.123902168888644e-13,  8.752232728330735e-15, -5.855179463409040e-16,  3.444027967522806e-17, -1.812712663472916e-18,  8.649212762605437e-20, -3.776356359948746e-21,
  1.520386988197894e-22, -5.675042619040698e-24,  1.436126666025913e-03, -3.439878359618842e-05,  5.824775697047358e-07, -7.637694938114945e-09,  1.204674702768665e-10,
 -2.122210827397591e-12, -4.200474240320029e-15,  3.327176368957651e-16,  3.494147683228882e-17, -2.703507052254371e-19, -3.903883249989511e-20, -2.145391592483573e-22,
  2.511448865904729e-03, -6.331580844402739e-05,  1.264631939289032e-06, -2.246400291691897e-08,  3.922586497219682e-10, -6.594572338128002e-12,  8.455181816002055e-14,
 -1.162526417446370e-15,  3.738165301820868e-17, -3.680445456501198e-19, -1.609539931454784e-20, -2.358095965181905e-22,  1.381445848904196e-03, -3.801256030944115e-05,
  9.497634736043414e-07, -2.231903371440069e-08,  4.463077549697547e-10, -8.270500294546625e-12,  1.825676561417429e-13, -3.374362279111396e-15,  2.207342604889130e-17,
 -6.012930761444546e-19,  4.651672673879323e-20, -4.146001222897286e-23,  3.192084094171725e-04, -9.984155089485287e-06,  3.192193047920389e-07, -9.424164574894635e-09,
  2.222854978997408e-10, -4.929003602535636e-12,  1.295034787755630e-13, -2.739045626624299e-15,  3.066703496285487e-17, -8.417083699669162e-19,  3.931166149160740e-20,
 -1.351066061818936e-22,  3.163694466174577e-05, -1.181809459506232e-06,  4.863215661274697e-08, -1.753696758468838e-09,  5.023712783931834e-11, -1.368826130435785e-12,
  3.999282558689177e-14, -9.799788549876060e-16,  1.858622962163117e-17, -4.847393154573126e-19,  1.449568439410786e-20, -1.717234365189495e-22,  1.218122579308657e-06,
 -5.818981467855445e-08,  3.104711674482484e-09, -1.372881449670092e-10,  4.940078735631713e-12, -1.677065375171307e-13,  5.582519360583078e-15, -1.638827402022843e-16,
  4.332920431867571e-18, -1.211792401873973e-19,  3.279560991315334e-21, -6.982360706698196e-23,  1.425456419456377e-08, -9.768298098252831e-10,  6.981772406508299e-11,
 -3.967148309698614e-12,  1.888591158594073e-13, -8.255740384143916e-15,  3.343262352326179e-16, -1.229715164696839e-17,  4.212083928260899e-19, -1.383321227880772e-20,
  4.266876401063640e-22, -1.221668419983223e-23,  2.879548499133741e-11, -3.709974738978598e-12,  4.043399708111225e-13, -3.403300598789751e-14,  2.400858885635591e-15,
 -1.485214310535910e-16,  8.183623701559459e-18, -4.067173465148159e-19,  1.848025139192934e-20, -7.743063379367274e-22,  3.005730615840264e-23, -1.086238740933026e-24,
  1.307312699031336e-03, -3.007604235591871e-05,  5.009853689365009e-07, -6.050025930930108e-09,  7.834587016802124e-11, -2.004411869314871e-12,  1.723581895669030e-14,
  1.013028509526027e-15,  5.642920399357169e-19, -1.395768885283422e-18, -3.273761499311134e-21,  1.588340202508170e-21,  2.276850737032886e-03, -5.417968389626750e-05,
  1.028700644946190e-06, -1.714157788355519e-08,  2.786529142781709e-10, -4.837592110956423e-12,  6.584946715662381e-14, -3.030423747887158e-16,  1.307842944446097e-17,
 -8.848227844934365e-19, -1.765561608085632e-21,  7.968992230914598e-22,  1.243052145013574e-03, -3.137554904488433e-05,  7.200086196330548e-07, -1.629414378700406e-08,
  3.174334525338784e-10, -4.950641669240635e-12,  9.711401848706515e-14, -2.688551486571957e-15,  2.895727391742904e-17,  7.304076633959271e-19,  9.119670702198594e-21,
 -1.448188169146387e-21,  2.837397741005299e-04, -7.828816113338872e-06,  2.246955971896812e-07, -6.511701623921694e-09,  1.490660988886097e-10, -2.648090983687491e-12,
  6.400743732728919e-14, -1.967678076100294e-15,  2.461674790856225e-17,  3.212405489420675e-19,  1.178514413503687e-20, -1.033889576821448e-21,  2.757146376914008e-05,
 -8.650489607999884e-07,  3.165310684343682e-08, -1.125054654174185e-09,  3.052858196900873e-11, -6.835597893347109e-13,  1.896661262316521e-14, -5.678731019783917e-16,
  9.642716448220376e-18, -7.112711835134682e-20,  5.518956093378528e-21, -2.480736757588885e-22,  1.026217027840719e-06, -3.881262562099787e-08,  1.840714676258450e-09,
 -7.912238843802899e-11,  2.620810056611551e-12, -7.637782306801396e-14,  2.429913144915173e-15, -7.471764777328839e-17,  1.736936581089685e-18, -3.653500790818209e-20,
  1.197507442476856e-21, -3.433800338724179e-23,  1.122177395845912e-08, -5.675451169898036e-10,  3.604105246388858e-11, -1.924939166841486e-12,  8.236968056274673e-14,
 -3.204645906498900e-15,  1.223947303151722e-16, -4.314411640112090e-18,  1.344680744650594e-19, -4.037746204092925e-21,  1.246099309915233e-22, -3.496623657477349e-24,
  1.853141750637785e-11, -1.627505864922530e-12,  1.546999811783065e-13, -1.164451537347414e-14,  7.322613960974101e-16, -4.125579235207446e-17,  2.118563359389025e-18,
 -9.879491077581942e-20,  4.224278861209499e-21, -1.684665784058649e-22,  6.293520186843954e-24, -2.189061187055535e-25,  1.194590801650166e-03, -2.634010524735859e-05,
  4.346813278977975e-07, -5.085618447538071e-09,  4.451282103893453e-11, -1.292330105253433e-12,  3.889245281116721e-14,  3.331181759210751e-16, -3.637928707907921e-17,
 -3.165865552876417e-19,  4.577147412484424e-20,  1.019570841895725e-22,  2.075386447922798e-03, -4.670388829965231e-05,  8.468310867345118e-07, -1.337368036747366e-08,
  1.971409724408915e-10, -3.339924687637047e-12,  5.874031043322227e-14, -3.390354416265765e-16, -1.176608825185390e-17, -3.058966351114629e-19,  2.546007126225770e-20,
  1.159733393033710e-22,  1.127944597021780e-03, -2.631807764616266e-05,  5.520305752613177e-07, -1.190407394525679e-08,  2.362740057549943e-10, -3.394747887595393e-12,
  3.856491903325708e-14, -1.389099698879024e-15,  4.772010307080102e-17,  6.837745073965442e-21, -3.507564178342186e-20, -1.194581759277048e-22,  2.555772625319790e-04,
 -6.306835833003936e-06,  1.593411525214539e-07, -4.483852394195630e-09,  1.075135242486914e-10, -1.672286090595195e-12,  2.182037016500030e-14, -9.903782824752732e-16,
  3.429455541898442e-17, -1.831054337536688e-20, -2.225729530944630e-20, -1.847464251943442e-22,  2.454273923776324e-05, -6.584256439684815e-07,  2.069885516363006e-08,
 -7.260327800955717e-10,  2.029546335695254e-11, -3.856617322869428e-13,  7.183978954995216e-15, -2.782997497851412e-16,  8.571717085839459e-18, -4.640279758682142e-20,
 -2.976321367205645e-21, -7.486109135127781e-23,  8.952801073829395e-07, -2.727054875474062e-08,  1.100998381119488e-09, -4.685244961277626e-11,  1.535259489201884e-12,
 -3.783682502381430e-14,  9.684848637867653e-16, -3.359087079119236e-17,  9.663089073124999e-19, -1.355894585859871e-20,  1.067869846470381e-22, -1.295060686810585e-23,
  9.408256686819436e-09, -3.532168310747027e-10,  1.915686234673971e-11, -9.939241597686026e-13,  3.991388789029899e-14, -1.336849199222200e-15,  4.538400952221306e-17,
 -1.618825167040774e-18,  5.019741827643856e-20, -1.245110755863373e-21,  3.205537667841127e-23, -1.094320306578312e-24,  1.382812544536896e-11, -7.981870239725848e-13,
  6.494649735435658e-14, -4.490156104065127e-15,  2.517892936181050e-16, -1.257275693700964e-17,  5.940220754971286e-19, -2.622391968095236e-20,  1.052863345988086e-21,
 -3.898067043892270e-23,  1.383012852382045e-24, -4.715921305380568e-26,  1.095813700700291e-03, -2.309628563176234e-05,  3.772413987861557e-07, -4.528680125036676e-09,
  2.807580169612706e-11, -3.769881173455948e-13,  3.257459051763187e-14, -6.918913556687974e-16, -1.972071938600953e-17,  9.843729084530956e-19,  9.115096491151934e-21,
 -1.246918404741095e-21,  1.901173404680656e-03, -4.052215233277163e-05,  7.033054161207195e-07, -1.068127073431968e-08,  1.434332767513128e-10, -2.089952838940000e-12,
  4.366585260065580e-14, -7.079934125667059e-16, -6.587250316479373e-18,  4.624844501484260e-19,  6.830767073244692e-21, -6.927460049119783e-22,  1.030684338363369e-03,
 -2.241384868001390e-05,  4.297575159300611e-07, -8.626770301387570e-09,  1.753427755435194e-10, -2.772418293608907e-12,  1.926925877795453e-14, -1.045967901788133e-16,
  2.653057377660637e-17, -9.749394903515754e-19, -5.428958008520755e-21,  1.022130853694455e-21,  2.325967251199156e-04, -5.220482822265369e-06,  1.148241527603515e-07,
 -3.010013372856974e-09,  7.767458595162257e-11, -1.364023529364337e-12,  8.163196422757876e-15, -6.610382234897532e-17,  1.936363388847062e-17, -6.838299301684165e-19,
 -4.321750823963413e-21,  7.020256466080171e-22,  2.219212365857243e-05, -5.227003371876717e-07,  1.370467732976823e-08, -4.557635339595613e-10,  1.382562503381618e-11,
 -2.781842841275976e-13,  2.805801739048791e-15, -5.486746564045423e-17,  4.749609968797175e-18, -1.487156599342688e-19, -6.213301108386390e-22,  1.258790401520204e-22,
  8.007754956739008e-07, -2.034454764027193e-08,  6.645377057458165e-10, -2.734185444220678e-11,  9.509632491281909e-13, -2.282612138671730e-14,  3.891532154008328e-16,
 -1.031363314722575e-17,  4.856953466480124e-19, -1.347804847798350e-20,  3.811264605245943e-23,  5.816134752051064e-24,  8.239413744970119e-09, -2.385261012672704e-10,
  1.033562777952932e-11, -5.226217124677937e-13,  2.118590960873106e-14, -6.445051932012664e-16,  1.714165189502364e-17, -5.532022281879719e-19,  2.028962574711017e-20,
 -5.632645137372501e-22,  9.065126015998780e-24, -1.303391943860644e-25,  1.140986360875546e-11, -4.407432264986493e-13,  2.890032761866503e-14, -1.893244175003191e-15,
  9.872034126053201e-17, -4.316525439783246e-18,  1.781004924642283e-19, -7.374096052655275e-21,  2.904248343851148e-22, -1.015599899104242e-23,  3.198508544759749e-25,
 -1.001649528273718e-26,  1.009130569778407e-03, -2.028842795308469e-05,  3.254611390315976e-07, -4.104753419396400e-09,  2.655640878019805e-11,  1.338556008725370e-13,
  9.639973591771896e-15, -7.787933068818504e-16,  1.135643638186388e-17,  5.270014130758918e-19, -2.284093736320161e-20, -6.819177536644076e-23,  1.749577219505029e-03,
 -3.537223743131581e-05,  5.876858359812555e-07, -8.670754625430235e-09,  1.104528897376239e-10, -1.287775458731807e-12,  2.345526238318104e-14, -6.525751659545685e-16,
  8.749414289255723e-18,  2.628800959587889e-19, -1.192378086726458e-20, -6.519291427943676e-23,  9.473114113229973e-04, -1.934623049628605e-05,  3.413213045528435e-07,
 -6.239429517834458e-09,  1.246409902960145e-10, -2.281115647835149e-12,  2.310532826877079e-14,  2.170118977407680e-16, -3.568689999493324e-18, -5.235998959919214e-19,
  2.035836335818311e-20,  3.764421500206399e-23,  2.133504010042461e-04, -4.427245937147568e-06,  8.529565317654832e-08, -1.974480412548100e-09,  5.246885671676771e-11,
 -1.142856867998099e-12,  1.136617443776204e-14,  1.796627136033187e-16, -2.092339179675671e-18, -3.825725923338054e-19,  1.425385561960107e-20,  4.387334840133272e-23,
  2.029073869546163e-05, -4.315796254934282e-07,  9.390203836807003e-09, -2.756805976092950e-10,  8.878860773888832e-12, -2.169707890441549e-13,  2.616725574816791e-15,
  1.651268027196179e-17,  1.114622899328234e-19, -8.505554298695702e-20,  2.890739306879323e-21,  9.743976592324433e-24,  7.282750425709354e-07, -1.611377029309246e-08,
  4.141021213346366e-10, -1.534329238343252e-11,  5.716994880594923e-13, -1.562077969709420e-14,  2.500363580268698e-16, -1.744616382795149e-18,  8.707217772288941e-20,
 -7.396185461897202e-21,  2.208466444776014e-22,  2.769895327226015e-25,  7.417960477508308e-09, -1.760203261182515e-10,  5.733358048288742e-12, -2.685787134678950e-13,
  1.146331044929779e-14, -3.620299160335790e-16,  8.151964200408070e-18, -1.648855388628571e-19,  5.814045442000311e-21, -2.529412860887843e-22,  6.878642050333534e-24,
 -5.453977061461145e-26,  9.996219771108772e-12, -2.789012092193437e-13,  1.340764620074866e-14, -8.270276845728330e-16,  4.266847058328537e-17, -1.736353386859478e-18,
  6.047078838103281e-20, -2.108528487724171e-21,  8.013488498875733e-23, -2.968614012086760e-24,  9.288562433444190e-26, -2.373351119157945e-27,  9.328828031013558e-04,
 -1.787429174661024e-05,  2.788644647259575e-07, -3.652375017188758e-09,  3.004499650223941e-11,  1.560222281760646e-13, -5.429960976050304e-15, -2.767635196524728e-16,
  1.566339088739567e-17, -1.927210025724510e-19, -9.505178841000571e-21,  4.397201841831430e-22,  1.616872314810777e-03, -3.105869072628215e-05,  4.934739760591200e-07,
 -7.084530215048938e-09,  8.903536120836236e-11, -9.069673317148653e-13,  9.887614665069024e-15, -3.088065991308490e-16,  1.039443491942967e-17, -1.229591292753231e-19,
 -5.165115722935214e-21,  2.405829951423805e-22,  8.749569816022059e-04, -1.688451316994521e-05,  2.770104543367925e-07, -4.578358186253167e-09,  8.493543818827450e-11,
 -1.678572025282730e-12,  2.581602528085798e-14, -5.264427400016960e-17, -9.428141085663623e-18,  1.144491293666365e-19,  8.573404926863974e-21, -3.773047466021118e-22,
  1.968740754200159e-04, -3.827017601374864e-06,  6.593669055951284e-08, -1.301565027911254e-09,  3.266800414124141e-11, -8.261682172839930e-13,  1.414259839402866e-14,
 -4.234553858103064e-18, -6.646167241578429e-18,  7.275201751764756e-20,  6.272559122119222e-21, -2.674079974370517e-22,  1.869671519522977e-05, -3.675825322838515e-07,
  6.802643165303320e-09, -1.647859966745302e-10,  5.197841468027527e-12, -1.502686787715922e-13,  2.822231422063303e-15, -7.818012911623361e-18, -1.065629504868438e-18,
  8.579928572574447e-21,  1.334367572736812e-21, -5.339545604515944e-23,  6.694703181951274e-07, -1.340362296970675e-08,  2.755747670973806e-10, -8.382886963869202e-12,
  3.161354281395838e-13, -1.007826395067624e-14,  2.117976856888126e-16, -1.620977718945744e-18, -3.637503210311947e-20, -2.749595519056368e-22,  1.055320482783244e-22,
 -3.794192029314929e-24,  6.788956271469319e-09, -1.404150188694448e-10,  3.402807324421727e-12, -1.337420747683522e-13,  5.884625959227751e-15, -2.074213734624286e-16,
  5.114730075950993e-18, -7.763250777821758e-20,  8.622105257432261e-22, -4.818791369819194e-23,  3.052647436833606e-24, -9.480933212888123e-26,  9.045732881705700e-12,
 -2.019406979410806e-13,  6.644306624674391e-15, -3.592026453473094e-16,  1.883005605005689e-17, -7.811730217451539e-19,  2.539081962278540e-20, -7.026709634695775e-22,
  2.063151320595927e-23, -7.553075775815329e-25,  2.838198769238372e-26, -8.565561158900980e-28,  8.655816676207470e-04, -1.581033592669257e-05,  2.379953586212062e-07,
 -3.155488871021854e-09,  3.149332173934184e-11, -1.882052607137012e-14, -7.529140539991211e-15,  7.367940871132309e-17,  5.865160944114675e-18, -2.655264366073800e-19,
  3.409921408868185e-21,  1.207490826807178e-22,  1.500027173985065e-03, -2.742804563565764e-05,  4.164436348915775e-07, -5.794511925224331e-09,  7.274191869244258e-11,
 -7.408773196145928e-13,  5.057700915138079e-15, -6.835978838587316e-17,  4.447620739297373e-18, -1.596056534440424e-19,  1.995699457606886e-21,  6.750954795797839e-23,
  8.115326620913578e-04, -1.486742576033832e-05,  2.292224435589296e-07, -3.455347113657032e-09,  5.728661624527823e-11, -1.105335472988296e-12,  2.103873660132354e-14,
 -2.510369928835613e-16, -2.549725151781455e-18,  1.938057403598120e-19, -2.514721317877240e-21, -1.053015067174327e-22,  1.825331107625073e-04, -3.354251268898063e-06,
  5.296744880728835e-08, -8.930508727223000e-10,  1.941991417866773e-11, -5.085775849968608e-13,  1.166384567860404e-14, -1.471269191353878e-16, -1.949396756591885e-18,
  1.350602334783571e-19, -1.691040878132590e-21, -7.717462113017455e-23,  1.732442781188801e-05, -3.198624300196916e-07,  5.236591171040300e-09, -1.021206657719087e-10,
  2.834365983440262e-12, -8.846744291467224e-14,  2.221381330471090e-15, -3.080171334353648e-17, -2.864921370991795e-19,  2.393695486643079e-20, -2.788455962487723e-22,
 -1.613780232512566e-23,  6.197312781417387e-07, -1.152902510553169e-08,  1.995244486447666e-10, -4.678748076629718e-12,  1.610882032683159e-13, -5.658858397996101e-15,
  1.526942805345678e-16, -2.422969255581663e-18, -5.314665946426945e-21,  1.224934942605363e-21, -1.068063463579649e-23, -1.221056967133358e-24,  6.273471062236363e-09,
 -1.182870016398860e-10,  2.245617733319094e-12, -6.680259348744933e-14,  2.799438032881812e-15, -1.085808869568316e-16,  3.191643451324312e-18, -6.147360670757441e-20,
  4.645165419963897e-22,  7.067975279921200e-24,  1.886436748248549e-25, -3.196046654943138e-26,  8.322880754252102e-12, -1.619071463103777e-13,  3.717618798726803e-15,
 -1.554046188419380e-16,  8.009081730533379e-18, -3.521468847576571e-19,  1.207402216505701e-20, -3.185634374647126e-22,  6.813786173932985e-24, -1.589096929916392e-25,
  5.871858511349874e-27, -2.455731639454076e-28,  8.059204135340919e-04, -1.404935806270798e-05,  2.031112360370323e-07, -2.663444465312188e-09,  2.955313854506372e-11,
 -1.612801708121915e-13, -4.051523586558542e-15,  1.403962602732894e-16, -6.552711826430689e-19, -9.531714397818367e-20,  3.823185242114917e-21, -5.612609098957364e-23,
  1.396564206053371e-03, -2.435593288496791e-05,  3.534238831025731e-07, -4.743009585822400e-09,  5.904608740916503e-11, -6.310443313806204e-13,  4.402474802406725e-15,
  5.834049835786563e-19,  4.627561765060267e-19, -6.111040644983138e-20,  2.209253913386157e-21, -3.208138657948337e-23,  7.554879042985642e-04, -1.318543505971225e-05,
  1.926103742859507e-07, -2.690661674530650e-09,  3.963653522502379e-11, -6.883687766206736e-13,  1.374557303028285e-14, -2.454600607850202e-16,  2.089947808096475e-18,
  6.187334847079917e-20, -2.998776172544200e-21,  4.468993632713406e-23,  1.699022666584082e-04, -2.968777411130317e-06,  4.382473914272770e-08, -6.499704485880522e-10,
  1.169456910798743e-11, -2.812121694164792e-13,  7.284868338594202e-15, -1.485239661383556e-16,  1.301278367490137e-18,  4.365008644497576e-20, -2.097059848974038e-21,
  3.109567737741866e-23,  1.612193536726890e-05, -2.822176949823917e-07,  4.233411186112393e-09, -6.833154595651279e-11,  1.525956817043794e-12, -4.584364095716358e-14,
  1.339648666010910e-15, -2.914440977402255e-17,  2.885317745580477e-19,  7.449172543861847e-21, -3.876079555946270e-22,  5.703059276043588e-24,  5.765039917787953e-07,
 -1.012101551397852e-08,  1.556912655486860e-10, -2.830575754482232e-12,  7.911911306180186e-14, -2.791561208391895e-15,  8.810589994219743e-17, -2.034619159366272e-18,
  2.409339459842098e-20,  3.430236826536759e-22, -2.229181021164106e-23,  3.164766111966291e-25,  5.832064007717255e-09, -1.029079123748843e-10,  1.653031266780999e-12,
 -3.577453348862280e-14,  1.264092327490542e-15, -5.072049853006386e-17,  1.715731028222607e-18, -4.292774563812123e-20,  6.491149087733748e-22,  3.854721616068698e-25,
 -2.710775179927096e-25,  2.879608824328336e-27,  7.725405512144300e-12, -1.378935718491310e-13,  2.432877393639618e-15, -7.050294179565821e-17,  3.250843502224920e-18,
 -1.488508903616464e-19,  5.575519451594392e-21, -1.623070670009711e-22,  3.532137609052258e-24, -5.536494138097823e-26,  8.250142284469735e-28, -3.282814980242449e-29,
  7.527813289957666e-04, -1.254454817500989e-05,  1.738669249512239e-07, -2.220419576807510e-09,  2.565131840013677e-11, -2.159569243281038e-13, -7.495801770642120e-16,
  8.881367457301248e-17, -1.979089470625710e-18,  4.352578619288008e-21,  1.247962298192278e-21, -4.699076523107539e-23,  1.304456244075342e-03, -2.174106755796835e-05,
  3.017783410814019e-07, -3.893483418252356e-09,  4.748512504186769e-11, -5.250119120737427e-13,  4.399781012198654e-15, -5.734223505986784e-18, -5.144885012042076e-19,
 -3.102879735116920e-21,  7.421640199714866e-22, -2.672195939829707e-23,  7.056374139847300e-04, -1.176386353656358e-05,  1.637252645331176e-07, -2.150873660897094e-09,
  2.865650094556748e-11, -4.320588304263555e-13,  8.003004463277538e-15, -1.618946292764089e-16,  2.677111945647782e-18, -1.517730058431152e-20, -9.199984067400795e-22,
  3.802849714560606e-23,  1.586829519026528e-04, -2.646569509069206e-06,  3.698931421515963e-08, -4.996676346552937e-10,  7.510444750732638e-12, -1.506287387432073e-13,
  3.846915646765419e-15, -9.499173635548462e-17,  1.726133604556148e-18, -1.016290383012032e-20, -6.383359647356827e-22,  2.670934059374659e-23,  1.505611278298553e-05,
 -2.512748854241396e-07,  3.534618448306664e-09, -4.976077346729088e-11,  8.705970241926933e-13, -2.228707200114736e-14,  6.749978447895120e-16, -1.806573538166149e-17,
  3.454309947329631e-19, -2.428812196912634e-21, -1.136734268520004e-22,  5.040890872539858e-24,  5.383214846529797e-07, -8.993418825975471e-09,  1.278005773503534e-10,
 -1.914140047479690e-12,  4.029752341727151e-14, -1.267501514376941e-15,  4.274184357278194e-17, -1.206394881871214e-18,  2.434742705780063e-20, -2.179783315531271e-22,
 -6.018625452272426e-24,  3.047870823187104e-25,  5.444561800300643e-09, -9.112142514492367e-11,  1.317845469210305e-12, -2.179396914276057e-14,  5.760380337268654e-16,
 -2.167267622165004e-17,  7.938361672939878e-19, -2.364990219507970e-20,  5.161323716715055e-22, -6.262270379715710e-24, -5.341924098479377e-26,  4.461858793015640e-27,
  7.208400235976692e-12, -1.211162963012057e-13,  1.820515960479064e-15, -3.637224447019625e-17,  1.302698997686281e-18, -5.846387413503899e-20,  2.348274413110877e-21,
 -7.654034960708880e-23,  1.940674608195386e-24, -3.561032324045134e-26,  3.814055458440406e-28, -5.112360518699238e-31,  7.052256690493619e-04, -1.125354667185135e-05,
  1.495407285958870e-07, -1.844807763789638e-09,  2.131830709066497e-11, -2.108604055060867e-13,  9.226689134169741e-16,  3.424438618695654e-17, -1.321766437878839e-18,
  2.380102926316922e-20, -2.871160594094989e-23, -1.359075802684320e-23,  1.222041751187847e-03, -1.950157322906002e-05,  2.592869595513634e-07, -3.212073784691701e-09,
  3.801835931439113e-11, -4.231525534871036e-13,  4.021331720328084e-15, -2.017763330454595e-17, -3.181328043356164e-19,  9.251107991394583e-21,  1.547185012647336e-23,
 -7.783158460131695e-24,  6.610483128100447e-04, -1.055010468867744e-05,  1.404106405631827e-07, -1.752438599197012e-09,  2.161606266719687e-11, -2.853907506350229e-13,
  4.552791905827346e-15, -8.934384056307997e-17,  1.789196593043429e-18, -2.744574992468636e-20,  1.036662802417582e-22,  1.058278572129312e-23,  1.486531464047336e-04,
 -2.372796618283310e-06,  3.162892692961267e-08, -3.993824206621943e-10,  5.236032700623594e-12, -8.444278700697512e-14,  1.881727883306271e-15, -4.862478477433840e-17,
  1.125525487069863e-18, -1.852016101417386e-20,  7.689638481970367e-23,  7.292446998748153e-24,  1.410408122967792e-05, -2.251785772577677e-07,  3.008789640764746e-09,
 -3.866773557686066e-11,  5.519108873280639e-13, -1.101093140544418e-14,  3.066566382905367e-16, -8.928691921269642e-18,  2.184135676292036e-19, -3.752990726383482e-21,
  1.993576697431816e-23,  1.320006853975144e-24,  5.042604719722232e-07, -8.053547442325674e-09,  1.080156549931866e-10, -1.426450071475078e-12,  2.288946205929422e-14,
 -5.673533355412675e-16,  1.848876387087977e-17, -5.776571160911463e-19,  1.470431388129024e-20, -2.658713183774129e-22,  1.909081810985845e-24,  7.332836340435904e-26,
  5.099690312192524e-09, -8.149529759647788e-11,  1.100126350602862e-12, -1.520414175994871e-14,  2.882018844616174e-16, -8.915485894229694e-18,  3.279121873267605e-19,
 -1.083961675032300e-20,  2.888438772754427e-22, -5.638901579621857e-24,  5.754209965588686e-26,  8.312677680085502e-28,  6.750703292454059e-12, -1.080158271347966e-13,
  1.478723008291952e-15, -2.243768552624060e-17,  5.550351128023605e-19, -2.188554485412532e-20,  9.026144241916610e-22, -3.204728981615961e-23,  9.274584964869989e-25,
 -2.097170993840807e-26,  3.344623432025397e-28, -2.318718105401559e-30,  6.624717037400202e-04, -1.014028442341625e-05,  1.293150277814891e-07, -1.535999459606721e-09,
  1.737876200324086e-11, -1.812281574709443e-13,  1.411588018369202e-15,  4.618588160577830e-18, -5.777665719543335e-19,  1.611759136812208e-20, -2.555119106934960e-22,
  3.309954357155064e-25,  1.147953724737693e-03, -1.757172624794603e-05,  2.241289758494082e-07, -2.666449537944095e-09,  3.046999890236525e-11, -3.342714231102376e-13,
  3.361871781154321e-15, -2.538090796402909e-17, -2.721446921602697e-20,  6.076437835956038e-21, -1.180133337772819e-22,  4.665205339222103e-26,  6.209690515709723e-04,
 -9.505456059949672e-06,  1.212853239982577e-07, -1.447052701142251e-09,  1.682800878653837e-11, -2.005408762647075e-13,  2.713715592553793e-15, -4.647650683596376e-17,
  9.454052406307648e-19, -1.843258635294173e-20,  2.653903999621844e-22, -7.857287190235337e-25,  1.396395287142341e-04, -2.137625796500158e-06,  2.729010802638512e-08,
 -3.270602404115717e-10,  3.907046115093626e-12, -5.213253211432374e-14,  9.310845750261323e-16, -2.225750730447832e-17,  5.615865276154766e-19, -1.214602441396757e-20,
  1.848385020396741e-22, -6.489540544778687e-25,  1.324876149538866e-05, -2.028286999362726e-07,  2.591586967138830e-09, -3.127134965761941e-11,  3.886184544203764e-13,
 -5.978693946744448e-15,  1.357525569286204e-16, -3.872265854995421e-18,  1.059800716184540e-19, -2.385329456067920e-21,  3.772855528245705e-23, -1.752227136388285e-25,
  4.736739432619074e-07, -7.252395404682344e-09,  9.278632767326029e-11, -1.131535714584918e-12,  1.490912527244747e-14, -2.727513531500371e-16,  7.592690600284532e-18,
 -2.415844436957561e-19,  6.936521470913599e-21, -1.612128752184106e-22,  2.676320268041360e-24, -1.711658665479661e-26,  4.790251387983788e-09, -7.335691199816975e-11,
  9.406032760082420e-13, -1.167843100835461e-14,  1.686702439115005e-16, -3.813874184270254e-18,  1.266830402797255e-19, -4.365680875063599e-21,  1.306938382286818e-22,
 -3.163888683681270e-24,  5.656723732820191e-26, -5.192597574079828e-28,  6.340771607059368e-12, -9.713899951658517e-14,  1.251416220070956e-15, -1.613462598531424e-17,
  2.759590131929352e-19, -8.247818454355122e-21,  3.243931518586207e-22, -1.209559530977476e-23,  3.844593970038607e-25, -1.005218313121097e-26,  2.069908069106181e-28,
 -2.972930194528855e-30,  6.238691959697679e-04, -9.175028572371622e-06,  1.124377906549369e-07, -1.285082490441869e-09,  1.409468268494401e-11, -1.474195631826927e-13,
  1.355793212025545e-15, -6.453216303226276e-18, -1.669395557397554e-19,  7.294631207918223e-21, -1.708653581507299e-22,  2.499323777230550e-24,  1.081061298210345e-03,
 -1.589887698881728e-05,  1.948496232416436e-07, -2.228270223699035e-09,  2.453408913509918e-11, -2.620423874340767e-13,  2.665648333993352e-15, -2.361566334724856e-17,
  1.132485369588401e-19,  2.016241073358764e-21, -7.670716454564856e-23,  1.263926378831733e-24,  5.847839031315610e-04, -8.600338582771428e-06,  1.054142095699403e-07,
 -1.206740522385579e-09,  1.337839793629027e-11, -1.481519958477998e-13,  1.750061213169349e-15, -2.492040832681680e-17,  4.558723345151844e-19, -9.375973085654020e-21,
  1.763798618085779e-22, -2.421168926538044e-24,  1.315022153216462e-04, -1.934013380671345e-06,  2.370948567290509e-08, -2.718546202573478e-10,  3.046335092507719e-12,
 -3.558953952530718e-14,  5.033690007243321e-16, -9.953040744274311e-18,  2.446378280362691e-19, -5.908692725684480e-21,  1.198177171070700e-22, -1.721955483766842e-24,
  1.247667396787060e-05, -1.834994205273628e-07,  2.250179476863867e-09, -2.586391130133296e-11,  2.945230264996406e-13, -3.707942403746111e-15,  6.385016684422393e-17,
 -1.586025654807507e-18,  4.436923306755029e-20, -1.133414974734533e-21,  2.369254653897215e-23, -3.526031401283968e-25,  4.460681937157118e-07, -6.560723275137515e-09,
  8.048589708519031e-11, -9.286394487038575e-13,  1.083785279121788e-14, -1.512850677766427e-16,  3.200121934307542e-18, -9.368300165679394e-20,  2.822487853083919e-21,
 -7.462892590466361e-23,  1.603191251499227e-24, -2.496800986859574e-26,  4.511044094525587e-09, -6.635167204924640e-11,  8.145766573113584e-13, -9.458995060825853e-15,
  1.149441672857890e-16, -1.858583959860671e-18,  4.870484583246022e-20, -1.617933378253821e-21,  5.146877676979816e-23, -1.406954436906164e-24,  3.137209914393965e-26,
 -5.241046295867392e-28,  5.971104346765447e-12, -8.783734277642904e-14,  1.079956723424014e-15, -1.270983247140030e-17,  1.673784927166104e-19, -3.419601178215233e-21,
  1.135376870891560e-22, -4.225219227872232e-24,  1.425429869907140e-25, -4.107612666061008e-27,  9.843435175588812e-29, -1.878171012691534e-30,  5.888755510465956e-04,
 -8.333589384059323e-06,  9.827813218650653e-08, -1.081456352635780e-09,  1.145480074004761e-11, -1.174518150268713e-13,  1.131587163874332e-15, -8.707662442137459e-18,
 -2.501922611355780e-21,  2.461427450124918e-21, -7.751432774614153e-23,  1.618086240879594e-24,  1.020422958772519e-03, -1.444074050627575e-05,  1.703033697764978e-07,
 -1.874392355875754e-09,  1.988176897479943e-11, -2.055436831625464e-13,  2.062440187507900e-15, -1.931911371411476e-17,  1.431312376435368e-19, -4.513240371822906e-23,
 -2.995427233850505e-23,  7.934982941607903e-25,  5.519823216513090e-04, -7.811520961474308e-06,  9.212667678053502e-08, -1.014319535886142e-09,  1.078621029590785e-11,
 -1.131435230274773e-13,  1.214330012280461e-15, -1.456894146514200e-17,  2.213935371910737e-19, -4.247256310283898e-21,  8.653843933464314e-23, -1.565447447452499e-24,
  1.241259559559572e-04, -1.756608159084800e-06,  2.071809005558973e-08, -2.282322502680772e-10,  2.436626149775389e-12, -2.613529297872526e-14,  3.080804742500828e-16,
 -4.742757543162611e-18,  1.012833636010011e-19, -2.474301746224635e-21,  5.671705545519251e-23, -1.084636645655782e-24,  1.177681976846496e-05, -1.666645020611005e-07,
  1.965873970748751e-09, -2.167418988622620e-11,  2.327817908152345e-13, -2.579883128627594e-15,  3.432252442481788e-17, -6.645293061148802e-19,  1.719537248244235e-20,
 -4.605182777565964e-22,  1.098528516519091e-23, -2.152477167361191e-25,  4.210463864559299e-07, -5.958669518252993e-09,  7.029427050197509e-11, -7.760025483531804e-13,
  8.411368562396321e-15, -9.784375039151479e-17,  1.514164760434532e-18, -3.595850984480692e-20,  1.050739037596909e-21, -2.961550610873605e-23,  7.252830358305131e-25,
 -1.455660392242202e-26,  4.257992603740819e-09, -6.026030287654811e-11,  7.110472429139200e-13, -7.866327763720412e-15,  8.658358755886507e-17, -1.086363920067398e-18,
  2.033236113646773e-20, -5.800386029866496e-22,  1.849334382763903e-23, -5.420710886232621e-25,  1.365356765042684e-26, -2.836165514894282e-28,  5.636126763170653e-12,
 -7.976663728227970e-14,  9.416387964091735e-16, -1.046332274247329e-17,  1.188239017799580e-19, -1.712026556636974e-21,  4.144205239068889e-23, -1.411351803999741e-24,
  4.866528841333783e-26, -1.495197751425509e-27,  3.950111670769867e-29, -8.775441126058611e-31,  5.570356277898880e-04, -7.596327874795148e-06,  8.632735346879556e-08,
 -9.155784376645028e-10,  9.357829272262738e-12, -9.316495247603090e-14,  8.964235668882481e-16, -7.847195422637812e-18,  4.473427142633371e-20,  4.911480738723220e-22,
 -2.753836742622324e-23,  7.241933047099794e-25,  9.652496404762487e-04, -1.316317236895152e-05,  1.495918839481834e-07, -1.586656314193649e-09,  1.622470848523001e-11,
 -1.620270358250988e-13,  1.584082854689519e-15, -1.493746376781197e-17,  1.269109329000556e-19, -7.004023264095618e-22, -6.245483213893438e-24,  3.236723939625747e-25,
  5.221371036970661e-04, -7.120423361828985e-06,  8.092042532606379e-08, -8.583855410243465e-10,  8.785351709353666e-12, -8.821462724125003e-14,  8.866632276511956e-16,
 -9.380721403152621e-18,  1.167114426714646e-19, -1.892557767013125e-21,  3.722404465290373e-23, -7.408895776933648e-25,  1.174145534413734e-04, -1.601193140566710e-06,
  1.819716167231507e-08, -1.930656209511593e-10,  1.978696771277042e-12, -2.003742568812756e-14,  2.099076256750637e-16, -2.570412187426052e-18,  4.334184619939015e-20,
 -9.664356691428774e-22,  2.296004237610673e-23, -4.982877415316697e-25,  1.114005305614177e-05, -1.519182128691473e-07,  1.726558032306688e-09, -1.832308336140497e-11,
  1.881804219291416e-13, -1.929945648338248e-15,  2.143631153646951e-17, -3.108198450857411e-19,  6.609162704961250e-21, -1.712229050234298e-22,  4.342234812062789e-24,
 -9.705242634305162e-26,  3.982804887762321e-07, -5.431412939162648e-09,  6.173075546773233e-11, -6.553860239928822e-13,  6.752433458923761e-15, -7.059915816191781e-17,
  8.512857283109384e-19, -1.487698938178265e-20,  3.779142336222380e-22, -1.067934149496880e-23,  2.808917012031108e-25, -6.412275839967137e-27,  4.027761566789603e-09,
 -5.492746017723605e-11,  6.243195885307416e-13, -6.632812329622595e-15,  6.870160464733236e-17, -7.412101169367415e-19,  1.007002964022883e-20, -2.160073678635321e-22,
  6.322510248215664e-24, -1.898394237264001e-25,  5.145159687558422e-27, -1.203795445825764e-28,  5.331373793718916e-12, -7.270575325478294e-14,  8.265008416557147e-16,
 -8.792837455131377e-18,  9.206125675538407e-20, -1.056137628202230e-21,  1.742994128255771e-23, -4.740418218361424e-25,  1.573546644418706e-26, -5.001754930750265e-28,
  1.410620084846829e-29, -3.447839176785139e-31,  5.279653858179189e-04, -6.947245857259212e-06,  7.618086466275449e-08, -7.796622749302295e-10,  7.692756474580914e-12,
 -7.411560231033245e-14,  6.981945622176378e-16, -6.293460413785472e-18,  4.872088600872389e-20, -1.371667871620653e-22, -7.226988183470203e-24,  2.610821829637721e-25,
  9.148757569327711e-04, -1.203841721403080e-05,  1.320089641605402e-07, -1.351053918965633e-09,  1.333273797948022e-11, -1.285935583397835e-13,  1.218690424842810e-15,
 -1.130542144026621e-17,  9.984192276433056e-20, -7.490190825578152e-22,  2.130373432055272e-24,  9.058802607032533e-26,  4.948881055024099e-04, -6.511999839003796e-06,
  7.140848889857639e-08, -7.308604735118661e-10,  7.214529689350718e-12, -6.971867908218194e-14,  6.677750143975557e-16, -6.502779814094194e-18,  6.896621906389932e-20,
 -9.023839611447890e-22,  1.543905334635393e-23, -3.049432044655258e-25,  1.112869842473874e-04, -1.464373581318795e-06,  1.605793019860951e-08, -1.643607488906671e-10,
  1.623189981778899e-12, -1.573332106193996e-14,  1.531719880164347e-16, -1.599004127704423e-18,  2.080492209040761e-20, -3.796050626833454e-22,  8.570617053559886e-24,
 -1.955875192492699e-25,  1.055868118519259e-05, -1.389368366120288e-07,  1.523555947095069e-09, -1.559562664555932e-11,  1.541244003317811e-13, -1.500689374760308e-15,
  1.496491464504476e-17, -1.714403777381287e-19,  2.741925118585250e-21, -6.177758807199362e-23,  1.561539653209573e-24, -3.735600628771273e-26,  3.774951795532921e-07,
 -4.967289478338008e-09,  5.447102080583649e-11, -5.576538057297693e-13,  5.516816217180353e-15, -5.409009480170234e-17,  5.589531775320015e-19, -7.228234825703617e-21,
  1.411103200152172e-22, -3.665911712038401e-24,  9.859124587540845e-26, -2.423508596861998e-27,  3.817561738513420e-09, -5.023364173260381e-11,  5.508697513170349e-13,
 -5.640762768310982e-15,  5.590010509433642e-17, -5.543639586364095e-19,  6.058755093641631e-21, -9.193802138656397e-23,  2.174141978289584e-24, -6.268672481430199e-26,
  1.761003715145612e-27, -4.434612835992335e-29,  5.053139936437466e-12, -6.649223860537870e-14,  7.291909819201657e-16, -7.469779917606274e-18,  7.428212950952040e-20,
 -7.535773875288866e-22,  9.129976878442574e-24, -1.741596746788316e-25,  5.003399875555043e-27, -1.577122744915752e-28,  4.629250997181791e-30, -1.207060536960132e-31,
  5.013388544848858e-04, -6.373237324837228e-06,  6.751729862632609e-08, -6.675830403280583e-10,  6.364622970525304e-12, -5.930344565071126e-14,  5.427726381595977e-16,
 -4.851117709463586e-18,  4.069756600049341e-20, -2.649430206325432e-22, -4.954034535271449e-25,  7.548726809350225e-26,  8.687364258597408e-04, -1.104375523063635e-05,
  1.169962568559507e-07, -1.156817352659952e-09,  1.102947458187691e-11, -1.028067556447633e-13,  9.429660441027847e-16, -8.519760739971803e-18,  7.506351771917034e-20,
 -6.163689892984052e-22,  3.891757858681330e-24,  5.411874827147084e-27,  4.699297340079598e-04, -5.973951483815933e-06,  6.328740530716192e-08, -6.257699754915216e-10,
  5.966848936304749e-12, -5.565395460255635e-14,  5.124295925797934e-16, -4.718392562458393e-18,  4.499999922097787e-20, -4.859106971814536e-22,  6.721172931020959e-24,
 -1.192389237260561e-25,  1.056745187122128e-04, -1.343380635553694e-06,  1.423165181004692e-08, -1.407213147283466e-10,  1.342000951279781e-12, -1.252985085985501e-14,
  1.160549246620577e-16, -1.099642013493325e-18,  1.166933147275900e-20, -1.632068856939597e-22,  3.149874161755724e-24, -7.036072502247197e-26,  1.002618179325531e-05,
 -1.274572190009764e-07,  1.350273046535539e-09, -1.335170866858726e-11,  1.273572315188648e-13, -1.190913306354345e-15,  1.112880603031209e-17, -1.098725275805484e-19,
  1.330540902526780e-21, -2.329370863315836e-23,  5.373383235960095e-25, -1.305510629513405e-26,  3.584571919319274e-07, -4.556865911107548e-09,  4.827528218994447e-11,
 -4.773712498149075e-13,  4.554973621133771e-15, -4.269283032352800e-17,  4.043465091551795e-19, -4.234179703778185e-21,  5.998181046649112e-23, -1.269745586648638e-24,
  3.266444227159423e-26, -8.301666783911520e-28,  3.625032804279377e-09, -4.608303066071746e-11,  4.882046192467417e-13, -4.827915103906575e-15,  4.609169841646026e-17,
 -4.336636338239076e-19,  4.197569619663332e-21, -4.799528016905094e-23,  8.185646255560455e-25, -2.038651033212772e-26,  5.657114951475349e-28, -1.485415853424396e-29,
  4.798297437359132e-12, -6.099813064477712e-14,  6.462220399092583e-16, -6.391321662242626e-18,  6.108195870617176e-20, -5.790713983059685e-22,  5.845971842993472e-24,
 -7.757809815000506e-26,  1.669272908241533e-27, -4.827107490104336e-29,  1.429110426530912e-30, -3.888223713812167e-32,  4.768777763488529e-04, -5.863497506105312e-06,
  6.008033828437069e-08, -5.745734967365051e-10,  5.298540246854508e-12, -4.776853394244648e-14,  4.237426042183336e-16, -3.700270900968308e-18,  3.137640829213448e-20,
 -2.420649009752985e-22,  1.194799776883873e-24,  1.328035390518472e-26,  8.263494658165160e-04, -1.016046105281499e-05,  1.041091984015399e-07, -9.956416893379538e-10,
  9.181648199254018e-12, -8.278620955662717e-14,  7.349192204783884e-16, -6.442858386711602e-18,  5.564424977712577e-20, -4.651693413219728e-22,  3.509866973399767e-24,
 -1.695681401851037e-26,  4.470011529890423e-04, -5.496146681767647e-06,  5.631629988582579e-08, -5.385789992180308e-10,  4.966830034551003e-12, -4.479283460863765e-14,
  3.981637550544360e-16, -3.514973272379380e-18,  3.133046880711409e-20, -2.958427936642891e-22,  3.293530074858218e-24, -4.798598858622400e-26,  1.005184991761648e-04,
 -1.235935131186060e-06,  1.266402172618484e-08, -1.211125114928851e-10,  1.116960911591480e-12, -1.007650459333056e-14,  8.975332810632868e-17, -8.008722487959151e-19,
  7.477776304238927e-21, -8.210435964575012e-23,  1.233503265527431e-24, -2.455207991997697e-26,  9.536989187541228e-06, -1.172629962548082e-07,  1.201537173315943e-09,
 -1.149099521739633e-11,  1.059827273704300e-13, -9.565782316290808e-16,  8.546513327468250e-18, -7.747759389539690e-20,  7.714508850588921e-22, -1.003135449515809e-23,
  1.882726758670011e-25, -4.328914656212964e-27,  3.409675202291027e-07, -4.192400174150960e-09,  4.295753358036988e-11, -4.108321287517780e-13,  3.789526666185111e-15,
 -3.422903419903141e-17,  3.072417935616500e-19, -2.851799835868576e-21,  3.099622287724975e-23, -4.828976593177685e-25,  1.070726068301437e-26, -2.672484848219820e-28,
  3.448161906404227e-09, -4.239722237493280e-11,  4.344248170474844e-13, -4.154771512872932e-15,  3.832988944086630e-17, -3.466373564663530e-19,  3.135062810659382e-21,
 -3.020716620731529e-23,  3.710155880770339e-25, -6.997301270614522e-27,  1.766560530039971e-28, -4.661409273254408e-30,  4.564181080356027e-12, -5.611935742074849e-14,
  5.750307595706550e-16, -5.499685807942949e-18,  5.075320559789779e-20, -4.600795833114681e-22,  4.222993238646047e-24, -4.361392851162690e-26,  6.462385951122610e-28,
 -1.505894100323519e-29,  4.250989222654985e-31, -1.177809173913694e-32,  4.543433473809416e-04, -5.409062309898003e-06,  5.366428728774359e-08, -4.969205429335561e-10,
  4.437029038667445e-12, -3.873624799879205e-14,  3.329517138740978e-16, -2.825737077844566e-18,  2.359740675798178e-20, -1.894008796179435e-22,  1.317906887187611e-24,
 -3.710921089994213e-27,  7.873010673491259e-04, -9.373000757656667e-06,  9.299124246595722e-08, -8.610806819848334e-10,  7.688669842875609e-12, -6.712628163550919e-14,
  5.771145871620117e-16, -4.904630908331491e-18,  4.123318240445515e-20, -3.408692296273030e-22,  2.696545413162628e-24, -1.836284248416822e-26,  4.258785166101069e-04,
 -5.070181967005494e-06,  5.030219936808051e-08, -4.657889088108421e-10,  4.159107444222615e-12, -3.631366676888921e-14,  3.123399322123573e-16, -2.660883926108479e-18,
  2.263490145808936e-20, -1.966165596804181e-22,  1.857748791911567e-24, -2.148872728563648e-26,  9.576858808175526e-05, -1.140147136446021e-06,  1.131160872931681e-08,
 -1.047435091316026e-10,  9.352844880693933e-13, -8.166913888615248e-15,  7.029215515006092e-17, -6.010869801361219e-19,  5.205719735407452e-21, -4.850667677825210e-23,
  5.582174833541056e-25, -8.910913162105152e-27,  9.086327349013352e-06, -1.081748244012531e-07,  1.073222428424001e-09, -9.937870669441704e-12,  8.873977116658567e-14,
 -7.749944040229906e-16,  6.677021213517828e-18, -5.741751531912996e-20,  5.104165493324755e-22, -5.216627821168387e-24,  7.314285995526159e-26, -1.434008433859428e-27,
  3.248554065347953e-07, -3.867478648848861e-09,  3.836997949742228e-11, -3.553010175385231e-13,  3.172736406668217e-15, -2.771494451504644e-17,  2.391430134776889e-19,
 -2.073903041678134e-21,  1.915153532504622e-23, -2.202892415527205e-25,  3.731071831745890e-27, -8.403373790600337e-29,  3.285222107181185e-09, -3.911132880853547e-11,
  3.880309568150818e-13, -3.593133142812491e-15,  3.208714347411938e-17, -2.803962562489709e-19,  2.425411249991872e-21, -2.132211313438722e-23,  2.087188494910658e-25,
 -2.795052998707024e-27,  5.664464955762436e-29, -1.410875492053981e-30,  4.348504776671272e-12, -5.176995684466978e-14,  5.136199777285991e-16, -4.756119066427396e-18,
  4.247652539240240e-20, -3.714499183853580e-22,  3.228392660298950e-24, -2.913185693303771e-26,  3.159537586819472e-28, -5.218362543605930e-30,  1.264554244764542e-31,
 -3.423926423373116e-33  };
  int offset = -8;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 8;
    if (std::isnan(t)) {
      fill_n(rr+offset, 8, 0.5);
      fill_n(ww+offset, 8, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 8; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=8; ++j) {
        const int boxof = it*96+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
